/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.SearchForObjects;
import oracle.jdeveloper.cm.CMException;

public class DBObjectSearch
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField _search;
    private JButton _go;
    private JComboBox _schema;
    private String _schemaName;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private JList _tableList;
    private String _connName;
    private DefaultListModel _model;
    private String _type;

    public DBObjectSearch(String string) {
        this._connName = string;
        this.init();
    }

    public void setType(String string) {
        this._type = string;
    }

    public JList getList() {
        return this._tableList;
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this._connName);
        }
        catch (CMException cMException) {
            this.logger.severe("Could not get Connection:" + cMException.getMessage());
            return null;
        }
    }

    public void clear() {
        this._model.clear();
    }

    public void init() {
        this._search = new JTextField();
        this._search.setEditable(true);
        this._search.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 10) {
                    DBObjectSearch.this.filter();
                }
            }
        });
        this._go = new JButton();
        this._go.setText("Go");
        this._go.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DBObjectSearch.this.filter();
            }
        });
        this._schemaName = null;
        try {
            this._schemaName = this.getConnection().getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            this.logger.severe("Could not get username:" + sQLException.getMessage());
        }
        SQLComboxModel sQLComboxModel = new SQLComboxModel(this.getConnection(), "select username from sys.all_users order by username", null, this._schemaName);
        sQLComboxModel.setDelayed(true);
        this._schema = new JComboBox(sQLComboxModel);
        this._schema.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Object object = popupMenuEvent.getSource();
                if (object instanceof JComboBox && ((JComboBox)object).getModel() instanceof SQLComboxModel) {
                    ((SQLComboxModel)((JComboBox)object).getModel()).load();
                }
            }
        });
        this._schema.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DBObjectSearch.this.filter();
                }
            }
        });
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(true);
        JScrollPane jScrollPane = new JScrollPane(this._tableList);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)this._search, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this._go, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._schema, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(2, 1, 0, 0), 0, 0));
    }

    public void filter() {
        SearchForObjects searchForObjects = new SearchForObjects(this._connName, this._schemaName, this._search.getText()){

            public void finish(Object object) {
                ArrayList arrayList = (ArrayList)object;
                for (URL uRL : arrayList) {
                    ((DefaultListModel)DBObjectSearch.this._tableList.getModel()).addElement(uRL);
                }
            }

            public void preWork() {
                ((DefaultListModel)DBObjectSearch.this._tableList.getModel()).clear();
            }
        };
        searchForObjects.setTypes(this._type);
        searchForObjects.setFilter(this._schema.getSelectedItem() + "." + this._search.getText());
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Searching", null, 500, searchForObjects, null);
        delayedProgressRunnable.setCancellable(true);
        delayedProgressRunnable.start();
    }
}

