/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Container;
import java.sql.Connection;
import java.text.Collator;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionNameCellRenderer;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class DBConnectionComboBox {
    private JComboBox _dbConns;
    private Connections _conns;
    private DefaultComboBoxModel _model;

    public DBConnectionComboBox() {
        this.init();
    }

    public DBConnectionComboBox(Container container) {
        this.init();
        this.add(container);
    }

    public void init() {
        this._conns = Connections.getInstance();
        this._model = new DefaultComboBoxModel();
        this._dbConns = new JComboBox(this._model);
        this._dbConns.setRenderer(new DBConnectionNameCellRenderer());
        this._conns.getCm().addConnectionListener((ConnectionListener)new ConnListener());
        String string = null;
        if (EditorManager.getEditorManager().getCurrentEditor() instanceof IDBEditor) {
            try {
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor != null && editor instanceof IDBEditor && ((IDBEditor)editor).getDatabase() != null) {
                    string = ((IDBEditor)editor).getDatabase().getConnectionName();
                }
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                this.setCurrentConnection(string);
            }
        }
        this.populate();
    }

    public void setCurrentConnection(String string) {
        if (string != null) {
            this._model.setSelectedItem(string);
        } else {
            this._dbConns.setSelectedIndex(-1);
        }
    }

    public JComboBox getJComboBox() {
        return this._dbConns;
    }

    public void add(Container container) {
        container.add(this._dbConns);
    }

    public Connection getCurrentConnection() {
        Connection connection = null;
        try {
            String string = this.getCurrentConnectionName();
            if (string != null) {
                connection = this._conns.getConnection(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    public Database getCurrentDatabase() throws DBException {
        Database database = null;
        String string = this.getCurrentConnectionName();
        if (string != null) {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            database = this._conns.getDatabase(string);
            ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        }
        return database;
    }

    public String getCurrentConnectionName() {
        String string = null;
        try {
            string = this._dbConns.getItemCount() > 0 && this._dbConns.getSelectedItem() != null ? (String)this._dbConns.getSelectedItem() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void resize() {
        this._dbConns.setSize(this._dbConns.getPreferredSize());
        this._dbConns.setMaximumSize(this._dbConns.getPreferredSize());
    }

    private void populate() {
        Object var2_1 = null;
        String[] stringArray = this._conns.getConnNames();
        Arrays.sort(stringArray, Collator.getInstance());
        for (int i = 0; var2_1 == null && i < stringArray.length; ++i) {
            this.addConnection(stringArray[i]);
        }
    }

    public Connection getConnection(String string) throws CMException {
        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
        Connection connection = this._conns.getConnection(string);
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        return connection;
    }

    public String[] getConnNames() {
        return this._conns.getConnNames();
    }

    public void addConnection(String string) {
        String string2 = this.getCurrentConnectionName();
        boolean bl = false;
        for (int i = 0; i < this._dbConns.getItemCount(); ++i) {
            if (!this._dbConns.getItemAt(i).equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            this._dbConns.addItem(string);
            this.resize();
        }
        if (string2 == null) {
            this._model.setSelectedItem("");
        }
    }

    public void makeNewConnection() {
        String string = null;
        string = ConnectionSelectorUI.getConnection(ConnectionArb.getString((int)159), ConnectionArb.getString((int)158), string, "CLASS_DATABASE", true);
        this.setCurrentConnection(string);
    }

    public void removeConnection(String string) {
        this._model.removeElement(string);
        this.resize();
    }

    private class ConnListener
    implements ConnectionListener {
        private String _lastName;

        private ConnListener() {
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
            String string = ((ConnectionDescriptor)connectionEvent.getSource()).getConnectionName();
            DBConnectionComboBox.this.addConnection(string);
            if (this._lastName != null && this._lastName.equals(((ConnectionDescriptor)connectionEvent.getSource()).get((Object)"PREVIOUS_NAME"))) {
                DBConnectionComboBox.this.setCurrentConnection(string);
            }
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String string = ((ConnectionDescriptor)connectionEvent.getSource()).getConnectionName();
            if (DBConnectionComboBox.this.getCurrentConnectionName() != null && DBConnectionComboBox.this.getCurrentConnectionName().equals(string)) {
                DBConnectionComboBox.this._dbConns.setSelectedIndex(-1);
                this._lastName = string;
            }
            DBConnectionComboBox.this.removeConnection(string);
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }
    }
}

