/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.customtab.CustomTab;
import oracle.ide.controls.customtab.DefaultCustomTabPage;

public class CustomTabbedPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CustomTab _customTab;
    private DefaultListModel _model;
    private JPanel _content;
    private ArrayList<ChangeListener> _listeners = new ArrayList();

    public CustomTabbedPane() {
        this(new DefaultListModel(), 1);
    }

    public CustomTabbedPane(int n) {
        this(new DefaultListModel(), n);
    }

    public CustomTabbedPane(ListModel listModel, int n) {
        this._customTab = new CustomTab(listModel, n);
        this._customTab.setCompressible(true);
        this._customTab.setGradientHighlight(true);
        this._model = (DefaultListModel)listModel;
        this._content = new JPanel(new CardLayout());
        this._content.setBackground(Color.RED);
        this.setLayout(new BorderLayout());
        if (n == 3) {
            this.add((Component)this._customTab, "South");
        } else {
            this.add((Component)this._customTab, "North");
        }
        this.add((Component)this._content, "Center");
        if (this._model.getSize() > 0) {
            for (int i = 0; i < this._model.getSize(); ++i) {
                ((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()).setVisible(false);
                this._content.add((Component)((JPanel)((DefaultCustomTabPage)this._model.get(i)).getUserObject()), ((DefaultCustomTabPage)this._model.get(i)).getLabel());
            }
            this.setSelectedIndex(0);
        }
        this._customTab.addSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CustomTabbedPane.this._customTab.getSelectedPage();
                CustomTabbedPane.this.setSelectedIndex(n);
            }
        });
    }

    public Component getActivePanel() {
        return this._content.getComponent(this._customTab.getSelectedPage());
    }

    public void setSelectedIndex(int n) {
        if (this._customTab.getSelectedPage() != n) {
            this._customTab.setSelectedPage(n);
        }
        String string = ((DefaultCustomTabPage)this._model.get(n)).getLabel();
        ((CardLayout)this._content.getLayout()).show(this._content, string);
        ((JComponent)this._content.getComponent(n)).grabFocus();
        this.fireChangeListeners();
    }

    public void removeSelectedTab() {
        this._model.removeElementAt(this.getSelectedIndex());
        this._content.remove(this.getSelectedIndex() + 1);
        this.fireChangeListeners();
    }

    public void removeAllTabs() {
        this._model.clear();
        this._content.removeAll();
    }

    public void addTab(Icon icon, String string, Component component) {
        DefaultCustomTabPage defaultCustomTabPage = new DefaultCustomTabPage(icon, string, (Object)component);
        defaultCustomTabPage.setTooltip(string);
        this._model.addElement(defaultCustomTabPage);
        this._content.add(component, string);
        this.setSelectedIndex(0);
    }

    public DefaultListModel getTabModel() {
        return this._model;
    }

    public int getSelectedIndex() {
        return this._customTab.getSelectedPage();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._listeners.remove(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listeners.add(changeListener);
    }

    public void fireChangeListeners() {
        for (int i = 0; i < this._listeners.size(); ++i) {
            this._listeners.get(i).stateChanged(new ChangeEvent(this));
        }
    }

    public static void main(String[] stringArray) {
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        for (int i = 1; i < 10; ++i) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(Color.BLUE);
            jPanel.add((Component)new JTextField("tab" + i), "Center");
            String string = "tab" + i;
            customTabbedPane.addTab(null, string, jPanel);
        }
        JDialog jDialog = new JDialog();
        jDialog.add(customTabbedPane);
        jDialog.setSize(400, 400);
        jDialog.setVisible(true);
    }

    public int getNumberOfTabs() {
        return this._customTab.getModel().getSize();
    }
}

