/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.controls.GridBagConstraints2;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.CMUtils;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionType;
import oracle.jdeveloper.cm.dt.ConnectionEditor;

public class ConnectionSelectorUI
extends JPanel
implements ActionListener,
ItemListener {
    private Logger logger = Logger.getLogger(ConnectionSelectorUI.class.getName());
    public static boolean SELECTOR_ACTIVE = false;
    private String[] _types;
    private boolean _oracleOnly;
    private BorderLayout mainLayout = new BorderLayout();
    private JPanel subPanel = new JPanel();
    private GridBagLayout subLayout = new GridBagLayout();
    private JWrappedLabel connectionPrompt = new JWrappedLabel();
    private JLabel connectionLabel = new JLabel();
    protected JComboBox connectionsCombo = null;
    protected JButton newButton = new JButton();
    private JButton editButton = new JButton();
    private GridBagLayout detailsLayout = new GridBagLayout();
    private JPanel detailsPanel = new JPanel();
    private JLabel usernameLabel = new JLabel();
    private JLabel usernameField = new JLabel();
    private JLabel driverLabel = new JLabel();
    private JLabel driverField = new JLabel();
    private JLabel urlLabel = new JLabel();
    private JLabel urlField = new JLabel();
    private DBConnectionComboBox _dbConn = null;
    public static final String CONN_PANEL_SETTINGS_KEY = "ConnectionPanelSettings";
    public static final String LAST_CONNECTION_KEY = "lastConnection";

    protected ConnectionSelectorUI() {
        this(false);
    }

    protected ConnectionSelectorUI(boolean bl) {
        this._oracleOnly = bl;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "", exception);
        }
    }

    public ConnectionSelectorUI(String string, boolean bl) {
        this();
        String[] stringArray;
        if (string == null) {
            if (bl) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "JDBC";
            } else {
                String[] stringArray3 = new String[4];
                stringArray3[0] = "JDBC";
                stringArray3[1] = "OTHER_JDBC";
                stringArray3[2] = "JDBC_ODBC";
                stringArray = stringArray3;
                stringArray3[3] = "ORACLE_LITE";
            }
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = string;
        }
        String[] stringArray5 = stringArray;
        this.setConnectionInfo(stringArray5, bl);
    }

    public ConnectionSelectorUI(String string) {
        this();
        String[] stringArray = null;
        try {
            stringArray = ConnectionManager.getInstance().getConnectionTypeNamesForClass(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setConnectionInfo(stringArray, false);
    }

    public ConnectionSelectorUI(String[] stringArray) {
        this();
        this.setConnectionInfo(stringArray, false);
    }

    public Component getDefaultFocusComponent() {
        if (this.connectionsCombo.getItemCount() < 1) {
            return this.newButton;
        }
        return this.connectionsCombo;
    }

    public JComboBox getConnCombo() {
        return this.connectionsCombo;
    }

    private void setConnectionInfo(String[] stringArray, boolean bl) {
        this._types = stringArray;
        if (stringArray != null) {
            boolean bl2 = false;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            for (int i = 0; i < stringArray.length; ++i) {
                ConnectionType connectionType = connectionManager.getConnectionType(stringArray[i]);
                if (!"CLASS_DATABASE".equals(connectionType.getConnectionClassName())) continue;
                bl2 = true;
                break;
            }
            this.driverLabel.setVisible(bl2);
            this.driverField.setVisible(bl2);
        }
    }

    public static String getConnection(String string, String string2, String string3, String string4, boolean bl) {
        return ConnectionSelectorUI.getConnection(string, string2, string3, string4, bl, false);
    }

    public static String getConnection(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        SELECTOR_ACTIVE = true;
        final ConnectionSelectorUI connectionSelectorUI = new ConnectionSelectorUI(bl);
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionSelectorUI, "f1_sql_view_connect_html");
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionSelectorUI, (Component)connectionSelectorUI.getDefaultFocusComponent(), (String)string);
        connectionSelectorUI.connectionsCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = connectionSelectorUI.connectionsCombo.getSelectedIndex() != -1;
                jEWTDialog.setOKButtonEnabled(bl);
                connectionSelectorUI.editButton.setEnabled(connectionSelectorUI.connectionsCombo.getModel().getSize() > 0);
            }
        });
        jEWTDialog.setOKButtonEnabled(connectionSelectorUI.connectionsCombo.getModel().getSize() > 0);
        connectionSelectorUI.editButton.setEnabled(connectionSelectorUI.connectionsCombo.getModel().getSize() > 0);
        connectionSelectorUI.setConnectionPrompt(string2);
        String[] stringArray = null;
        try {
            stringArray = ConnectionManager.getInstance().getConnectionTypeNamesForClass(string4);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionSelectorUI.setConnectionInfo(stringArray, bl);
        if (string3 != null) {
            connectionSelectorUI.setConnectionName(string3);
        }
        String string5 = null;
        boolean bl3 = WizardLauncher.runDialog((JDialog)jEWTDialog);
        if (bl3) {
            string5 = connectionSelectorUI.getConnectionName();
            if (bl2 && string5 != null) {
                try {
                    Connection connection = Connections.getInstance().getConnection(string5);
                    connection.isClosed();
                    if (connection != null) {
                        connection.clearWarnings();
                    }
                }
                catch (Exception exception) {
                    CMException cMException;
                    Exception exception2;
                    while (exception2 instanceof CMException && (cMException = (CMException)((Object)exception2)).isWrapper()) {
                        exception2 = cMException.unwrap();
                    }
                    ExceptionHandler.handleException(exception2);
                    return ConnectionSelectorUI.getConnection(string, string2, string3, string4, bl, bl2);
                }
            }
        }
        SELECTOR_ACTIVE = false;
        return string5;
    }

    private void jbInit() throws Exception {
        this._dbConn = this._oracleOnly ? new OracleConnectionComboBox() : new DBConnectionComboBox();
        this.connectionsCombo = this._dbConn.getJComboBox();
        this.connectionPrompt.setText(ControlsArb.getString(6));
        this.connectionPrompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        ResourceUtils.resLabel((JLabel)this.connectionLabel, (Component)this.connectionsCombo, (String)ControlsArb.getString(7));
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)ControlsArb.getString(8));
        ResourceUtils.resButton((AbstractButton)this.editButton, (String)ControlsArb.getString(9));
        this.editButton.setEnabled(false);
        this.usernameLabel.setText(ControlsArb.getString(10));
        this.usernameLabel.setEnabled(false);
        this.driverLabel.setText(ControlsArb.getString(11));
        this.driverLabel.setEnabled(false);
        this.urlLabel.setText(ControlsArb.getString(12));
        this.urlLabel.setEnabled(false);
        this.detailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.detailsPanel.setLayout(this.detailsLayout);
        this.detailsPanel.add((Component)this.usernameLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.usernameField, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverLabel, new GridBagConstraints2(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.driverField, new GridBagConstraints2(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlLabel, new GridBagConstraints2(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.detailsPanel.add((Component)this.urlField, new GridBagConstraints2(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.setLayout(this.subLayout);
        this.subPanel.add((Component)this.connectionLabel, new GridBagConstraints2(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.connectionsCombo, new GridBagConstraints2(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.newButton, new GridBagConstraints2(2, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.detailsPanel, new GridBagConstraints2(0, 1, 2, 2, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.subPanel.add((Component)this.editButton, new GridBagConstraints2(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.mainLayout);
        this.add((Component)this.connectionPrompt, "North");
        this.add((Component)this.subPanel, "Center");
        this.addListeners();
        this._enableButtons();
        ItemEvent itemEvent = new ItemEvent(this.connectionsCombo, 701, new Integer(0), 1);
        this.itemStateChanged(itemEvent);
        this.connectionsCombo.setSelectedItem(this._dbConn.getCurrentConnectionName());
    }

    private void addListeners() {
        this.connectionsCombo.addItemListener(this);
        this.newButton.addActionListener(this);
        this.editButton.addActionListener(this);
    }

    private void removeListeners() {
        this.connectionsCombo.removeItemListener(this);
        this.newButton.removeActionListener(this);
        this.editButton.removeActionListener(this);
    }

    public String getConnectionName() {
        return this._dbConn.getCurrentConnectionName();
    }

    public void setConnectionName(String string) {
        this._dbConn.setCurrentConnection(string);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        try {
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            String string = this._dbConn.getCurrentConnectionName();
            if (string != null) {
                ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(string);
                boolean bl = connectionDescriptor != null;
                this.editButton.setEnabled(bl);
                this.usernameLabel.setEnabled(bl);
                this.usernameField.setText(bl ? connectionDescriptor.getProperty("user") : null);
                this.driverLabel.setEnabled(bl);
                this.driverField.setText(bl ? connectionDescriptor.getProperty("JdbcDriver") : null);
                this.urlLabel.setEnabled(bl);
                this.urlField.setText(bl ? CMUtils.getUrl((String)"JDBC", (ConnectionDescriptor)connectionDescriptor) : null);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.SEVERE, "itemStateChanged", exception);
            this.usernameLabel.setEnabled(false);
            this.usernameField.setText(null);
            this.driverLabel.setEnabled(false);
            this.driverField.setText(null);
            this.urlLabel.setEnabled(false);
            this.urlField.setText(null);
            this.editButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = actionEvent.getSource() == this.editButton;
        int n = bl ? 2 : 1;
        this.editButton.setEnabled(false);
        this.newButton.setEnabled(false);
        ConnectionEditor connectionEditor = new ConnectionEditor();
        if (connectionEditor == null) {
            this._enableButtons();
            return;
        }
        if (connectionEditor.runConnectionEditor(this.getConnectionName(), n, this._types)) {
            ConnectionDescriptor connectionDescriptor = connectionEditor.getConnectionDescriptor();
            String string = connectionDescriptor != null ? connectionDescriptor.getConnectionName() : null;
        }
        this._enableButtons();
    }

    public void setConnectionPrompt(String string) {
        if (string == null) {
            this.remove((Component)this.connectionPrompt);
        } else {
            this.connectionPrompt.setText(string);
            this.add((Component)this.connectionPrompt, "North");
        }
        this.validate();
    }

    public void enableActiveComponents(boolean bl) {
        this.usernameLabel.setEnabled(bl);
        this.usernameField.setEnabled(bl);
        this.driverLabel.setEnabled(bl);
        this.driverField.setEnabled(bl);
        this.urlLabel.setEnabled(bl);
        this.urlField.setEnabled(bl);
        this.connectionLabel.setEnabled(bl);
        this.connectionsCombo.setEnabled(bl);
        if (bl) {
            this._enableButtons();
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    protected void _enableButtons() {
        this.newButton.setEnabled(true);
        this.editButton.setEnabled(true);
    }

    public void loadSettings() {
        String string = null;
        IdeSettings ideSettings = Ide.getSettings();
        DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)ideSettings.getData(CONN_PANEL_SETTINGS_KEY);
        if (dynamicPropertySet != null) {
            string = (String)dynamicPropertySet.getProperty(LAST_CONNECTION_KEY);
            this.connectionsCombo.setSelectedItem(string);
        }
    }

    public void saveSettings() {
        String string = (String)this.connectionsCombo.getSelectedItem();
        if (ModelUtil.hasLength((String)string)) {
            IdeSettings ideSettings = Ide.getSettings();
            DynamicPropertySet dynamicPropertySet = (DynamicPropertySet)ideSettings.getData(CONN_PANEL_SETTINGS_KEY);
            if (dynamicPropertySet == null) {
                dynamicPropertySet = new DynamicPropertySetImpl();
                ClientSetting.findOrCreate((String)"oracle.onlinedb").putData(CONN_PANEL_SETTINGS_KEY, (Copyable)dynamicPropertySet);
            }
            dynamicPropertySet.setProperty(LAST_CONNECTION_KEY, (Object)string);
        }
    }
}

