/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.conntypes;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.dbtools.raptor.conntypes.RaptorClassLoader;
import oracle.ide.Ide;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionWrapper;

public final class RaptorConnectionWrapper
implements ConnectionWrapper {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("oracle.jdeveloper.cm.ConnectionRtBundle");
    private ConnectionDescriptor m_desc;
    private Connection m_conn;
    private static final String TNS_STRING = "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={0})(PORT={1})))(CONNECT_DATA=(SID={2})))";
    private static final String ORACLE_URL_PREFIX = "jdbc:oracle:";
    private static final String OLITE_URL_PREFIX = "jdbc:polite:";
    private static final String OLITE4_URL_PREFIX = "jdbc:polite4";
    private static final String ODBC_URL_PREFIX = "jdbc:odbc:";
    private static final Set BUILT_IN_PROPS = new HashSet();

    public RaptorConnectionWrapper(ConnectionDescriptor connectionDescriptor) throws CMException {
        this.m_desc = connectionDescriptor;
    }

    public ConnectionDescriptor getDescriptor() {
        return this.m_desc;
    }

    public Object getPresentation(String string) throws CMException {
        if (!string.equals("JDBC")) {
            throw new CMException("Cannot find presentation for " + string + " in this ConnectionWrapper instance");
        }
        return this.getJdbcConnection();
    }

    public boolean containsPresentation(String string) {
        return string.equals("JDBC");
    }

    public Iterator getPresentationIterator() {
        return Collections.singletonList("JDBC").iterator();
    }

    public void closeConnection() {
        if (this.m_conn != null) {
            try {
                this.m_conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_conn = null;
        }
    }

    public void testPresentation(String string) throws CMException {
        this.createConnection();
    }

    private Connection createConnection() throws CMException {
        Object object;
        Connection connection = null;
        Properties properties = new Properties();
        String string = this.m_desc.getRole();
        if (null != string && !string.equals("") && !string.equals("Normal")) {
            properties.put("internal_logon", string);
        }
        String string2 = this.m_desc.getUsername();
        String string3 = this.m_desc.getPassword();
        if (this.m_desc.getProperty("ORACLE_JDBC_TYPE") != null && (string2 == null || string3 == null || string3.trim().length() == 0)) {
            throw new CMException(bundle.getString("ERROR_NULL_USER_PWD"));
        }
        if (null != string2) {
            properties.put("user", string2);
        }
        if (null != string3) {
            properties.put("password", string3);
        }
        String string4 = RaptorConnectionWrapper.getURL(this.m_desc);
        String string5 = this.m_desc.getJdbcDriver();
        if (string5 == null) {
            throw new CMException("No driver specified.");
        }
        String string6 = this.m_desc.getProperty("RaptorConnectionType");
        if (string6 != null && string6.equals("TimesTen") && (object = this.m_desc.getProperty("ormi-password")) != null) {
            this.m_desc.remove((Object)"ormi-password");
            this.m_desc.put((Object)"oraclePassword", object);
        }
        for (Object e : this.m_desc.keySet()) {
            if (BUILT_IN_PROPS.contains(e)) continue;
            properties.put(e, this.m_desc.get(e));
        }
        try {
            connection = RaptorConnectionWrapper.createConnectionImpl(string5, string4, properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CMException("Unable to find driver: " + string5);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CMException("Unable to register driver: " + string5);
        }
        catch (InstantiationException instantiationException) {
            throw new CMException("Unable to instantiate driver: " + string5);
        }
        catch (SQLException sQLException) {
            throw new CMException((Exception)sQLException);
        }
        return connection;
    }

    private Connection getJdbcConnection() throws CMException {
        if (this.m_conn == null) {
            this.m_conn = this.createConnection();
        }
        return this.m_conn;
    }

    private static Connection createConnectionImpl(String string, String string2, Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, SQLException {
        ClassLoader classLoader = RaptorClassLoader.findClassLoader(string);
        Class<?> clazz = classLoader != null ? Class.forName(string, true, classLoader) : Class.forName(string);
        Driver driver = (Driver)clazz.newInstance();
        String string3 = System.getProperty("jdbc.terminal", "UNKNOWN");
        String string4 = "UNKNOWN";
        try {
            string4 = System.getProperty("jdbc.machine", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string5 = System.getProperty("user.name", "UNKNOWN");
        String string6 = System.getProperty("jdbc.program", Ide.getProgramShortName());
        String string7 = "UNKNOWN";
        String string8 = System.getProperty("java.vm.name");
        if (!(System.getProperty("disablePIDCheck") != null || string8 != null && string8.equals("OJVM Client VM"))) {
            string7 = ManagementFactory.getRuntimeMXBean().getName();
        }
        String string9 = System.getProperty("jdbc.pid", string7);
        properties.setProperty("v$session.terminal", string3);
        properties.setProperty("v$session.machine", string4);
        properties.setProperty("v$session.osuser", string5);
        properties.setProperty("v$session.program", string6);
        properties.setProperty("v$session.process", string9);
        Connection connection = null;
        try {
            connection = driver.connect(string2, properties);
            if (connection == null) {
                throw new SQLException(bundle.getString("ERROR_INVALID_URL"), "08001");
            }
        }
        catch (LinkageError linkageError) {
            throw new SQLException("Error loading native JDBC driver library");
        }
        return connection;
    }

    private static String getURL(ConnectionDescriptor connectionDescriptor) throws CMException {
        String string = connectionDescriptor.getURL();
        if (null == string || string.length() < 1) {
            if (connectionDescriptor.getProperty("ConnectionType").equals("JDBC_ODBC")) {
                String string2 = connectionDescriptor.getProperty("DSN");
                if (null == string2) {
                    throw new CMException(bundle.getString("ERROR_NULL_DATASOURCE"));
                }
                return ODBC_URL_PREFIX + string2;
            }
            if (connectionDescriptor.getProperty("ConnectionType").equals("ORACLE_LITE")) {
                String string3 = connectionDescriptor.getProperty("DSN");
                if (null == string3) {
                    String string4 = connectionDescriptor.getProperty("HOSTNAME");
                    String string5 = connectionDescriptor.getProperty("JDBC_PORT");
                    String string6 = connectionDescriptor.getProperty("SID");
                    if (null == string4) {
                        throw new CMException(bundle.getString("ERROR_NULL_HOSTNAME"));
                    }
                    if (null == string5) {
                        throw new CMException(bundle.getString("ERROR_NULL_PORT"));
                    }
                    if (null == string6) {
                        throw new CMException(bundle.getString("ERROR_NULL_SID"));
                    }
                    return "jdbc:polite4@" + string4 + ":" + string5 + ":" + string6;
                }
                return OLITE_URL_PREFIX + string3;
            }
            if (connectionDescriptor.getProperty("ConnectionType").equals("JDBC") || connectionDescriptor.getProperty("ConnectionType").equals("ORACLE_JSERVER")) {
                String string7 = connectionDescriptor.getProperty("ORACLE_JDBC_TYPE");
                String string8 = connectionDescriptor.getProperty("HOSTNAME");
                String string9 = connectionDescriptor.getProperty("JDBC_PORT");
                String string10 = connectionDescriptor.getProperty("SID");
                String string11 = connectionDescriptor.getProperty("ServiceName");
                if (null == string8) {
                    throw new CMException(bundle.getString("ERROR_NULL_HOSTNAME"));
                }
                if (null == string9) {
                    throw new CMException(bundle.getString("ERROR_NULL_PORT"));
                }
                if (null == string7) {
                    throw new CMException(bundle.getString("ERROR_NULL_DRIVER"));
                }
                if (null == string10 && null == string11) {
                    throw new CMException(bundle.getString("ERROR_NULL_SID"));
                }
                String string12 = null;
                string12 = string7.equals("thin") ? (string10 != null ? ORACLE_URL_PREFIX + string7 + ":@" + string8 + ":" + string9 + ":" + string10 : ORACLE_URL_PREFIX + string7 + ":@//" + string8 + ":" + string9 + "/" + string11) : ORACLE_URL_PREFIX + string7 + ":@" + RaptorConnectionWrapper.namedHostToConnString(string8, string9, string10);
                return string12;
            }
        }
        return string;
    }

    private static String namedHostToConnString(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        return MessageFormat.format(TNS_STRING, string, string2, string3);
    }

    static {
        try {
            Class<ConnectionDescriptor> clazz = ConnectionDescriptor.class;
            for (Field field : clazz.getDeclaredFields()) {
                if ((field.getModifiers() & 0x19) == 0 || !String.class.equals(field.getType())) continue;
                BUILT_IN_PROPS.add(field.get(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

