/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.conntypes;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.config.ClientSetting;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;

public class RaptorClassLoader
extends URLClassLoader {
    private static RaptorClassLoader s_instance;
    private URLPath m_path = new URLPath();
    private URLPath m_nativePath = new URLPath();
    private boolean m_libraryLoaded;

    public static void registerClassPath(String string, URLPath uRLPath, URLPath uRLPath2) {
    }

    public static synchronized ClassLoader findClassLoader(String string) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        DBConfig dBConfig = (DBConfig)clientSetting.getData("DBConfig");
        URLPath uRLPath = dBConfig.getThirdPartyPath();
        if (s_instance == null || s_instance.getURLPath() != null && !s_instance.getURLPath().equals((Object)uRLPath)) {
            s_instance = new RaptorClassLoader(uRLPath);
        }
        return s_instance;
    }

    private RaptorClassLoader(URLPath uRLPath) {
        super(RaptorClassLoader.convertPath(uRLPath.getEntries()));
        uRLPath.copyTo((Object)this.m_path);
    }

    private RaptorClassLoader(URLPath uRLPath, URLPath uRLPath2) {
        this(uRLPath);
        if (uRLPath2 != null) {
            uRLPath2.copyTo((Object)this.m_nativePath);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        return super.findClass(string);
    }

    public URL findResource(String string) {
        return super.findResource(string);
    }

    protected String findLibrary(String string) {
        this.m_libraryLoaded = true;
        String string2 = System.mapLibraryName(string);
        URL uRL = this.m_nativePath.toBoundURL(string2);
        if (uRL != null) {
            String string3 = URLFileSystem.getPlatformPathName((URL)uRL);
            File file = new File(string3);
            return file.getAbsolutePath();
        }
        return null;
    }

    URLPath getURLPath() {
        return this.m_path;
    }

    private static URL[] convertPath(URL[] uRLArray) {
        int n = uRLArray.length;
        URL[] uRLArray2 = new URL[n];
        for (int i = 0; i < n; ++i) {
            URL uRL = uRLArray[i];
            if (JarUtil.isJarURL((URL)uRL) && !ModelUtil.hasLength((String)JarUtil.getJarEntry((URL)uRL))) {
                uRL = JarUtil.getJarFileURL((URL)uRL);
            }
            uRLArray2[i] = uRL;
        }
        return uRLArray2;
    }
}

