/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.connections.AdvancedPanel;
import oracle.dbtools.raptor.connections.BasicPanel;
import oracle.dbtools.raptor.connections.CDComponentView;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.connections.TNSPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionWrapper;

public class OracleConnectionPanel
extends IConnectionPanel {
    private static final String DRIVER_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
    public static String OCI_URL = "jdbc:oracle:oci8:@";
    private JPanel _panel;
    private BasicPanel _basicPanel;
    private AdvancedPanel _advancedPanel;
    private TNSPanel _tNSPanel;
    private JLabel lblRole = new JLabel();
    private String[] roles = new String[]{"default", "SYSDBA"};
    private JComboBox cbxRole = new JComboBox<String>(this.roles);
    private JRadioButton _btnBasic;
    private JRadioButton _btnTns;
    private JRadioButton _btnAdv;
    private ButtonGroup _btnGroup;
    private CardLayout _layout;
    public static final String HOST = "localhost";
    public static final String PORT = "1521";
    public static final String SID = "xe";
    public static final String ORACLE_CONNECTION_TYPE = "OracleConnectionType";

    public OracleConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this._basicPanel = new BasicPanel(this);
        this._tNSPanel = new TNSPanel(this);
        this._advancedPanel = new AdvancedPanel(this);
        this._layout = new CardLayout(0, 0);
        this._panel = new JPanel(this._layout);
        JLabel jLabel = new JLabel();
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                OracleConnectionPanel.this.togglePanels();
            }
        };
        this._btnBasic = new JRadioButton();
        this._btnBasic.setText("Basic");
        this._btnBasic.setSelected(true);
        this._btnBasic.getModel().addChangeListener(changeListener);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._btnBasic, (String)ConnectionDialogArb.getString(34));
        this._btnTns = new JRadioButton();
        this._btnTns.getModel().addChangeListener(changeListener);
        this._btnTns.setText("TNS");
        this._btnAdv = new JRadioButton();
        this._btnAdv.getModel().addChangeListener(changeListener);
        this._btnAdv.setText("Advanced");
        this._btnGroup = new ButtonGroup();
        this._btnGroup.add(this._btnBasic);
        this._btnGroup.add(this._btnTns);
        this._btnGroup.add(this._btnAdv);
        this._panel.add((Component)this._basicPanel, this._btnBasic.getText());
        this._panel.add((Component)this._tNSPanel, this._btnTns.getText());
        this._panel.add((Component)this._advancedPanel, this._btnAdv.getText());
        ResourceUtils.resLabel((JLabel)this.lblRole, (Component)this.cbxRole, (String)ConnectionDialogArb.getString(12));
        this.add(this.lblRole, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.cbxRole, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._btnBasic, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._btnTns, new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._btnAdv, new GridBagConstraints(3, 1, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this._panel, new GridBagConstraints(0, 2, 8, 1, 1.0, 4.0, 18, 1, new Insets(10, 5, 0, 0), 0, 0));
    }

    private void togglePanels() {
        if (this._btnBasic.isSelected()) {
            this._layout.show(this._panel, this._btnBasic.getText());
        } else if (this._btnTns.isSelected()) {
            this._layout.show(this._panel, this._btnTns.getText());
        } else if (this._btnAdv.isSelected()) {
            this._layout.show(this._panel, this._btnAdv.getText());
        }
    }

    private ConnectionDescriptor getInput(ConnectionDescriptor connectionDescriptor) {
        connectionDescriptor.put((Object)"ConnectionType", (Object)"JDBC");
        connectionDescriptor.put((Object)"JdbcDriver", (Object)DRIVER_CLASS_NAME);
        connectionDescriptor.put((Object)"ORACLE_JDBC_TYPE", (Object)"thin");
        connectionDescriptor.put((Object)"RaptorConnectionType", (Object)"Oracle");
        String string = (String)this.cbxRole.getSelectedItem();
        if (string.equals(this.roles[0])) {
            connectionDescriptor.put((Object)"Role", (Object)"");
        } else {
            connectionDescriptor.put((Object)"Role", (Object)string);
        }
        CDComponentView cDComponentView = this.getPanel();
        cDComponentView.populateComponent(connectionDescriptor);
        return connectionDescriptor;
    }

    private CDComponentView getPanel() {
        if (this._btnBasic.isSelected()) {
            return this._basicPanel;
        }
        if (this._btnTns.isSelected()) {
            return this._tNSPanel;
        }
        if (this._btnAdv.isSelected()) {
            return this._advancedPanel;
        }
        return null;
    }

    public boolean testConnection(String string, String string2) {
        this.setStatus("");
        ConnectionDescriptor connectionDescriptor = this.getConnectionDescriptor();
        this.setStatus(ConnectionDialogArb.getString(26));
        try {
            this.testConnection(connectionDescriptor);
            if (!Thread.currentThread().isInterrupted()) {
                this.setStatus(ConnectionDialogArb.getString(27));
            }
            return true;
        }
        catch (CMException cMException) {
            this.setErrorStatus(ConnectionDialogArb.getString(28) + cMException.getMessage());
            return false;
        }
    }

    protected void testConnection(ConnectionDescriptor connectionDescriptor) throws CMException {
        ConnectionWrapper connectionWrapper = null;
        try {
            Object object;
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            if (connectionDescriptor.getURL().indexOf("jdbc") != 0) {
                object = Connections.getInstance().resovleTNS2JDBCURL(connectionDescriptor.getURL());
                connectionDescriptor.put((Object)"URL", object);
            }
            connectionWrapper = connectionManager.getConnection(connectionDescriptor);
            object = connectionWrapper.getPresentationIterator();
            while (object.hasNext()) {
                connectionWrapper.testPresentation((String)object.next());
            }
            connectionWrapper.closeConnection();
            connectionWrapper = null;
        }
        catch (CMException cMException) {
            throw cMException;
        }
        catch (RuntimeException runtimeException) {
            throw new CMException((Exception)runtimeException);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Error error) {
            throw new CMException(error.getLocalizedMessage());
        }
        finally {
            if (connectionWrapper != null) {
                try {
                    connectionWrapper.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void clear() {
        this._basicPanel.clear();
        this._tNSPanel.clear();
        this._advancedPanel.clear();
    }

    public void updatePrompts(ConnectionDescriptor connectionDescriptor) {
        String string = connectionDescriptor.getHostname();
        String string2 = connectionDescriptor.getRole();
        if (string2 != null && string2.equals("SYSDBA")) {
            this.cbxRole.setSelectedIndex(1);
        } else {
            this.cbxRole.setSelectedIndex(0);
        }
        String string3 = connectionDescriptor.getProperty(ORACLE_CONNECTION_TYPE);
        if (string != null) {
            this._btnBasic.setSelected(true);
            this._basicPanel.tfdHost.setText(string);
            String string4 = connectionDescriptor.getJdbcPort();
            this._basicPanel.tfdPort.setText(string4 != null ? string4 : PORT);
            this._basicPanel.tfdSid.setText(connectionDescriptor.getSid());
            this._basicPanel.tfdService.setText(connectionDescriptor.getProperty("ServiceName"));
            if (connectionDescriptor.getSid() != null && connectionDescriptor.getSid().length() > 0) {
                this._basicPanel.btnSid.setSelected(true);
                this._basicPanel.btnService.setSelected(false);
            } else {
                this._basicPanel.btnService.setSelected(true);
                this._basicPanel.btnSid.setSelected(false);
            }
        } else if (string3 != null && string3.trim().equalsIgnoreCase("tns")) {
            this._btnTns.setSelected(true);
            String string5 = connectionDescriptor.getURL();
            String string6 = string5.substring(string5.lastIndexOf(64) + 1);
            this._tNSPanel.cbxTnsName.setSelectedItem(string6);
            if (this._tNSPanel.cbxTnsName.getSelectedItem() != null && this._tNSPanel.cbxTnsName.getSelectedItem().equals(string6)) {
                this._tNSPanel.btnTns.setSelected(true);
            } else {
                this._tNSPanel.tfdSqlNetName.setText(string6);
                this._tNSPanel.btnSqlNet.setSelected(true);
            }
        } else {
            this._btnAdv.setSelected(true);
            String string7 = connectionDescriptor.getURL();
            this._advancedPanel.tfdUrl.setText(string7);
        }
        connectionDescriptor.put((Object)"ConnectionName", (Object)this.getConnectionName());
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        return this.getInput(this._connDescr);
    }

    public String getDriver() {
        return DRIVER_CLASS_NAME;
    }

    public void setDialog(ConnectionDialog connectionDialog) {
        super.setDialog(connectionDialog);
        this.getDialog().attachEnterKey(this._basicPanel);
        this.getDialog().attachEnterKey(this._advancedPanel);
        this.getDialog().attachEnterKey(this._tNSPanel);
    }

    public void setDefaultPrompts() {
        this._basicPanel.setDefaultPrompts();
    }
}

