/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.connections.ConnectionTypeRegistry;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionDialog
extends JPanel {
    private JButton _btnTest;
    private JButton _btnSave;
    private JButton _btnClear;
    private JButton _btnConnect;
    private JTable _table;
    private CustomTabbedPane _tabs;
    private JSplitPane _sp;
    private JLabel lblUser = new JLabel();
    private JTextField tfdUser = new JTextField(15);
    private JLabel lblPassword = new JLabel();
    private JPasswordField tfdPassword = new JPasswordField(15);
    private JCheckBox chkSavePassword = new JCheckBox();
    private JLabel lblName = new JLabel();
    private JTextField tfdConnName = new JTextField(15);
    private JLabel lblStatus = new JLabel(ConnectionDialogArb.getString(26));
    private JEWTDialog _dlg;
    private KeyAdapter _enterKey;
    private static final String CLEAR = "clear";
    private static final String TEST = "test";
    private static final String SAVE = "save";
    private static final String CONNECT = "connect";

    public ConnectionDialog() {
        this.setLayout(new GridBagLayout());
        this._table = new JTable(new ConnectionModel());
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConnectionDialog.this.tableFocusChanged();
            }
        });
        if (this._btnSave == null) {
            this._btnSave = new JButton();
            this._btnSave.setActionCommand(SAVE);
            ResourceUtils.resButton((AbstractButton)this._btnSave, (String)ConnectionDialogArb.getString(33));
        }
        if (this._btnTest == null) {
            this._btnTest = new JButton();
            this._btnTest.setActionCommand(TEST);
            ResourceUtils.resButton((AbstractButton)this._btnTest, (String)ConnectionDialogArb.getString(22));
        }
        if (this._btnClear == null) {
            this._btnClear = new JButton();
            this._btnClear.setActionCommand(CLEAR);
            ResourceUtils.resButton((AbstractButton)this._btnClear, (String)ConnectionDialogArb.getString(21));
        }
        if (this._btnConnect == null) {
            this._btnConnect = new JButton();
            this._btnConnect.setActionCommand(CONNECT);
            ResourceUtils.resButton((AbstractButton)this._btnConnect, (String)ConnectionDialogArb.getString(23));
        }
        this._table.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = ConnectionDialog.this._table.rowAtPoint(point);
                int n2 = ConnectionDialog.this._table.columnAtPoint(point);
                Object object = ConnectionDialog.this._table.getValueAt(n, n2);
                ConnectionDialog.this._table.setToolTipText(object.toString());
            }
        });
        this._enterKey = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                if (n == 10) {
                    ConnectionDialog.this.processButtons(ConnectionDialog.CONNECT);
                }
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 0, 1, 6, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.lblUser, (Component)this.tfdUser, (String)ConnectionDialogArb.getString(9));
        ResourceUtils.resLabel((JLabel)this.lblPassword, (Component)this.tfdPassword, (String)ConnectionDialogArb.getString(10));
        ResourceUtils.resButton((AbstractButton)this.chkSavePassword, (String)ConnectionDialogArb.getString(11));
        ResourceUtils.resLabel((JLabel)this.lblName, (Component)this.tfdConnName, (String)ConnectionDialogArb.getString(6));
        this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdConnName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.lblUser, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdUser, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.lblPassword, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.tfdPassword, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.chkSavePassword, new GridBagConstraints(1, 3, 1, 2, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        this._tabs = new CustomTabbedPane();
        ArrayList<String> arrayList = ConnectionTypeRegistry.getTabNames();
        for (String string : arrayList) {
            try {
                IConnectionPanel iConnectionPanel = ConnectionTypeRegistry.getPanelFor(string);
                iConnectionPanel.setDialog(this);
                this._tabs.addTab(null, string, (Component)((Object)iConnectionPanel));
            }
            catch (Exception exception) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)("Could not load connection type:" + string + "\n" + exception.getMessage()), (String)"Error", (String)"f1_connectiontype_load_err_html");
            }
        }
        this._tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConnectionDialog.this._tabs.getSelectedIndex();
            }
        });
        this.add((Component)this._tabs, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 18, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)this.lblStatus, new GridBagConstraints(0, 6, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, 5, 0, 0), 0, 0));
        Dimension dimension = Ide.getMainWindow().getSize();
        this.setMinimumSize(new Dimension(400, 600));
    }

    public void initDialog(JEWTDialog jEWTDialog) {
        this._dlg = jEWTDialog;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConnectionDialog.this.processButtons(actionEvent.getActionCommand());
            }
        };
        this._dlg.addActionListener(actionListener);
        this._btnSave.addActionListener(actionListener);
        this._btnTest.addActionListener(actionListener);
        this._btnClear.addActionListener(actionListener);
        this._btnConnect.addActionListener(actionListener);
        this._dlg.addCustomButton((Component)this._btnSave);
        this._dlg.addCustomButton((Component)this._btnClear);
        this._dlg.addCustomButton((Component)this._btnTest);
        this._dlg.addCustomButton((Component)this._btnConnect);
        this.tfdConnName.addKeyListener(this._enterKey);
        this.tfdPassword.addKeyListener(this._enterKey);
        this.tfdUser.addKeyListener(this._enterKey);
        this._dlg.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                ConnectionDialog.this.tfdConnName.requestFocusInWindow();
            }
        });
    }

    public void attachEnterKey(Component component) {
        component.addKeyListener(this._enterKey);
        if (component instanceof Container) {
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.attachEnterKey(((Container)component).getComponent(i));
            }
        }
    }

    public String getUserName() {
        return this.tfdUser.getText();
    }

    public String getPassword() {
        return this.tfdPassword.getText();
    }

    public ConnectionDescriptor getConnectionDescriptor() {
        IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getActivePanel());
        ConnectionDescriptor connectionDescriptor = iConnectionPanel.getConnectionDescriptor();
        return connectionDescriptor;
    }

    private static ArrayList<ConnectionDescriptor> getAllConnections() {
        ConnectionManager connectionManager = ConnectionManager.getInstance();
        ArrayList<ConnectionDescriptor> arrayList = new ArrayList<ConnectionDescriptor>();
        try {
            String[] stringArray = connectionManager.getConnectionNames();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(connectionManager.getConnectionDescriptor(stringArray[i]));
            }
            Collections.sort(arrayList, new CDComparator());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public void setActivePanel(ConnectionDescriptor connectionDescriptor) {
        String string = connectionDescriptor.getJdbcDriver();
        DefaultListModel defaultListModel = this._tabs.getTabModel();
        for (int i = 0; i < defaultListModel.size(); ++i) {
            DefaultCustomTabPage defaultCustomTabPage = (DefaultCustomTabPage)defaultListModel.get(i);
            IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)defaultCustomTabPage.getUserObject());
            if (iConnectionPanel.getDriver().equals(string)) {
                this._tabs.setSelectedIndex(i);
                continue;
            }
            iConnectionPanel.setDefaultPrompts();
        }
    }

    public void tableFocusChanged() {
        if (this._table.getSelectedRow() > -1) {
            IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getActivePanel());
            ConnectionDescriptor connectionDescriptor = ((ConnectionModel)this._table.getModel()).getRowData(this._table.getSelectedRow());
            this.tfdConnName.setText(connectionDescriptor.getConnectionName());
            this.tfdUser.setText(connectionDescriptor.getUsername());
            this.tfdPassword.setText(connectionDescriptor.getPassword());
            this.chkSavePassword.setSelected(Boolean.parseBoolean(connectionDescriptor.getProperty("SavePassword", Boolean.TRUE.toString())));
            this.setActivePanel(connectionDescriptor);
            iConnectionPanel.updatePrompts(connectionDescriptor);
        }
    }

    public boolean validateInput() {
        boolean bl = true;
        if (this.tfdConnName.getText() == null || this.tfdConnName.getText().trim().length() == 0) {
            MessageDialog.error((Component)this._dlg, (Object)"Connection Name invalid.", (String)"Connection Name invalid.", null);
            bl = false;
        }
        return bl;
    }

    public void processButtons(String string) {
        final IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getActivePanel());
        ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
        connectionDescriptor.put((Object)"ConnectionName", (Object)this.tfdConnName.getText());
        connectionDescriptor.put((Object)"user", (Object)this.tfdUser.getText());
        connectionDescriptor.put((Object)"password", (Object)this.tfdPassword.getText());
        connectionDescriptor.put((Object)"DeployPassword", (Object)"false");
        connectionDescriptor.put((Object)"SavePassword", (Object)Boolean.toString(this.chkSavePassword.isSelected()));
        iConnectionPanel.setConnectionDescriptor(connectionDescriptor);
        if (string == CLEAR) {
            iConnectionPanel.clear();
            this.tfdConnName.setText("");
            this.tfdPassword.setText("");
            this.tfdUser.setText("");
        } else if (string == TEST) {
            ConnectRunnable connectRunnable = new ConnectRunnable(){

                protected Object doWork() throws Exception {
                    iConnectionPanel.testConnection(ConnectionDialog.this.getUserName(), ConnectionDialog.this.getPassword());
                    return null;
                }
            };
            try {
                connectRunnable.setTitle("Testing Connection");
                connectRunnable.start(true);
            }
            catch (ProgressException progressException) {}
        } else if (string == SAVE && this.validateInput()) {
            int n = 1;
            if (Connections.getInstance().getConnectionInfo(this.getConnectionName()) != null && !this.equals(this.getConnectionDescriptor(), Connections.getInstance().getConnectionInfo(this.getConnectionName()))) {
                n = MessageDialog.confirmOrCancel((Component)this, (Object)"Connection Name already used. Confirm to overwrite", (String)"Connection Name in use");
            }
            if (n == 1) {
                try {
                    ConnectionDialog.registerConnection(iConnectionPanel.getConnectionDescriptor());
                    ((ConnectionModel)this._table.getModel()).reReadConnections();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (string == CONNECT && this.validateInput()) {
            int n = 1;
            if (Connections.getInstance().getConnectionInfo(this.getConnectionName()) != null && !this.equals(this.getConnectionDescriptor(), Connections.getInstance().getConnectionInfo(this.getConnectionName()))) {
                n = MessageDialog.confirmOrCancel((Component)this, (Object)"Connection Name already used. Confirm to overwrite", (String)"Connection Name in use");
            }
            if (n == 1) {
                ConnectRunnable connectRunnable = new ConnectRunnable(){

                    protected Object doWork() throws Exception {
                        return iConnectionPanel.testConnection(ConnectionDialog.this.getUserName(), ConnectionDialog.this.getPassword());
                    }

                    protected void finish(Object object) {
                        if (!this.isCanceled()) {
                            boolean bl;
                            boolean bl2 = bl = object instanceof Boolean && (Boolean)object != false;
                            if (bl) {
                                try {
                                    ConnectionDialog.registerConnection(ConnectionDialog.this.getConnectionDescriptor());
                                    ((ConnectionModel)ConnectionDialog.this._table.getModel()).reReadConnections();
                                    ConnectionDialog.this._dlg.setVisible(false);
                                    ConnectionDialog.this._dlg.closeDialog(false);
                                }
                                catch (IOException iOException) {}
                            }
                        } else {
                            ConnectionDialog.this.setStatus("Canceled");
                        }
                    }
                };
                try {
                    connectRunnable.setTitle("Testing Connection");
                    connectRunnable.start(true);
                }
                catch (ProgressException progressException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean equals(ConnectionDescriptor connectionDescriptor, ConnectionDescriptor connectionDescriptor2) {
        boolean bl = false;
        if (connectionDescriptor != null && connectionDescriptor2 != null && connectionDescriptor.getURL() != null && connectionDescriptor2.getURL() != null && connectionDescriptor.getUsername() != null && connectionDescriptor2.getUsername() != null) {
            String string = connectionDescriptor.getURL().intern();
            String string2 = connectionDescriptor2.getURL().intern();
            String string3 = connectionDescriptor.getUsername().intern();
            String string4 = connectionDescriptor2.getUsername().intern();
            bl = string == string2 && string3 == string4;
        }
        return bl;
    }

    public boolean useUserName() {
        return this.tfdUser.isEditable();
    }

    public boolean usePassword() {
        return this.tfdPassword.isEditable();
    }

    public void useUserName(boolean bl) {
        this.tfdUser.setEditable(bl);
        this.lblUser.setEnabled(bl);
        if (bl) {
            this.tfdUser.setForeground(Color.BLACK);
        } else {
            this.tfdUser.setText("");
            this.tfdUser.setForeground(Color.LIGHT_GRAY);
        }
    }

    public void usePassword(boolean bl) {
        this.tfdPassword.setEditable(bl);
        this.chkSavePassword.setEnabled(bl);
        this.lblPassword.setEnabled(bl);
        if (bl) {
            this.tfdPassword.setForeground(Color.BLACK);
        } else {
            this.tfdPassword.setText("");
            this.tfdPassword.setForeground(Color.LIGHT_GRAY);
        }
    }

    public void useSavePwd(boolean bl) {
        this.chkSavePassword.setEnabled(bl);
    }

    public void chkSavePwd(boolean bl) {
        this.chkSavePassword.setSelected(bl);
    }

    public static ConnectionDescriptor launch(String string) throws IOException {
        ConnectionDialog connectionDialog = new ConnectionDialog();
        if (string != null) {
            connectionDialog.setConnectionName(string);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)connectionDialog, "f1_idewcxnwelcome_html");
        Dimension dimension = connectionDialog.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)connectionDialog, null, (String)"New / Select Database Connection", (int)6);
        connectionDialog.initDialog(jEWTDialog);
        jEWTDialog.setModal(true);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(dimension);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)"connection.dialog.size");
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
        if (jEWTDialog.isCancelled()) {
            return null;
        }
        return connectionDialog.getConnectionDescriptor();
    }

    public static void main(String[] stringArray) throws IOException {
        ConnectionDialog.launch(null);
    }

    public static void registerConnection(ConnectionDescriptor connectionDescriptor) throws IOException {
        if (connectionDescriptor != null) {
            ConnectionManager.getInstance().removeConnectionDescriptor(connectionDescriptor.getConnectionName());
            ConnectionManager.getInstance().putConnectionDescriptor(connectionDescriptor.getConnectionName(), connectionDescriptor);
        }
    }

    public void setStatus(String string) {
        this.lblStatus.setText(string);
        this.lblStatus.setForeground(Color.BLACK);
        this.lblStatus.getAccessibleContext().setAccessibleName(this.lblStatus.getText());
    }

    public void setErrorStatus(String string) {
        this.lblStatus.setText(string);
        this.lblStatus.setForeground(Color.RED);
        this.lblStatus.getAccessibleContext().setAccessibleName(this.lblStatus.getText());
    }

    public String getConnectionName() {
        return this.tfdConnName.getText();
    }

    public void setConnectionName(String string) {
        IConnectionPanel iConnectionPanel = (IConnectionPanel)((Object)this._tabs.getActivePanel());
        ConnectionDescriptor connectionDescriptor = Connections.getInstance().getConnectionInfo(string);
        if (connectionDescriptor != null) {
            this.tfdConnName.setText(connectionDescriptor.getConnectionName());
            this.tfdUser.setText(connectionDescriptor.getUsername());
            this.tfdPassword.setText(connectionDescriptor.getPassword());
            this.chkSavePassword.setSelected(Boolean.parseBoolean(connectionDescriptor.getProperty("SavePassword", Boolean.TRUE.toString())));
            this.setActivePanel(connectionDescriptor);
            iConnectionPanel.updatePrompts(connectionDescriptor);
            for (int i = 0; i < this._table.getRowCount(); ++i) {
                Object object = this._table.getValueAt(i, 0);
                if (!((String)this._table.getValueAt(i, 0)).equals(string)) continue;
                this._table.setRowSelectionInterval(i, i);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionModel
    extends AbstractTableModel {
        ArrayList<ConnectionDescriptor> data = ConnectionDialog.access$600();

        public void setData(ArrayList<ConnectionDescriptor> arrayList) {
            assert (arrayList != null);
            this.data = arrayList;
        }

        public void reReadConnections() {
            this.data = ConnectionDialog.getAllConnections();
            this.fireTableStructureChanged();
            this.fireTableDataChanged();
        }

        public ArrayList<ConnectionDescriptor> getData() {
            return this.data;
        }

        @Override
        public String getColumnName(int n) {
            String string = null;
            switch (n) {
                case 0: {
                    string = ConnectionDialogArb.getString(4);
                    break;
                }
                case 1: {
                    string = ConnectionDialogArb.getString(5);
                }
            }
            return string;
        }

        @Override
        public int getRowCount() {
            return this.data != null ? this.data.size() : 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ConnectionDescriptor connectionDescriptor = this.getRowData(n);
            String string = null;
            switch (n2) {
                case 0: {
                    string = connectionDescriptor.getConnectionName();
                    break;
                }
                case 1: {
                    String string2;
                    String string3 = connectionDescriptor.getHostname();
                    if (string3 != null) {
                        string2 = connectionDescriptor.getJdbcPort();
                        String string4 = connectionDescriptor.getSid();
                        String string5 = (String)connectionDescriptor.get((Object)"ServiceName");
                        string4 = string4 != null ? string4 : string5;
                        string = "//" + connectionDescriptor.getHostname() + ":" + (string2 != null ? string2 : "1521") + "/" + string4;
                    } else {
                        string2 = connectionDescriptor.getURL();
                        string = string2.substring(string2.lastIndexOf(64) + 1);
                    }
                    string2 = connectionDescriptor.getUsername() != null ? connectionDescriptor.getUsername() : "";
                    string = string2 + "@" + string;
                }
            }
            return string;
        }

        public ConnectionDescriptor getRowData(int n) {
            return this.data.get(n);
        }
    }

    private static class CDComparator
    implements Comparator {
        private CDComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof ConnectionDescriptor && object2 instanceof ConnectionDescriptor) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)object;
                ConnectionDescriptor connectionDescriptor2 = (ConnectionDescriptor)object2;
                return Collator.getInstance().compare(connectionDescriptor.getConnectionName(), connectionDescriptor2.getConnectionName());
            }
            throw new IllegalArgumentException(object + " and " + object2 + " are not comparable.");
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    }

    private static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        private ConnectRunnable() {
        }

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        boolean isCanceled() {
            return this.m_canceled;
        }
    }
}

