/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.config.SQLPlusFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class WorkSheetInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox m_chkAutocommit = new JCheckBox();
    private JCheckBox m_openWorkSheet = new JCheckBox();
    private JTextField m_maxScriptRows = new JTextField();
    private SQLPlusFileChooser m_sqlPlusOptions = new SQLPlusFileChooser();
    private JCheckBox m_saveBinds = new JCheckBox();

    public WorkSheetInfo() {
        this.setHelpID("f1_dbworksheetparams_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        Boolean bl = dBConfig.getBoolean("AUTOCOMMIT");
        this.m_chkAutocommit.setSelected(bl);
        bl = dBConfig.getBoolean("WORKSHEETOPEN");
        this.m_openWorkSheet.setSelected(bl);
        String string = dBConfig.getString("MAXSCRIPTROWS");
        this.m_maxScriptRows.setText(string);
        bl = dBConfig.getBoolean("SAVEBINDS");
        this.m_saveBinds.setSelected(bl);
        this.m_sqlPlusOptions.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        dBConfig.setParameter("AUTOCOMMIT", this.m_chkAutocommit.isSelected());
        dBConfig.setParameter("WORKSHEETOPEN", this.m_openWorkSheet.isSelected());
        dBConfig.setParameter("MAXSCRIPTROWS", this.m_maxScriptRows.getText());
        dBConfig.setParameter("SAVEBINDS", this.m_saveBinds.isSelected());
        this.m_sqlPlusOptions.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkAutocommit, (String)PreferencesArb.getString(2));
        ResourceUtils.resButton((AbstractButton)this.m_openWorkSheet, (String)PreferencesArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.m_saveBinds, (String)PreferencesArb.getString(6));
        this.add(this.m_chkAutocommit, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.m_openWorkSheet, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(1)), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_maxScriptRows, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_sqlPlusOptions), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_saveBinds, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_maxScriptRows.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (c == 'u') {
                    WorkSheetInfo.this.m_maxScriptRows.setText("unlimited");
                    keyEvent.consume();
                } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    WorkSheetInfo.this.getToolkit().beep();
                    keyEvent.consume();
                }
            }
        });
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridx = 2;
        this.add(jLabel, gridBagConstraints);
    }
}

