/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.component.URLPathEditPanel;
import oracle.ide.net.URLPath;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.NodeList;

public class TPPanel
extends DefaultTraversablePanel {
    private URLPathEditPanel m_pnlPath = new URLPathEditPanel();
    private BorderLayout borderLayout1 = new BorderLayout();

    public TPPanel() {
        this.setHelpID("f1_thirdpartydrivers_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String pathToXml(URLPath uRLPath) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<urls>");
        for (URL uRL : uRLPath.getEntries()) {
            stringBuilder.append("<url><![CDATA[" + uRL.toString() + "]]></url>");
        }
        stringBuilder.append("</urls>");
        return stringBuilder.toString();
    }

    public static URLPath xmlToPath(String string) {
        URLPath uRLPath = new URLPath();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (string != null && string.length() > 5) {
            try {
                dOMParser.parse((InputStream)new ByteArrayInputStream(string.getBytes()));
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    URL uRL = new URL(nodeList.item(i).getTextContent());
                    uRLPath.add(uRL);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return uRLPath;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        URLPath uRLPath = TPPanel.xmlToPath(dBConfig.getString("TPDRIVER"));
        if (uRLPath != null) {
            this.m_pnlPath.setPath(uRLPath);
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        String string = TPPanel.pathToXml(this.m_pnlPath.getPath());
        dBConfig.setParameter("TPDRIVER", string);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.m_pnlPath.setPathLabel(PreferencesArb.getString(46));
        this.add((Component)this.m_pnlPath, "Center");
    }
}

