/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;

public final class SQLPlusFileChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblSqlPlusPath = new JLabel();
    private JTextField tfSqlPlusPath = new FileField();
    private JButton btnBrowse = new JButton();
    private MultiLineLabel hintText = new MultiLineLabel();
    private GridBagLayout layMain = new GridBagLayout();

    public SQLPlusFileChooser() {
        try {
            this.jbInit();
            this.setHelpID("f1_defaultsqlplusdir_html");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        String string = dBConfig.getString("DEFAULTPATH");
        this.tfSqlPlusPath.setText(string);
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        dBConfig.setParameter("DEFAULTPATH", this.tfSqlPlusPath.getText());
    }

    public JTextField getPathField() {
        return this.tfSqlPlusPath;
    }

    private void jbInit() throws Exception {
        String string = PreferencesArb.getString(3);
        this.hintText.setTextWrapper(WordWrapper.getTextWrapper());
        this.hintText.setText(string);
        string = PreferencesArb.getString(4);
        ResourceUtils.resLabel((JLabel)this.lblSqlPlusPath, (Component)this.tfSqlPlusPath, (String)string);
        string = PreferencesArb.getString(5);
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)string);
        this.btnBrowse.setMnemonic('w');
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SQLPlusFileChooser.this.btnBrowse_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.layMain);
        this.add((Component)this.hintText, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.tfSqlPlusPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.lblSqlPlusPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void btnBrowse_actionPerformed(ActionEvent actionEvent) {
        File file;
        File file2 = DBConfig.getInstance().getString("DEFAULTPATH") == null ? new File(Ide.getUserHomeDirectory()) : new File(DBConfig.getInstance().getString("DEFAULTPATH"));
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Select Directory");
        this.removeNewFolderButton(jFileChooser);
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.tfSqlPlusPath.setText(file.toString());
        }
    }

    private void removeNewFolderButton(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            JComponent jComponent;
            Component component = container.getComponent(i);
            if (component instanceof JButton) {
                String string;
                jComponent = (JButton)component;
                Action action = ((AbstractButton)jComponent).getAction();
                if (action == null || (string = (String)action.getValue("Name")) == null || !string.equals("New Folder")) continue;
                container.remove(jComponent);
                return;
            }
            if (component instanceof JComboBox) {
                jComponent = (JComboBox)component;
                if (i != 1) continue;
                jComponent.setVisible(false);
                continue;
            }
            if (component instanceof JTextField) {
                jComponent = (JTextField)component;
                ((JTextComponent)jComponent).setEditable(false);
                continue;
            }
            if (component instanceof JLabel) {
                jComponent = (JLabel)component;
                if (((JLabel)jComponent).getText().equals("File Name:")) {
                    ((JLabel)jComponent).setText("Directory Name");
                }
                if (!((JLabel)jComponent).getText().equals("File Type:")) continue;
                jComponent.setVisible(false);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this.removeNewFolderButton((Container)component);
        }
    }
}

