/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ObjectViewerInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoPin = new JCheckBox();
    private JCheckBox ddlSegment = new JCheckBox();
    private JCheckBox ddlTerm = new JCheckBox();
    private JCheckBox ddlPretty = new JCheckBox();
    private JCheckBox ddlByte = new JCheckBox();
    private JCheckBox ddlForce = new JCheckBox();
    private JCheckBox ddlAlter = new JCheckBox();
    private JCheckBox ddlSchema = new JCheckBox();

    public ObjectViewerInfo() {
        this.setHelpID("f1_objectviewerinfo_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        this.autoPin.setSelected(dBConfig.getBoolean("AUTOPIN"));
        this.ddlSegment.setSelected(dBConfig.getBoolean("DDL_SEGMENTS"));
        this.ddlTerm.setSelected(dBConfig.getBoolean("DDL_TERMINATOR"));
        this.ddlPretty.setSelected(dBConfig.getBoolean("DDL_PRETTY"));
        this.ddlByte.setSelected(dBConfig.getBoolean("DDL_BYTE"));
        this.ddlForce.setSelected(dBConfig.getBoolean("DDL_FORCE"));
        this.ddlAlter.setSelected(dBConfig.getBoolean("DDL_ALTER"));
        this.ddlSchema.setSelected(dBConfig.getBoolean("DDL_SCHEMA"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        dBConfig.setParameter("AUTOPIN", this.autoPin.isSelected());
        dBConfig.setParameter("DDL_SEGMENTS", this.ddlSegment.isSelected());
        dBConfig.setParameter("DDL_TERMINATOR", this.ddlTerm.isSelected());
        dBConfig.setParameter("DDL_PRETTY", this.ddlPretty.isSelected());
        dBConfig.setParameter("DDL_BYTE", this.ddlByte.isSelected());
        dBConfig.setParameter("DDL_FORCE", this.ddlForce.isSelected());
        dBConfig.setParameter("DDL_ALTER", this.ddlAlter.isSelected());
        dBConfig.setParameter("DDL_SCHEMA", this.ddlSchema.isSelected());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.autoPin, (String)PreferencesArb.getString(18));
        ResourceUtils.resButton((AbstractButton)this.ddlSegment, (String)PreferencesArb.getString(20));
        ResourceUtils.resButton((AbstractButton)this.ddlTerm, (String)PreferencesArb.getString(21));
        ResourceUtils.resButton((AbstractButton)this.ddlPretty, (String)PreferencesArb.getString(22));
        ResourceUtils.resButton((AbstractButton)this.ddlByte, (String)PreferencesArb.getString(23));
        ResourceUtils.resButton((AbstractButton)this.ddlForce, (String)PreferencesArb.getString(24));
        ResourceUtils.resButton((AbstractButton)this.ddlAlter, (String)PreferencesArb.getString(25));
        ResourceUtils.resButton((AbstractButton)this.ddlSchema, (String)PreferencesArb.getString(26));
        this.add(this.autoPin, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(19)), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.ddlSegment, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlTerm, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlPretty, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlByte, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.ddlForce, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.ddlAlter, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.ddlSchema, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 9, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

