/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.ExtColumn;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.dbtools.raptor.controls.FilePanel;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionPanel
extends DefaultTraversablePanel {
    private JTable _table;
    private DefaultTableModel _model = new DefaultTableModel();
    private Component _comp;

    public ExtensionPanel() {
        this.init();
    }

    public ExtensionPanel(List<ExtColumn> list) {
        this.init();
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    public void setColumns(List<ExtColumn> list) {
        for (ExtColumn extColumn : list) {
            this.addRow(extColumn.getType(), extColumn.getName());
        }
    }

    public String modelToXml(DefaultTableModel defaultTableModel) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        stringBuilder.append("<rows>");
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            stringBuilder.append("<row>");
            stringBuilder.append("<item><![CDATA[" + defaultTableModel.getValueAt(i, 0) + "]]></item>");
            stringBuilder.append("<item><![CDATA[" + defaultTableModel.getValueAt(i, 1) + "]]></item>");
            stringBuilder.append("</row>");
        }
        stringBuilder.append("</rows>");
        return stringBuilder.toString();
    }

    public DefaultTableModel xmlToModel(String string) {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Type");
        defaultTableModel.addColumn("Location");
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (string != null && string.length() > 5) {
            try {
                dOMParser.parse((InputStream)new ByteArrayInputStream(string.getBytes()));
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes();
                NodeList nodeList2 = nodeList.item(0).getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    NodeList nodeList3 = nodeList2.item(i).getChildNodes();
                    String string2 = nodeList3.item(0).getTextContent();
                    String string3 = nodeList3.item(1).getTextContent();
                    defaultTableModel.addRow(new Object[]{string2, string3});
                }
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return defaultTableModel;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        DefaultTableModel defaultTableModel = this.xmlToModel(dBConfig.getString("EXTENSION"));
        if (defaultTableModel.getColumnName(0).equals("Type")) {
            this._model = defaultTableModel;
            this._table.setModel(this._model);
            this._table.updateUI();
            int n = 0;
            TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new TypeCellEditor());
            n = 1;
            tableColumn = this._table.getColumnModel().getColumn(n);
            tableColumn.setCellEditor(new URLCellEditor());
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        int n = this._table.getSelectedRow();
        int n2 = this._table.getSelectedColumn();
        if (n != -1 && n2 != -1 && this._table.getValueAt(n, n2) != null) {
            this._table.getCellEditor(n, n2).stopCellEditing();
        }
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        String string = this.modelToXml(this._model);
        dBConfig.setParameter("EXTENSION", string);
    }

    public void init() {
        this.setHelpID("f1_userdefinedextensions_html");
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(PreferencesArb.getString(48));
        this.add(jLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane jScrollPane = new JScrollPane();
        this.add(jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this._table = new JTable(this._model);
        this._model.addColumn("Type");
        this._model.addColumn("Location");
        jScrollPane.setViewportView(this._table);
        JButton jButton = new JButton();
        jButton.setText("Add Row");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionPanel.this.addRow(null, null);
            }
        });
        this.add(jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        JButton jButton2 = new JButton();
        jButton2.setText("Remove Row");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ExtensionPanel.this._table.getSelectedRow();
                int n2 = ExtensionPanel.this._table.getSelectedColumn();
                while (n > -1) {
                    ExtensionPanel.this._table.getCellEditor(n, n2).stopCellEditing();
                    ExtensionPanel.this._model.removeRow(n);
                    n = ExtensionPanel.this._table.getSelectedRow();
                }
            }
        });
        this.add(jButton2, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        int n = 0;
        TableColumn tableColumn = this._table.getColumnModel().getColumn(n);
        tableColumn.setCellEditor(new TypeCellEditor());
        n = 1;
        tableColumn = this._table.getColumnModel().getColumn(n);
        this._comp = this;
        tableColumn.setCellEditor(new URLCellEditor());
    }

    public void addRow(String string, String string2) {
        this._model.addRow(new Object[]{string2, string});
        this._model.fireTableDataChanged();
    }

    public List<ExtColumn> getColumns() {
        ExtColumn extColumn = null;
        ArrayList<ExtColumn> arrayList = new ArrayList<ExtColumn>();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            extColumn = new ExtColumn((String)this._table.getModel().getValueAt(i, 0), (String)this._table.getModel().getValueAt(i, 1));
            arrayList.add(extColumn);
        }
        return arrayList;
    }

    public class URLCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component;

        public URLCellEditor() {
            this.component = new FilePanel(ExtensionPanel.this._comp);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((FilePanel)this.component).setFileName((String)object);
            return this.component;
        }

        public Object getCellEditorValue() {
            return ((FilePanel)this.component).getFileName();
        }
    }

    public class TypeCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JComboBox<String>(new DefaultComboBoxModel<String>(new String[]{"REPORT", "ACTION", "EDITOR", "NAVIGATOR"}));

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                // empty if block
            }
            ((JComboBox)this.component).getModel().setSelectedItem((String)object);
            return this.component;
        }

        public Object getCellEditorValue() {
            return ((JComboBox)this.component).getModel().getSelectedItem();
        }
    }
}

