/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.config.ExportFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.GlobalSettings;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.jdevimpl.db.sqlplus.SqlPlusOptionsPanel;

public class DatabaseInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox m_chkDateTime = new JCheckBox();
    private SqlPlusOptionsPanel m_sqlPlusOptions = new SqlPlusOptionsPanel();
    private ExportFileChooser m_exportDir = new ExportFileChooser();

    public DatabaseInfo() {
        this.setHelpID("f1_cdbdprefdatabaseconnections_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        ConnectionOptions connectionOptions = (ConnectionOptions)traversableContext.find("ConnectionOptions");
        if (connectionOptions != null) {
            this.m_chkDateTime.setSelected(connectionOptions.isValidateDateTime());
        } else if (GlobalSettings.getInstance() != null) {
            this.m_chkDateTime.setSelected(GlobalSettings.getInstance().isValidateDateTime());
        }
        if (traversableContext.find("SqlPlusOptions") != null) {
            this.m_sqlPlusOptions.onEntry(traversableContext);
        }
        this.m_exportDir.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        ConnectionOptions connectionOptions = (ConnectionOptions)traversableContext.find("ConnectionOptions");
        boolean bl = this.m_chkDateTime.isSelected();
        if (connectionOptions != null) {
            connectionOptions.setValidateDateTime(bl);
        }
        if (GlobalSettings.getInstance() != null) {
            GlobalSettings.getInstance().setValidateDateTime(bl);
        }
        if (traversableContext.find("SqlPlusOptions") != null) {
            this.m_sqlPlusOptions.onExit(traversableContext);
        }
        this.m_exportDir.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkDateTime, (String)ConnectionArb.getString((int)350));
        this.add(this.m_chkDateTime, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_sqlPlusOptions, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_exportDir), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

