/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.LocaleMapper;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.ClientSetting;
import oracle.ide.net.URLPath;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.util.Copyable;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBConfig
extends ChangeEventSource
implements Copyable {
    public static final String KEY = "DBConfig";
    private static DBConfig INSTANCE = null;
    public static final String WORKSHEETOPEN = "WORKSHEETOPEN";
    public static final String MAXSCRIPTROWS = "MAXSCRIPTROWS";
    public static final String AUTOCOMMIT = "AUTOCOMMIT";
    public static final String DEFAULTPATH = "DEFAULTPATH";
    public static final String SAVEBINDS = "SAVEBINDS";
    public static final String OBJECT_NAME = "OBJECT_NAME";
    public static final String OPTIONS = "OPTIONS";
    public static final String COST = "COST";
    public static final String CARDINALITY = "CARDINALITY";
    public static final String LAST_OUTPUT_ROWS = "LAST_OUTPUT_ROWS";
    public static final String LAST_CR_BUFFER_GETS = "LAST_CR_BUFFER_GETS";
    public static final String LAST_ELAPSED_TIME = "LAST_ELAPSED_TIME";
    public static final String PREDICATES = "PREDICATES";
    public static final String PROJECTION = "PROJECTION";
    public static final String OTHER_XML = "OTHER_XML";
    public static final String MYSTAT = "V$MYSTAT";
    public static final String AUTOPIN = "AUTOPIN";
    public static final String DDL_SEGMENTS = "DDL_SEGMENTS";
    public static final String DDL_TERMINATOR = "DDL_TERMINATOR";
    public static final String DDL_PRETTY = "DDL_PRETTY";
    public static final String DDL_BYTE = "DDL_BYTE";
    public static final String DDL_FORCE = "DDL_FORCE";
    public static final String DDL_ALTER = "DDL_ALTER";
    public static final String DDL_SCHEMA = "DDL_SCHEMA";
    public static final String NLS_LANG = "NLS_LANG";
    public static final String NLS_TERR = "NLS_TERR";
    public static final String NLS_SORT = "NLS_SORT";
    public static final String NLS_COMP = "NLS_COMP";
    public static final String NLS_DATE_LANG = "NLS_DATE_LANG";
    public static final String NLS_DATE_FORM = "NLS_DATE_FORM";
    public static final String NLS_TS_FORM = "NLS_TS_FORM";
    public static final String NLS_TS_TZ_FORM = "NLS_TS_TZ_FORM";
    public static final String NLS_DEC_SEP = "NLS_DEC_SEP";
    public static final String NLS_GRP_SEP = "NLS_GRP_SEP";
    public static final String NLS_CURR = "NLS_CURR";
    public static final String NLS_ISO_CURR = "NLS_ISO_CURR";
    public static final String NLS_LENGTH = "NLS_LENGTH";
    public static final String ARRAYFETCHSIZE = "ARRAYFETCHSIZE";
    public static final String NULLDISPLAY = "NULLDISPLAY";
    public static final String NULLCOLOR = "NULLCOLOR";
    public static final String EXPORTDIR = "EXPORTDIR";
    public static final String EXTENSION = "EXTENSION";
    public static final String TPDRIVER = "TPDRIVER";
    public static final String PLSQLPROFILERDIR = "PLSQLPROFILERDIR";
    public static final String PLSQLOPTIMLEVEL = "PLSQLOPTIMLEVEL";
    public static final String SINGLE_CLICK_TREE = "OPEN_ON_SINGLE_CLICK";
    public static final String SEARCH_AUTO_WILDCARD = "SEARCH_AUTO_WILDCARD";
    public static final String EXPORT_DELIMITER = "EXPORT_DELIMITER";
    private PropertyChangeSupport _change = new PropertyChangeSupport((Object)this);
    private HashMap<String, Object> _parameters = new HashMap();

    public DBConfig() {
        this.setParameter(WORKSHEETOPEN, true);
        this.setParameter(MAXSCRIPTROWS, "5000");
        this.setParameter(AUTOCOMMIT, false);
        this.setParameter(DEFAULTPATH, null);
        this.setParameter(SAVEBINDS, false);
        this.setParameter(OBJECT_NAME, true);
        this.setParameter(OPTIONS, false);
        this.setParameter(COST, true);
        this.setParameter(CARDINALITY, false);
        this.setParameter(LAST_OUTPUT_ROWS, false);
        this.setParameter(LAST_CR_BUFFER_GETS, true);
        this.setParameter(LAST_ELAPSED_TIME, false);
        this.setParameter(PREDICATES, true);
        this.setParameter(PROJECTION, false);
        this.setParameter(OTHER_XML, false);
        this.setParameter(MYSTAT, true);
        this.setParameter(AUTOPIN, false);
        this.setParameter(DDL_SEGMENTS, true);
        this.setParameter(DDL_TERMINATOR, true);
        this.setParameter(DDL_PRETTY, true);
        this.setParameter(DDL_BYTE, true);
        this.setParameter(DDL_FORCE, true);
        this.setParameter(DDL_ALTER, false);
        this.setParameter(DDL_SCHEMA, true);
        this.setParameter(NLS_LANG, LocaleMapper.getOraLanguage((Locale)Locale.getDefault()));
        this.setParameter(NLS_TERR, LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)LocaleMapper.getOraLanguage((Locale)Locale.getDefault()), (String)LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        OraTerritory oraTerritory = OraTerritory.getInstance((String)LocaleMapper.getOraLanguage((Locale)Locale.getDefault()), (String)LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        if (oraLocaleInfo.getLinguisticSort().indexOf("BINARY") > -1) {
            this.setParameter(NLS_SORT, "BINARY");
        } else {
            this.setParameter(NLS_SORT, oraLocaleInfo.getLinguisticSort());
        }
        this.setParameter(NLS_COMP, "BINARY");
        this.setParameter(NLS_DATE_LANG, LocaleMapper.getOraLanguage((Locale)Locale.getDefault()));
        this.setParameter(NLS_DATE_FORM, oraTerritory.getOracleDateFormatString());
        this.setParameter(NLS_TS_FORM, oraTerritory.getNLSTimestampFormatString());
        this.setParameter(NLS_TS_TZ_FORM, oraTerritory.getNLSTimestampAndTimezoneFormatString());
        this.setParameter(NLS_DEC_SEP, oraTerritory.getDecimalCharacter());
        this.setParameter(NLS_GRP_SEP, oraTerritory.getGroupSeparator());
        this.setParameter(NLS_CURR, oraTerritory.getLocalCurrencySymbol());
        this.setParameter(NLS_ISO_CURR, LocaleMapper.getOraTerritory((Locale)Locale.getDefault()));
        this.setParameter(NLS_LENGTH, "BYTE");
        this.setParameter(ARRAYFETCHSIZE, "50");
        this.setParameter(NULLCOLOR, "NONE");
        this.setParameter(NULLDISPLAY, "(null)");
        if (RaptorExtensionConstants.isStandAlone()) {
            this.setParameter(SINGLE_CLICK_TREE, true);
        } else {
            this.setParameter(SINGLE_CLICK_TREE, false);
        }
        this.setParameter(SEARCH_AUTO_WILDCARD, false);
        this.setParameter(EXPORTDIR, null);
        this.setParameter(EXTENSION, null);
        this.setParameter(TPDRIVER, null);
        this.setParameter(EXPORT_DELIMITER, ",");
    }

    public static DBConfig getInstance() {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.sqldeveloper");
        if (INSTANCE == null) {
            INSTANCE = (DBConfig)clientSetting.getData(KEY);
        }
        return INSTANCE;
    }

    public Object copyTo(Object object) {
        DBConfig dBConfig = object instanceof DBConfig ? (DBConfig)((Object)object) : new DBConfig();
        this.copyToImpl(dBConfig);
        return dBConfig;
    }

    protected final void copyToImpl(DBConfig dBConfig) {
        dBConfig.setAllParameters(this._parameters);
        dBConfig.fireChangeEvent();
        for (String string : Connections.getInstance().getConnNames()) {
            Connections connections = Connections.getInstance();
            try {
                if (!connections.isConnectionOpen(string)) continue;
                DefaultNLSProvider defaultNLSProvider = NLSProvider.getProvider(string);
                if (defaultNLSProvider != null) {
                    defaultNLSProvider.initConnection(string);
                } else if (connections.isOracle(string)) {
                    NLSUtils.setNlsFromPrefs(string);
                    NLSUtils.populateNLS((OracleDatabase)connections.getDatabase(string));
                }
                Connection connection = connections.getConnection(string);
                ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection);
                if (connectionTypeDetails == null || !connectionTypeDetails.isSupportsAutocommit()) continue;
                connection.setAutoCommit(DBConfig.getInstance().getBoolean(AUTOCOMMIT));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._change.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._change.removePropertyChangeListener(propertyChangeListener);
    }

    public HashMap<String, Object> getAllParameters() {
        return this._parameters;
    }

    public void setAllParameters(HashMap<String, Object> hashMap) {
        this._parameters.putAll(hashMap);
    }

    public Object getParameter(String string) {
        return this._parameters.get(string);
    }

    public String getString(String string) {
        return (String)this._parameters.get(string);
    }

    public int getInt(String string) {
        if (this._parameters.get(string) instanceof String) {
            return Integer.parseInt((String)this._parameters.get(string));
        }
        return (Integer)this._parameters.get(string);
    }

    public Boolean getBoolean(String string) {
        if (this._parameters.get(string) != null) {
            return (boolean)((Boolean)this._parameters.get(string));
        }
        return false;
    }

    public void setParameter(String string, Object object) {
        Object object2 = this._parameters.get(string);
        this._parameters.put(string, object);
        this._change.firePropertyChange(string, object2, object);
    }

    public ArrayList<String> getExtensions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.getString(EXTENSION);
        if (string2 != null && string2.length() > 5) {
            try {
                DOMParser dOMParser = new DOMParser();
                dOMParser.setPreserveWhitespace(false);
                dOMParser.parse((InputStream)new ByteArrayInputStream(string2.getBytes()));
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes();
                NodeList nodeList2 = nodeList.item(0).getChildNodes();
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    NodeList nodeList3 = nodeList2.item(i).getChildNodes();
                    String string3 = nodeList3.item(0).getTextContent();
                    String string4 = nodeList3.item(1).getTextContent();
                    if (!string.equals(string3)) continue;
                    arrayList.add(string4);
                }
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return arrayList;
    }

    public URLPath getThirdPartyPath() {
        URLPath uRLPath = new URLPath();
        String string = null;
        try {
            string = this.getString(TPDRIVER);
        }
        catch (Exception exception) {
            return uRLPath;
        }
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(false);
        if (string != null && string.length() > 5) {
            try {
                dOMParser.parse((InputStream)new ByteArrayInputStream(string.getBytes()));
                XMLDocument xMLDocument = dOMParser.getDocument();
                NodeList nodeList = xMLDocument.getChildNodes().item(0).getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string2 = nodeList.item(i).getTextContent();
                    URL uRL = new URL(string2);
                    uRLPath.add(uRL);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return uRLPath;
    }
}

