/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.ide.util.Version;
import javax.swing.Timer;
import oracle.dbtools.raptor.dialogs.conn.RaptorConnectionStore;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ProductInformation;
import oracle.ide.config.ClientSetting;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.webupdate.PostStartupHook;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.ConnectionStore;
import oracle.jdeveloper.cm.DefaultConnectionStore;
import oracle.jdeveloper.cm.WritableConnectionStore;

public class ConnectionMigrator
implements PostStartupHook {
    public void install() {
        URL uRL = null;
        uRL = this.findPrevious("oracle.onlinedb");
        if (uRL != null) {
            this.migrateConnections(uRL);
            this.migrateSettings(uRL, "oracle.onlinedb");
        }
        if ((uRL = this.findPrevious("oracle.sqldeveloper")) != null) {
            this.migrateSettings(uRL, "oracle.sqldeveloper");
        }
        if (Ide.isRunning() && !Ide.isStarting()) {
            if (Ide.canRestart()) {
                int n = 3000;
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ProductInformation.getProductInformation().getShortName();
                        MessageDialog.information(null, (Object)(string + " must restart in order to complete the upgrade."), (String)(string + " must restart."), null);
                        Ide.restart();
                    }
                };
                Timer timer = new Timer(n, actionListener);
                timer.start();
            } else {
                int n = 3000;
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = ProductInformation.getProductInformation().getShortName();
                        MessageDialog.information(null, (Object)(string + " must restart in order to complete the upgrade."), (String)(string + " must restart."), null);
                        Ide.quit();
                    }
                };
                Timer timer = new Timer(n, actionListener);
                timer.start();
            }
        } else {
            Ide.addIdeListener((IdeListener)new IdeListener(){

                public void addinsLoaded(IdeEvent ideEvent) {
                    String string = ProductInformation.getProductInformation().getShortName();
                    MessageDialog.information(null, (Object)(string + " must restart in order to complete the upgrade."), (String)(string + " must restart."), null);
                    if (Ide.canRestart()) {
                        Ide.restart();
                    } else {
                        Ide.quit();
                    }
                }

                public void mainWindowOpened(IdeEvent ideEvent) {
                    String string = ProductInformation.getProductInformation().getShortName();
                    MessageDialog.information(null, (Object)(string + " must restart in order to complete the upgrade."), (String)(string + " must restart."), null);
                    if (Ide.canRestart()) {
                        Ide.restart();
                    } else {
                        Ide.quit();
                    }
                }

                public void mainWindowClosing(IdeEvent ideEvent) {
                }
            });
        }
    }

    private URL findPrevious(String string) {
        URL uRL = null;
        URL uRL2 = ExtensionRegistry.getOracleRegistry().getSystemDirectory(string);
        URL uRL3 = URLFileSystem.getParent((URL)uRL2);
        URL[] uRLArray = URLFileSystem.list((URL)uRL3, (URLFilter)new ExtFilter(string));
        if (uRLArray != null) {
            Version version = ConnectionMigrator.getVersion(uRL2, string);
            for (URL uRL4 : uRLArray) {
                Version version2 = ConnectionMigrator.getVersion(uRL4, string);
                if (version2 == null || version2.compareTo((Object)version) >= 0 || uRL != null && version2.compareTo((Object)ConnectionMigrator.getVersion(uRL, string)) <= 0) continue;
                uRL = uRL4;
            }
        }
        return uRL;
    }

    private void migrateConnections(URL uRL) {
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)"IDEConnections.xml");
        ConnectionManager connectionManager = ConnectionManager.getPrivateInstance();
        connectionManager.setConnectionStore((ConnectionStore)new RaptorConnectionStore((WritableConnectionStore)new DefaultConnectionStore(URLFileSystem.getPlatformPathName((URL)uRL2), true)));
        ConnectionManager connectionManager2 = ConnectionManager.getInstance();
        try {
            String[] stringArray = connectionManager.getConnectionNamesForClass("CLASS_DATABASE");
            for (int i = 0; i < stringArray.length; ++i) {
                ConnectionDescriptor connectionDescriptor = connectionManager.getConnectionDescriptor(stringArray[i]);
                connectionManager2.putConnectionDescriptor(connectionDescriptor.getConnectionName(), connectionDescriptor);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void migrateSettings(URL uRL, String string) {
        URL uRL2 = URLFactory.newURL((URL)uRL, (String)"preferences.xml");
        try {
            Class<ClientSetting> clazz = ClientSetting.class;
            Constructor constructor = clazz.getDeclaredConstructor(URL.class);
            constructor.setAccessible(true);
            ClientSetting clientSetting = (ClientSetting)constructor.newInstance(uRL2);
            ClientSetting clientSetting2 = ClientSetting.findOrCreate((String)string);
            clientSetting.copyTo((Object)clientSetting2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static Version getVersion(URL uRL, String string) {
        String string2;
        Version version = null;
        String string3 = URLFileSystem.getFileName((URL)uRL);
        if (string3 != null && string3.startsWith(string) && (string2 = string3.substring(string.length() + 1)).length() > 0 && Character.isDigit(string2.charAt(0))) {
            version = new Version(string2);
        }
        return version;
    }

    private static class ExtFilter
    implements URLFilter {
        String _extID;

        private ExtFilter(String string) {
            this._extID = string;
        }

        public boolean accept(URL uRL) {
            String string = URLFileSystem.getFileName((URL)uRL);
            if (string != null) {
                String string2 = string.startsWith(this._extID) ? string.substring(this._extID.length() + 1) : "";
                return string2.length() > 0 && Character.isDigit(string2.charAt(0));
            }
            return false;
        }

        public boolean equals(Object object) {
            return object instanceof ExtFilter;
        }
    }
}

