/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class AdvancedInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JTextField m_arraySize = new JTextField();
    private JTextField m_nullDisplay = new JTextField();
    private JComboBox m_nullColor = new JComboBox();
    private JCheckBox m_singleClick = new JCheckBox();
    private JCheckBox m_autoSearchWild = new JCheckBox();
    private static String[] _colors = new String[]{"NONE", "BLUE", "GRAY", "LIGHT_GRAY", "BLACK", "RED", "PINK", "ORANGE", "YELLOW", "GREEN"};

    public AdvancedInfo() {
        this.setHelpID("f1_cdbdprefdatabaseconnections_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        this.m_arraySize.setText(dBConfig.getString("ARRAYFETCHSIZE"));
        this.m_nullDisplay.setText(dBConfig.getString("NULLDISPLAY"));
        this.m_nullColor.setModel(new DefaultComboBoxModel<String>(_colors));
        this.m_nullColor.setSelectedItem(dBConfig.getParameter("NULLCOLOR"));
        this.m_singleClick.setSelected(dBConfig.getBoolean("OPEN_ON_SINGLE_CLICK"));
        this.m_autoSearchWild.setSelected(dBConfig.getBoolean("SEARCH_AUTO_WILDCARD"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = (DBConfig)((Object)traversableContext.find("DBConfig"));
        dBConfig.setParameter("ARRAYFETCHSIZE", this.m_arraySize.getText());
        dBConfig.setParameter("NULLDISPLAY", this.m_nullDisplay.getText());
        dBConfig.setParameter("NULLCOLOR", this.m_nullColor.getSelectedItem());
        dBConfig.setParameter("OPEN_ON_SINGLE_CLICK", this.m_singleClick.isSelected());
        dBConfig.setParameter("SEARCH_AUTO_WILDCARD", this.m_autoSearchWild.isSelected());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(new JLabel(PreferencesArb.getString(34)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_arraySize, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(35)), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_nullDisplay, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(36)), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_nullColor, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(37)), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_singleClick, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(38)), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_autoSearchWild, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridx = 2;
        this.add(jLabel, gridBagConstraints);
    }
}

