/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.compiler;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.compiler.OraPls;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.config.ClientSetting;
import oracle.ide.model.Project;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SpecPlSql;
import oracle.jdeveloper.compiler.IdeStorage;
import oracle.jdeveloper.compiler.JCompiler;
import oracle.jdeveloper.compiler.Translator;
import oracle.jdevimpl.cm.dt.config.ConnectionOptions;
import oracle.ojc.interfaces.Storage;

public final class PlSqlTranslator
implements Translator,
Addin {
    private static final String NAME = "PlSql";
    private Translator.Log _log = null;
    private static final PlSqlNodeComparator COMPARATOR = new PlSqlNodeComparator();

    public String getName() {
        return NAME;
    }

    public ArrayList getInputTypes() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(".plsql");
        return arrayList;
    }

    public boolean needToBuild(Storage storage) {
        return false;
    }

    public ArrayList getOutputTypes() {
        ArrayList arrayList = new ArrayList(0);
        return arrayList;
    }

    public boolean canBuild(Storage storage) {
        return storage instanceof IdeStorage && ((IdeStorage)storage).node instanceof PlSqlNode;
    }

    public void setProject(Project project) {
    }

    public void updateProject(Project project) {
    }

    public void setParameter(String string, String string2) {
    }

    public void setLog(Translator.Log log) {
        this._log = log;
    }

    public int translate(Project project, boolean bl, ArrayList arrayList, ArrayList arrayList2) {
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)"oracle.onlinedb");
        String string = null;
        if (project != null) {
            Map map = project.getTransientProperties();
            string = (String)map.get("PLSQL_DEBUG");
        }
        boolean bl2 = string != null ? Boolean.parseBoolean(string) : (clientSetting != null && clientSetting.getData("ConnectionOptions") != null ? ((ConnectionOptions)clientSetting.getData("ConnectionOptions")).isGeneratePlSqlDebugInfo() : true);
        int n = 0;
        int n2 = arrayList.size();
        try {
            Collections.sort(arrayList, COMPARATOR);
            for (int i = 0; i < n2 && !Thread.currentThread().isInterrupted(); ++i) {
                IdeStorage ideStorage = (IdeStorage)arrayList.get(i);
                PlSqlNode plSqlNode = (PlSqlNode)ideStorage.node;
                Database database = PlSqlTranslator.getDatabase(plSqlNode);
                String string2 = (String)plSqlNode.getProperty("SCHEMA");
                String string3 = (String)plSqlNode.getProperty("TYPE");
                PlSql plSql = (PlSql)database.getObject(string3, database.getSchema(string2), (String)plSqlNode.getProperty("NAME"));
                if (plSql != null) {
                    if (plSqlNode.isBody()) {
                        ((SpecPlSql)plSql).setBodySource(plSqlNode.getSource());
                    } else {
                        plSql.setSource(plSqlNode.getSource());
                    }
                } else if ("TRIGGER".equals(string3)) {
                    // empty if block
                }
                OraPls oraPls = new OraPls(database);
                oraPls.setGenerateDebug(bl2);
                OraSubmitResults oraSubmitResults = oraPls.PlsSubmit(string2, plSqlNode.getSource());
                n = oraSubmitResults.getErrorCount();
                List<PlSqlErrorInfo> list = oraSubmitResults.getErrorList();
                arrayList2.addAll(list);
                if (null != list) {
                    for (PlSqlErrorInfo plSqlErrorInfo : list) {
                        if (plSqlErrorInfo.isWarning()) {
                            this._log.warning((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                            continue;
                        }
                        this._log.error((Storage)ideStorage, plSqlErrorInfo.getLineNumber(), plSqlErrorInfo.getColumn(), 0, plSqlErrorInfo.getErrorMessage());
                    }
                    if (list.size() == 20) {
                        this._log.warning((Storage)ideStorage, 1, 1, 0, "Only first 20 issues are reported");
                    }
                }
                if (oraSubmitResults.isSubmitFailed()) continue;
                plSqlNode.markDirty(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = 1;
        }
        return n;
    }

    public void initialize() {
        JCompiler.getInstance().registerTranslator((Translator)this);
    }

    public void shutdown() {
        JCompiler.getInstance().unregisterTranslator((Translator)this);
    }

    static Database getDatabase(PlSqlNode plSqlNode) {
        Database database = null;
        URL uRL = plSqlNode.getURL();
        try {
            database = Connections.getInstance().getDatabase(DBURLFormatHelper.getConnectionName(uRL), false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    private static final class PlSqlNodeComparator
    implements Comparator {
        private PlSqlNodeComparator() {
        }

        public int compare(Object object, Object object2) {
            IdeStorage ideStorage = (IdeStorage)object;
            IdeStorage ideStorage2 = (IdeStorage)object2;
            int n = ideStorage.getName().compareTo(ideStorage2.getName());
            if (n == 0) {
                PlSqlNode plSqlNode = (PlSqlNode)ideStorage.node;
                String string = (String)plSqlNode.getProperty("TYPE");
                n = "PACKAGE".equals(string) || "TYPE".equals(string) ? -1 : 1;
            }
            return n;
        }
    }
}

