/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.compiler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.compiler.OraSubmitResults;
import oracle.dbtools.raptor.compiler.PlSqlErrorInfo;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.ide.config.Preferences;
import oracle.ide.runner.Debugger;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.jdeveloper.cm.dt.ConnectionArb;

final class OraPls {
    private Database _db;
    private String _schema;
    private Logger logger = Logger.getLogger(OraPls.class.getName());
    private boolean _generateDebug = false;
    private static final String ERRORS_QUERY = "SELECT LINE, POSITION, REPLACE(TEXT, CHR(10), ' '), 'ERROR' FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ORDER BY LINE, POSITION";
    private static final String ERRORS_QUERY_10G = "SELECT LINE, POSITION, REPLACE(TEXT, CHR(10), ' '), ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ORDER BY LINE, POSITION";
    private static final String SET_WARNINGS_FLAG = "BEGIN DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;";
    private static final String ENABLE_DEBUG = "ALTER SESSION SET PLSQL_DEBUG = TRUE";
    private static final String DISABLE_DEBUG = "ALTER SESSION SET PLSQL_DEBUG = FALSE";

    public OraPls(Database database) {
        this.setDatabase(database);
    }

    private void setDatabase(Database database) {
        assert (database != null);
        this._db = database;
        try {
            this._schema = this._db.getUserName();
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public Database getDatabase() {
        return this._db;
    }

    public void setGenerateDebug(boolean bl) {
        this._generateDebug = bl;
    }

    public boolean isGenerateDebug() {
        return this._generateDebug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OraSubmitResults PlsSubmit(String string, String string2) {
        Connection connection;
        Object object;
        OraSubmitResults oraSubmitResults = new OraSubmitResults();
        Debugger debugger = Debugger.getDebugger();
        if (debugger.isDebugging()) {
            oraSubmitResults.setSubmitFailed(true);
            oraSubmitResults.addError(new PlSqlErrorInfo(0, 0, ConnectionArb.getString((int)637)));
            return oraSubmitResults;
        }
        Lexer lexer = PlsqlParser.createSqlLexer();
        lexer.setTextBuffer(TextBufferFactory.createReadTextBuffer((String)string2));
        LexerToken lexerToken = lexer.createLexerToken();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        block49: while (true) {
            int n2 = lexer.lex(lexerToken);
            int n3 = lexerToken.getStartOffset();
            int n4 = lexerToken.getEndOffset();
            object = lexer.getTextBuffer().getString(n3, n4 - n3);
            switch (n2) {
                case 392: {
                    string5 = "FUNCTION";
                    continue block49;
                }
                case 752: {
                    string5 = "PROCEDURE";
                    continue block49;
                }
                case 702: {
                    string5 = "PACKAGE";
                    continue block49;
                }
                case 975: {
                    string5 = "TYPE";
                    continue block49;
                }
                case 188: {
                    if ("PACKAGE".equals(string5)) {
                        string5 = "PACKAGE BODY";
                        continue block49;
                    }
                    if (!"TYPE".equals(string5)) continue block49;
                    string5 = "TYPE BODY";
                    continue block49;
                }
                case 1112: {
                    string5 = "TRIGGER";
                    continue block49;
                }
                case 0: 
                case 80: 
                case 160: 
                case 815: 
                case 1050: 
                case 1080: {
                    break block49;
                }
                case 48: 
                case 49: {
                    continue block49;
                }
                case 1058: {
                    bl = true;
                    continue block49;
                }
                case 801: 
                case 1094: {
                    continue block49;
                }
                default: {
                    if (string4 != null) {
                        if (!bl2) break block49;
                        string3 = string4;
                    } else {
                        n = n3;
                    }
                    string4 = this._db.getInternalName((String)object);
                    bl2 = false;
                    continue block49;
                }
                case 72: {
                    bl2 = true;
                    if (string4 != null) continue block49;
                    this.logger.info("Oops! Dot found before name");
                    continue block49;
                }
            }
            break;
        }
        if (string3 == null && ModelUtil.areDifferent((Object)this._schema, (Object)(string3 = string)) && n != -1) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(string2.length() + 40);
            fastStringBuffer.append(string2.substring(0, n));
            fastStringBuffer.append(this._db.getExternalName(string));
            fastStringBuffer.append('.');
            fastStringBuffer.append(string2.substring(n));
            string2 = fastStringBuffer.toString();
        }
        if (!bl) {
            string2 = "CREATE OR REPLACE " + string2;
        }
        if (this.isGenerateDebug()) {
            this._generateDebugInfo();
        }
        this._setWarningFlags();
        Connection connection2 = connection = this._db.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            object = null;
            ResultSet resultSet = null;
            try {
                try {
                    statement = connection.createStatement();
                    statement.setEscapeProcessing(false);
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {
                    oraSubmitResults.setSubmitFailed(true);
                    throw sQLException;
                }
                object = connection.prepareStatement(this.getErrorQuery());
                object.setString(1, string4);
                object.setString(2, string5);
                object.setString(3, string3);
                resultSet = object.executeQuery();
                while (resultSet.next()) {
                    int n5 = resultSet.getInt(1);
                    int n6 = resultSet.getInt(2);
                    String string6 = resultSet.getString(3);
                    String string7 = resultSet.getString(4);
                    boolean bl3 = "ERROR".equals(string7);
                    oraSubmitResults.addError(new PlSqlErrorInfo(n5 + PlSqlNode.offset(string2, string5), n6, string6, !bl3));
                }
            }
            catch (SQLException sQLException) {
                SQLException sQLException2;
                while (sQLException2 != null) {
                    oraSubmitResults.addError(new PlSqlErrorInfo(0, 0, sQLException2.getMessage()));
                    sQLException2 = sQLException2.getNextException();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return oraSubmitResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _generateDebugInfo() {
        Connection connection;
        Connection connection2 = connection = this._db.getConnection();
        synchronized (connection2) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                statement.executeUpdate(this._generateDebug ? ENABLE_DEBUG : DISABLE_DEBUG);
            }
            catch (SQLException sQLException) {
                SQLException sQLException2;
                while (sQLException2 != null) {
                    this.logger.log(Level.SEVERE, "", sQLException2);
                    sQLException2 = sQLException2.getNextException();
                }
            }
            catch (Exception exception) {
                this.logger.log(Level.SEVERE, "", exception);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setWarningFlags() {
        Preferences preferences;
        GlobalSettings globalSettings;
        PlSqlCompilerOptions plSqlCompilerOptions;
        if (this._db instanceof OracleDatabase && ((OracleDatabase)this._db).getOracleDatabaseType() >= 5 && (plSqlCompilerOptions = (globalSettings = GlobalSettings.createGlobalSettings((PropertyStorage)(preferences = Preferences.getPreferences()))).getPlSqlCompilerOptions()) != null) {
            Connection connection;
            Connection connection2 = connection = this._db.getConnection();
            synchronized (connection2) {
                CallableStatement callableStatement = null;
                try {
                    callableStatement = connection.prepareCall(SET_WARNINGS_FLAG);
                    for (PlSqlCompilerOptions.WarningCategory warningCategory : PlSqlCompilerOptions.WarningCategory.values()) {
                        PlSqlCompilerOptions.WarningValue warningValue = plSqlCompilerOptions.getWarningValue(warningCategory);
                        if (warningValue == null) continue;
                        callableStatement.setString(1, warningCategory.name());
                        callableStatement.setString(2, warningValue.name());
                        callableStatement.setString(3, "SESSION");
                        callableStatement.execute();
                    }
                }
                catch (SQLException sQLException) {
                    SQLException sQLException2;
                    while (sQLException2 != null) {
                        this.logger.log(Level.SEVERE, "", sQLException2);
                        sQLException2 = sQLException2.getNextException();
                    }
                }
                finally {
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    private String getErrorQuery() {
        return this._db instanceof OracleDatabase && ((OracleDatabase)this._db).getOracleDatabaseType() >= 5 ? ERRORS_QUERY_10G : ERRORS_QUERY;
    }
}

