/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ceditor;

import java.awt.Point;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.AbstractBrowseClickPlugin;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.NumberRange;

public class DBSourceClickPlugin
extends AbstractBrowseClickPlugin {
    private static Logger logger = Logger.getLogger(DBSourceClickPlugin.class.getName());
    private Map<String, String> _resolved;
    private String _connName;

    public DBSourceClickPlugin(String string) {
        this._connName = string;
    }

    protected NumberRange getIdentifierAtOffset(int n) {
        int n2;
        char c;
        int n3;
        TextBuffer textBuffer = this.getTextBuffer();
        for (n3 = n + 1; n3 < textBuffer.getLength() && (c = textBuffer.getChar(n3)) != '(' && c != ';' && !Character.isWhitespace(c); ++n3) {
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            c = textBuffer.getChar(n2);
            if (c != '(' && c != ' ') continue;
            ++n2;
            break;
        }
        if (n3 < textBuffer.getLength()) {
            String string = textBuffer.getString(n2, n3 - n2);
            this._resolved = DBUtil.getInstance().resolveName(this._connName, string.trim());
        }
        if (this._resolved != null) {
            return new NumberRange(n2, n3);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performDeclarationClick(Point point) {
        if (this._resolved != null) {
            URL uRL = DBURLFormatHelper.getURL(DBURLFormatHelper.getURL("sqldev.nav", this._connName, null, this._resolved.get("OWNER"), this._resolved.get("OBJECT_TYPE")), this._resolved.get("OBJECT_NAME"));
            DatabaseNode databaseNode = DatabaseNavigatorElementFactory.getObjectNode(uRL);
            Context context = Context.newIdeContext((Element)databaseNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            context.setProject(Ide.getDefaultProject());
            try {
                waitCursor.show(0L);
                EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
            finally {
                waitCursor.hide();
            }
        }
    }
}

