/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.models.SQLComboxModel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.cm.CMException;

public class ApexImportIDPanel
extends DefaultTraversablePanel {
    private JComboBox _workspaces;
    private JComboBox _run;
    private JComboBox _id;
    private Map<String, String> _info;
    private Context _ctx;
    private DBObject _dbo;
    private String _filename;
    private GridBagConstraints _gbc;
    private JTextField _newId;
    private JTextField _newName;
    private JTextField _newAlias;
    private int _availId;
    private JCheckBox _overwrite;
    private String _sgid;
    private JLabel _appName;
    private Connection _fromConn;
    private Connection _toConn;
    private String _username;
    private ApexImporter.ScriptStatus _scriptStatus;
    private JCheckBox _runScript;

    public ApexImportIDPanel() {
        this.setDefaultTitle(ApexImportArb.getString(2));
        this.setLayout(new GridBagLayout());
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this._ctx = (Context)traversableContext.get("CONTEXT");
        this._sgid = (String)traversableContext.get("sgid");
        this._dbo = (DBObject)this._ctx.getProperty("DB_OBJECT");
        this._fromConn = this._dbo.getConnection();
        if (traversableContext.get("connection") == null) {
            this._toConn = this._fromConn;
        } else {
            try {
                this._toConn = Connections.getInstance().getConnection((String)traversableContext.get("connection"));
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        if (this._sgid == null) {
            this._sgid = DBUtil.getInstance().executeReturnOneCol(this._toConn, "select workspace_id from APEX_WORKSPACE_SCHEMAS ", new ArrayList());
        }
        if (this._filename != null) {
            this._scriptStatus = ApexImporter.getScriptStatus(this._filename);
        }
        traversableContext.put("SCRIPT.STATUS", (Object)this._scriptStatus);
        if (this._filename == null || !this._filename.equals((String)traversableContext.get("FILENAME"))) {
            this._filename = (String)traversableContext.get("FILENAME");
            this._info = ApexImporter.getInfo(this._filename);
            traversableContext.put("sgid", (Object)this._sgid);
            this._scriptStatus = ApexImporter.getScriptStatus(this._filename);
            traversableContext.put("SCRIPT.STATUS", (Object)this._scriptStatus);
            this._availId = this.checkAvail(Long.parseLong(this._sgid), Long.parseLong(this._info.get("p_id")));
            this.removeAll();
            this.init();
            this.setModels();
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            Object object;
            String string = (String)this._id.getSelectedItem();
            if (string.equals(ApexImportArb.getString(13))) {
                traversableContext.put("p_id", (Object)this._newId.getText());
                traversableContext.put("offset", (Object)Math.round(Math.random() * Math.pow(10.0, 10.0)));
            } else if (string.equals(ApexImportArb.getString(12))) {
                traversableContext.put("p_id", (Object)this.getNewID());
                traversableContext.put("offset", (Object)Math.round(Math.random() * Math.pow(10.0, 10.0)));
            } else {
                traversableContext.put("p_id", (Object)this._info.get("p_id"));
                traversableContext.put("offset", (Object)"0");
            }
            if (!string.equals(ApexImportArb.getString(12))) {
                object = (String)traversableContext.get("p_id");
                int n = this.validateId(Long.parseLong(this._sgid), Long.parseLong((String)object));
                if (n == -1) {
                    throw new TraversalException(ApexImportArb.getString(23));
                }
                if (n == 1 && !this._overwrite.isSelected()) {
                    throw new TraversalException(ApexImportArb.getString(24));
                }
            }
            if (this._info.get("p_alias").equals(this._newAlias.getText())) {
                traversableContext.put("p_alias", (Object)this._newAlias.getText());
            } else {
                traversableContext.put("p_alias", (Object)this._newAlias.getText());
            }
            if (!this.validateAlias((String)traversableContext.get("p_id"), (String)traversableContext.get("p_alias"))) {
                throw new TraversalException(ApexImportArb.getString(32));
            }
            traversableContext.put("p_name", (Object)this._newName.getText());
            traversableContext.put("p_build_status", this._run.getSelectedItem());
            object = new ArrayList();
            ((ArrayList)object).add(this._workspaces.getSelectedItem().toString());
            String string2 = DBUtil.getInstance().executeReturnOneCol(this._toConn, "select workspace_id from  apex_workspace_schemas ws where workspace_name = :WORKSPACE_NAME", (List)object);
            traversableContext.put("workspace_name", (Object)this._workspaces.getSelectedItem().toString());
            traversableContext.put("sgid", (Object)string2);
            traversableContext.put("SCRIPT.RUN", (Object)this._runScript.getText());
        }
    }

    public void setModels() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SCHEMA", this._username);
        SQLComboxModel sQLComboxModel = new SQLComboxModel(this._toConn, "select workspace_name from  apex_workspace_schemas ws", (ArrayList)null, null);
        sQLComboxModel.load();
        sQLComboxModel.setSelectedItem(sQLComboxModel.getElementAt(0));
        this._workspaces.setModel(sQLComboxModel);
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("RUN_ONLY");
        defaultComboBoxModel.addElement("RUN_AND_BUILD");
        this._run.setModel(defaultComboBoxModel);
        if (this._info.get("p_build_status").equals("RUN_AND_BUILD")) {
            this._run.setSelectedIndex(1);
        }
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement(ApexImportArb.getString(12));
        if (this._availId >= 0) {
            defaultComboBoxModel2.addElement(this._info.get("p_id"));
        }
        defaultComboBoxModel2.addElement(ApexImportArb.getString(13));
        this._id.setModel(defaultComboBoxModel2);
    }

    public void addPair(String string, Object object, Component component) {
        ++this._gbc.gridy;
        this.add(new JLabel(string), this._gbc);
        ++this._gbc.gridx;
        if (component == null) {
            this._gbc.gridwidth = 2;
        }
        if (object instanceof String) {
            this.add(new JLabel(object.toString()), this._gbc);
        } else {
            this.add((Component)object, this._gbc);
        }
        ++this._gbc.gridx;
        if (component != null) {
            this.add(component, this._gbc);
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridx = 0;
    }

    public void init() {
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        this._username = null;
        try {
            this._username = this._toConn.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._workspaces = new JComboBox();
        this.addPair(ApexImportArb.getString(30), this._workspaces, null);
        this.addPair(ApexImportArb.getString(7), this._username, null);
        this._newName = new JTextField(this._info.get("p_name"));
        this._newName.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newName.setSelectionStart(0);
                ApexImportIDPanel.this._newName.setSelectionEnd(ApexImportIDPanel.this._newName.getText().length());
            }
        });
        this.addPair(ApexImportArb.getString(17), this._info.get("p_name"), this._newName);
        this._newAlias = new JTextField(this._info.get("p_alias"));
        this._newAlias.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newAlias.setSelectionStart(0);
                ApexImportIDPanel.this._newAlias.setSelectionEnd(ApexImportIDPanel.this._newAlias.getText().length());
            }
        });
        this.addPair(ApexImportArb.getString(18), this._info.get("p_alias"), this._newAlias);
        this._run = new JComboBox();
        this.addPair(ApexImportArb.getString(8), this._info.get("p_build_status"), this._run);
        this._id = new JComboBox();
        this._newId = new JTextField();
        this._newId.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ApexImportIDPanel.this._newId.setSelectionStart(0);
                ApexImportIDPanel.this._newId.setSelectionEnd(ApexImportIDPanel.this._newId.getText().length());
            }
        });
        this._newId.setEnabled(false);
        this.addPair(ApexImportArb.getString(9), this._id, this._newId);
        this._newId.setEnabled(false);
        this._newId.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                ApexImportIDPanel.this.validateId(Long.parseLong(ApexImportIDPanel.this._sgid), Long.parseLong((String)ApexImportIDPanel.this._info.get("p_id")));
            }

            public void removeUpdate(DocumentEvent documentEvent) {
            }

            public void insertUpdate(DocumentEvent documentEvent) {
            }
        });
        this._id.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1 && ApexImportIDPanel.this._id.getSelectedItem().equals(ApexImportArb.getString(13))) {
                    ApexImportIDPanel.this._newId.setEnabled(true);
                } else {
                    ApexImportIDPanel.this._newId.setEnabled(false);
                }
                if (itemEvent.getStateChange() == 1 && ApexImportIDPanel.this._id.getSelectedItem().equals(ApexImportIDPanel.this._info.get("p_id"))) {
                    ApexImportIDPanel.this._overwrite.setEnabled(true);
                } else {
                    ApexImportIDPanel.this._overwrite.setEnabled(false);
                }
            }
        });
        this._overwrite = new JCheckBox(ApexImportArb.getString(20));
        this._appName = new JLabel(this.getAppName(Long.parseLong(this._sgid), Long.parseLong(this._info.get("p_id"))));
        this.addPair(ApexImportArb.getString(21), this._appName, this._overwrite);
        this._overwrite.setEnabled(false);
        this._runScript = new JCheckBox(ApexImportArb.getString(41));
        if (this._scriptStatus == ApexImporter.ScriptStatus.NONCONDITIONAL) {
            this.addPair(ApexImportArb.getString(46), ApexImportArb.getString(40), this._runScript);
        } else if (this._scriptStatus == ApexImporter.ScriptStatus.CONDTIONAL) {
            this.addPair(ApexImportArb.getString(46), ApexImportArb.getString(42), null);
        }
    }

    private int validateId(Long l, Long l2) {
        int n = this.checkAvail(l, l2);
        if (n == 1) {
            this._appName.setText(this.getAppName(l, l2));
            this._overwrite.setEnabled(true);
        } else if (n == 0) {
            this._appName.setText("");
            this._overwrite.setEnabled(false);
        } else {
            this._appName.setText(ApexImportArb.getString(22));
            this._overwrite.setEnabled(false);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNewID() {
        CallableStatement callableStatement = null;
        String string = null;
        try {
            callableStatement = this._toConn.prepareCall("begin ? := apex_util.minimum_free_application_id; end; ");
            callableStatement.registerOutParameter(1, -5);
            callableStatement.execute();
            string = callableStatement.getBigDecimal(1).toString();
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkAvail(Long l, Long l2) {
        CallableStatement callableStatement = null;
        int n = -1;
        try {
            callableStatement = this._toConn.prepareCall("begin ? := apex_util.get_application_id_status(?,?); end; ");
            callableStatement.setLong(2, (long)l);
            callableStatement.setLong(3, (long)l2);
            callableStatement.registerOutParameter(1, -5);
            callableStatement.execute();
            n = callableStatement.getBigDecimal(1).intValue();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAppName(Long l, Long l2) {
        String string = null;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this._fromConn.prepareCall("begin ? := apex_util.GET_APPLICATION_NAME(?,?); end; ");
            callableStatement.setLong(2, (long)l);
            callableStatement.setLong(3, (long)l2);
            callableStatement.registerOutParameter(1, 12);
            callableStatement.execute();
            string = callableStatement.getString(1);
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return string;
    }

    private boolean validateAlias(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        arrayList.add(this._workspaces.getSelectedItem().toString());
        arrayList.add(string);
        String string3 = DBUtil.getInstance().executeReturnOneCol(this._toConn, "select count(1) from  apex_Applications where alias = :ALIAS and workspace = :WORKSPACE_NAME and application_id <> :APPID", arrayList);
        return !string3.equals("1");
    }
}

