/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.jdeveloper.cm.CMException;

public class ApexImportFilePanel
extends DefaultTraversablePanel {
    private FilePanel _f;

    public ApexImportFilePanel() {
        this.setLayout(new GridBagLayout());
        this._f = new FilePanel();
        JLabel jLabel = new JLabel(ApexImportArb.getString(4));
        this.add(jLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 0, 0), 0, 0));
        this.add(this._f, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(10, 1, 10, 0), 0, 0));
        this.setDefaultTitle(ApexImportArb.getString(1));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this._f.getFileName() == null || this._f.getFileName().trim().equals("")) {
            throw new TraversalException(ApexImportArb.getString(10));
        }
        File file = new File(this._f.getFileName());
        if (!file.exists()) {
            throw new TraversalException(ApexImportArb.getString(14));
        }
        Map<String, String> map = ApexImporter.getInfo(this._f.getFileName());
        if (map == null || map.get("p_id") == null) {
            throw new TraversalException(ApexImportArb.getString(19));
        }
        Context context = (Context)traversableContext.get("CONTEXT");
        DBObject dBObject = (DBObject)context.getProperty("DB_OBJECT");
        Connection connection = dBObject.getConnection();
        if (traversableContext.get("connection") != null) {
            try {
                connection = Connections.getInstance().getConnection((String)traversableContext.get("connection"));
            }
            catch (CMException cMException) {
                // empty catch block
            }
        }
        DBUtil dBUtil = DBUtil.getInstance();
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeReturnOneCol(connection, "select workspace_id from APEX_WORKSPACE_SCHEMAS ", new ArrayList());
        if (string == null) {
            throw new TraversalException(ApexImportArb.getString(39));
        }
        traversableContext.put("sgid", (Object)string);
        traversableContext.put("FILENAME", (Object)this._f.getFileName());
    }

    class FilePanel
    extends JPanel
    implements ActionListener {
        private JButton _browse;
        private JTextField _file;

        public FilePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(ApexImportArb.getString(5)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
            this._file = new JTextField();
            this.add((Component)this._file, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 1, 0, 5), 0, 0));
            this._browse = new JButton(ApexImportArb.getString(6));
            this._browse.addActionListener(this);
            this.add((Component)this._browse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 1, 0, 0), 0, 0));
            this._file.requestFocus();
        }

        public String getFileName() {
            return this._file.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.setSelectionScope(2);
            uRLChooser.setSelectionMode(0);
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                this._file.setText(uRLChooser.getSelectedURL().getFile());
            }
        }
    }
}

