/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.ide.webbrowser.URLHyperlinkButton;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleCallableStatement;

public class ApexDropAction
extends AbstractMenuAction {
    static final String COUNT_SQL = "select count(1) script from APEX_APPLICATION_SUPP_OBJECTS   where application_id = :APPLICATION_ID";
    static final String DROP_SQL = "begin   wwv_flow_api.set_security_group_id(p_security_group_id=>:SGID); wwv_flow_api.remove_flow(:APPLICATION_ID); end;";
    private String _args;
    private static final Logger LOGGER = Logger.getLogger(ApexDropAction.class.getName());
    private JCheckBox _run;
    private ScriptRunner _sr;
    private DBObject _dbo;

    public void launch() {
        this._dbo = this.getDBObject();
        boolean bl = false;
        String string = DBUtil.getInstance().executeReturnOneCol(this.getDBObject().getConnectionName(), COUNT_SQL, this.getDBObject().getDictionary());
        if (string.equals("1")) {
            bl = true;
        }
        if (bl) {
            this.dropAppUninstall();
        } else {
            boolean bl2 = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)(ApexImportArb.getString(48) + ":" + this.getDBObject().getObjectName()), (String)ApexImportArb.getString(48), (String)"f1_dropapexapplication");
            if (bl2) {
                this.dropApp();
            }
        }
    }

    private void dropAppUninstall() {
        this._run = new JCheckBox(ApexImportArb.getString(44));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel(ApexImportArb.getString(48)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        jPanel.add((Component)new JLabel(ApexImportArb.getInstance().formatImpl(43, (Object)this.getDBObject().getObjectName())), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        jPanel.add((Component)this._run, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        URLHyperlinkButton uRLHyperlinkButton = new URLHyperlinkButton();
        uRLHyperlinkButton.setText("Preview Script");
        uRLHyperlinkButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ApexDropAction.this.showPreview();
            }
        });
        jPanel.add((Component)uRLHyperlinkButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl;
                boolean bl2 = bl = !((JEWTDialog)actionEvent.getSource()).isCancelled();
                if (bl && ApexDropAction.this._run.isSelected()) {
                    ApexDropAction.this.runUninstall();
                } else if (bl && !ApexDropAction.this._run.isSelected()) {
                    ApexDropAction.this.dropApp();
                }
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
            }
        };
        UIUtils.showPanelAsDialog(jPanel, ApexImportArb.getString(48), actionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropApp() {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)this.getDBObject().getConnection().prepareCall(DROP_SQL);
            oracleCallableStatement.setBigDecimalAtName("SGID", (BigDecimal)this.getDBObject().getDictionary().get("WORKSPACE_ID"));
            oracleCallableStatement.setBigDecimalAtName("APPLICATION_ID", (BigDecimal)this.getDBObject().getDictionary().get("APPLICATION_ID"));
            oracleCallableStatement.execute();
            this.getDBObject().getConnection().commit();
        }
        catch (SQLException sQLException) {
            ExceptionHandler.handleException(sQLException);
        }
        finally {
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void setArgs(String string) {
        this._args = string;
    }

    public void runUninstall() {
        final Connection connection = this.getDBObject().getConnection();
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        final DBObject dBObject = this.getDBObject();
        final DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(ApexImportArb.getString(44), null, 500, null, (Component)basicEditorPane);
        basicEditorPane.setText("");
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            public void cancel() {
                ApexDropAction.this._sr.interrupt();
                this._isCanceled = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                ApexDropAction.this.run(basicEditorPane, ApexImporter.getUnInstallScript(connection, (BigDecimal)dBObject.getDictionary().get("APPLICATION_ID")), connection, delayedProgressRunnable);
                try {
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                int n = ApexDropAction.this._sr.getScriptRunnerContext().getSqlError();
                String string = (String)ApexDropAction.this._sr.getScriptRunnerContext().getProperty("sqldev.last.err.name");
                if (n != 0 || string != null || ApexDropAction.this._sr.getScriptRunnerContext().getExited()) {
                    ScriptUtils.showError(basicEditorPane);
                } else {
                    ApexDropAction.this.dropApp();
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)ApexImportArb.getString(49), (String)ApexImportArb.getString(49), null);
                }
                return var1_1;
            }

            public void finish(Object object) {
                if (this._isCanceled) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                delayedProgressRunnable.setRunnable(iDelayedProgressRunnable);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    private void run(BasicEditorPane basicEditorPane, String string, Connection connection, DelayedProgressRunnable delayedProgressRunnable) {
        this._sr = new ScriptRunner(string, connection);
        basicEditorPane.setEditable(true);
        this._sr.setScriptRunnerContext(new ScriptRunnerContext());
        this._sr.getScriptRunnerContext().setSubstitutionChar('^');
        this._sr.getScriptRunnerContext().setSubstitutionOn(false);
        this._sr.getScriptRunnerContext().setScanOn(false);
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
        }
        this._sr.setOut(bufferedOutputStream);
        this._sr.start();
        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
        outputRedirector.setName("Script output reader");
        outputRedirector.setProgressPanel(delayedProgressRunnable.getProgressPanel());
        outputRedirector.start();
        basicEditorPane.setEditable(false);
        while (this._sr.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void showPreview() {
        String string = ApexImporter.getUnInstallScript(this._dbo.getConnection(), (BigDecimal)this._dbo.getDictionary().get("APPLICATION_ID"));
        BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane);
        basicEditorPane.setText(string);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)"Uninstall Script", (int)2);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }
}

