/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.dt.ConnectionNode;

public class InitializeConnectionListener
implements ConnectionListener {
    private ConnectionNode _cn;
    private Connections _conns;
    private static final String INIT = "begin dbms_application_info.set_module(?,?); end;";
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public void connectionAdded(ConnectionEvent connectionEvent) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            if (!(editor instanceof IDBEditor) || ((IDBEditor)editor).getConnectionName() == null || !((IDBEditor)editor).getConnectionName().equals(string)) continue;
            editor.getController().handleEvent(this.getConnClosedAction(), editor.getContext());
        }
    }

    public IdeAction getConnClosedAction() {
        IdeAction ideAction = IdeAction.get((int)IDBEditor.CONN_CLOSED_CMD_ID);
        return ideAction;
    }

    public void connectionModified(ConnectionEvent connectionEvent) {
    }

    public void connectionOpened(ConnectionEvent connectionEvent) {
        final ConnectionEvent connectionEvent2 = connectionEvent;
        Thread thread = new Thread(){

            public void run() {
                InitializeConnectionListener.this.initConnection(connectionEvent2);
            }
        };
        thread.setName("InitConnection");
        thread.start();
    }

    public void initConnection(ConnectionEvent connectionEvent) {
        String string = connectionEvent.getConnectionName();
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            int n;
            connection = connections.getConnection(string);
            ConnectionTypeDetails connectionTypeDetails = ConnectionTypeDetails.getTypeDetails(string, connection);
            if (connectionTypeDetails.isSupportsAutocommit()) {
                connections.getDatabase(string, connection);
                n = DBConfig.getInstance().getBoolean("AUTOCOMMIT").booleanValue() ? 1 : 0;
                connection.setAutoCommit(n != 0);
            }
            if (Connections.getInstance().isOracle(connectionEvent.getConnectionName())) {
                n = connection.getMetaData().getDatabaseMajorVersion();
                if (n < 9) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Database Versions 9.x and above are supported.", (String)"Unsupported Database Version", (String)"f1_nonsupporteddb_html");
                }
                this.runLoginSql(string);
                DefaultNLSProvider defaultNLSProvider = NLSProvider.getProvider(string);
                if (defaultNLSProvider == null) {
                    NLSUtils.setNlsFromPrefs(string);
                    NLSUtils.populateNLS(connection);
                }
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (CMException cMException) {
            cMException.printStackTrace();
        }
    }

    private void runLoginSql(String string) {
        String string2 = DBConfig.getInstance().getString("DEFAULTPATH");
        File file = new File(string2 + "/login.sql");
        if (!file.exists() && System.getenv().get("SQLPATH") != null) {
            String[] stringArray;
            String string3 = System.getenv().get("SQLPATH");
            for (String string4 : stringArray = string3.split(File.pathSeparator)) {
                if (file.exists()) continue;
                file = new File(string4 + "/login.sql");
            }
        }
        if (file.exists()) {
            try {
                ScriptUtils.runAsScript(new FileInputStream(file), string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.logger.fine("No login.sql found");
            }
        }
    }

    public void connectionRemoved(ConnectionEvent connectionEvent) {
    }

    public void connectionRenamed(ConnectionEvent connectionEvent) {
    }
}

