/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.logging.ui.LoggerNameCompletion;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.icons.OracleIcons;

public class LoggingController
implements ContextMenuListener,
Controller {
    private int _currRow;
    private IdeAction _off;
    private String _cmdOff = "CHANGE_LOGGING_LEVEL.OFF";
    private int _cmdIdOff = Ide.findOrCreateCmdID((String)this._cmdOff);
    private IdeAction _severe;
    private String _cmdSevere = "CHANGE_LOGGING_LEVEL.SEVERE";
    private int _cmdIdSevere = Ide.findOrCreateCmdID((String)this._cmdSevere);
    private IdeAction _warning;
    private String _cmdWarn = "CHANGE_LOGGING_LEVEL.WARN";
    private int _cmdIdWarn = Ide.findOrCreateCmdID((String)this._cmdWarn);
    private IdeAction _info;
    private String _cmdInfo = "CHANGE_LOGGING_LEVEL.INFO";
    private int _cmdIdInfo = Ide.findOrCreateCmdID((String)this._cmdInfo);
    private IdeAction _config;
    private String _cmdConfig = "CHANGE_LOGGING_LEVEL.CONFIG";
    private int _cmdIdConfig = Ide.findOrCreateCmdID((String)this._cmdConfig);
    private IdeAction _fine;
    private String _cmdFine = "CHANGE_LOGGING_LEVEL.FINE";
    private int _cmdIdFine = Ide.findOrCreateCmdID((String)this._cmdFine);
    private IdeAction _finer;
    private String _cmdFiner = "CHANGE_LOGGING_LEVEL.FINER";
    private int _cmdIdFiner = Ide.findOrCreateCmdID((String)this._cmdFiner);
    private IdeAction _finest;
    private String _cmdFinest = "CHANGE_LOGGING_LEVEL.FINEST";
    private int _cmdIdFinest = Ide.findOrCreateCmdID((String)this._cmdFinest);
    private IdeAction _all;
    private String _cmdAll = "CHANGE_LOGGING_LEVEL.ALL";
    private int _cmdIdAll = Ide.findOrCreateCmdID((String)this._cmdAll);
    private IdeAction _change;
    private String _cmdChange = "JAVA_UTIL_LOGGING_CHANGE";
    private int _cmdIdChange = Ide.findOrCreateCmdID((String)this._cmdChange);
    private IdeAction _view;
    private String _cmdView = "JAVA_UTIL_LOGGING_VIEW";
    private int _cmdIdView = Ide.findOrCreateCmdID((String)this._cmdView);
    private JMenu _menu;
    private JTable _table;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private IdeAction _saveas;

    public LoggingController(JTable jTable) {
        this._table = jTable;
    }

    private IdeAction createAction(int n, String string, Icon icon) {
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n2 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string2, null, (Integer)n2, null, (Object)icon, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    private void init() {
        if (this._off == null) {
            this._off = this.createAction(this._cmdIdOff, "Off", null);
            this._severe = this.createAction(this._cmdIdSevere, "Severe", null);
            this._warning = this.createAction(this._cmdIdWarn, "Warning", null);
            this._info = this.createAction(this._cmdIdInfo, "Info", null);
            this._config = this.createAction(this._cmdIdConfig, "Config", null);
            this._fine = this.createAction(this._cmdIdFine, "Fine", null);
            this._finer = this.createAction(this._cmdIdFiner, "Finer", null);
            this._finest = this.createAction(this._cmdIdFinest, "Finest", null);
            this._all = this.createAction(this._cmdIdAll, "All", null);
            this._change = this.createAction(this._cmdIdChange, "Change", null);
            this._view = this.createAction(this._cmdIdView, "View All", OracleIcons.getIcon((String)"table.png"));
            this._saveas = IdeAction.find((int)12);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.init();
        Object object = contextMenu.getContext().getEvent().getSource();
        if (this._table == object) {
            this._currRow = this._table.rowAtPoint(((MouseEvent)contextMenu.getContext().getEvent()).getPoint());
            JMenuItem jMenuItem = contextMenu.createMenuItem((ToggleAction)this._view);
            contextMenu.add((Component)jMenuItem);
            contextMenu.add((Component)this.getMenu());
            jMenuItem = contextMenu.createMenuItem((ToggleAction)this._change, MenuConstants.SECTION_LOG_WINDOW_CTXT_MENU);
            contextMenu.add((Component)jMenuItem);
            jMenuItem = contextMenu.createMenuItem((ToggleAction)this._saveas, MenuConstants.WEIGHT_LOG_WINDOW_SAVE_AS);
            contextMenu.add((Component)jMenuItem);
            IdeAction.get((int)12).setEnabled(true);
            contextMenu.addMenuFilter(new MenuFilter(){

                public boolean accept(Component component) {
                    return !(component instanceof JMenuItem) || ((JMenuItem)component).getAction() == null || ((IdeAction)((JMenuItem)component).getAction()).getCommandId() != 12;
                }
            });
        }
    }

    private JMenu getMenu() {
        if (this._menu == null) {
            this.init();
            this._menu = new JMenu("Change Log Level");
            this._menu.add((Action)this._off);
            this._menu.add((Action)this._severe);
            this._menu.add((Action)this._warning);
            this._menu.add((Action)this._info);
            this._menu.add((Action)this._config);
            this._menu.add((Action)this._fine);
            this._menu.add((Action)this._finer);
            this._menu.add((Action)this._finest);
            this._menu.add((Action)this._all);
        }
        return this._menu;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == this._cmdIdOff) {
            this.getLogger(this._currRow).setLevel(Level.OFF);
            return true;
        }
        if (n == this._cmdIdSevere) {
            this.getLogger(this._currRow).setLevel(Level.SEVERE);
            return true;
        }
        if (n == this._cmdIdWarn) {
            this.getLogger(this._currRow).setLevel(Level.WARNING);
            return true;
        }
        if (n == this._cmdIdInfo) {
            this.getLogger(this._currRow).setLevel(Level.INFO);
            return true;
        }
        if (n == this._cmdIdConfig) {
            this.getLogger(this._currRow).setLevel(Level.CONFIG);
            return true;
        }
        if (n == this._cmdIdFine) {
            this.getLogger(this._currRow).setLevel(Level.FINE);
            return true;
        }
        if (n == this._cmdIdFiner) {
            this.getLogger(this._currRow).setLevel(Level.FINER);
            return true;
        }
        if (n == this._cmdIdFinest) {
            this.getLogger(this._currRow).setLevel(Level.FINEST);
            return true;
        }
        if (n == this._cmdIdAll) {
            this.getLogger(this._currRow).setLevel(Level.ALL);
            return true;
        }
        if (n == this._cmdIdChange) {
            this.promptAndChange();
            return true;
        }
        if (n == this._cmdIdView) {
            this.viewAll();
            return true;
        }
        return false;
    }

    public void clearAll() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this._table.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    private Logger getLogger(int n) {
        String string = (String)this._table.getValueAt(n, 3);
        return Logger.getLogger(string != null ? string : "");
    }

    public boolean update(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == 11) {
            ideAction.setEnabled(true);
            return true;
        }
        return false;
    }

    private void viewAll() {
        Object object;
        final DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Name");
        defaultTableModel.addColumn("Level");
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (String object22 : arrayList) {
            object = Logger.getLogger(object22);
            String string = object != null && ((Logger)object).getLevel() != null ? ((Logger)object).getLevel().getName() : null;
            Object[] objectArray = new String[]{object22, string};
            if (object22 == null) continue;
            defaultTableModel.addRow(objectArray);
        }
        JTable jTable = new JTable(defaultTableModel);
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Level.OFF.getName());
        jComboBox.addItem(Level.SEVERE.getName());
        jComboBox.addItem(Level.WARNING.getName());
        jComboBox.addItem(Level.INFO.getName());
        jComboBox.addItem(Level.CONFIG.getName());
        jComboBox.addItem(Level.FINE.getName());
        jComboBox.addItem(Level.FINER.getName());
        jComboBox.addItem(Level.FINEST.getName());
        jComboBox.addItem(Level.ALL.getName());
        jTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jComboBox));
        object = new JScrollPane(jTable);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object, "Center");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                    Level level;
                    String string = (String)defaultTableModel.getValueAt(i, 0);
                    String string2 = (String)defaultTableModel.getValueAt(i, 1);
                    if (string2 == null) continue;
                    Logger logger = Logger.getLogger(string);
                    Level level2 = Level.parse((String)defaultTableModel.getValueAt(i, 1));
                    if (level2 == (level = logger.getLevel())) continue;
                    logger.setLevel(level2);
                    LoggingController.this.logger.info("Changed:" + string + " to " + level2.getName());
                }
            }
        };
        LoggingController.showPanelAsDialog(jPanel, "All Logging Levels", actionListener, 10, true);
    }

    private void promptAndChange() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        final CompletionTextField completionTextField = new CompletionTextField();
        completionTextField.getPopupHandler().registerInsightProvider((FieldInsightProvider)new LoggerNameCompletion());
        final JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(Level.OFF.getName());
        jComboBox.addItem(Level.SEVERE.getName());
        jComboBox.addItem(Level.WARNING.getName());
        jComboBox.addItem(Level.INFO.getName());
        jComboBox.addItem(Level.CONFIG.getName());
        jComboBox.addItem(Level.FINE.getName());
        jComboBox.addItem(Level.FINER.getName());
        jComboBox.addItem(Level.FINEST.getName());
        jComboBox.addItem(Level.ALL.getName());
        jPanel.add((Component)completionTextField, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        jPanel.add(jComboBox, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((JEWTDialog)actionEvent.getSource()).closeDialog(true);
                Logger logger = Logger.getLogger(completionTextField.getText());
                String string = (String)jComboBox.getSelectedItem();
                logger.setLevel(Level.parse(string));
                LoggingController.this.logger.info("Changed:" + completionTextField.getText() + " to :" + Level.parse(string).getName());
            }
        };
        LoggingController.showPanelAsDialog(jPanel, "Change Logging Level", actionListener, 10, true);
    }

    private static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)n);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        jEWTDialog.setModal(bl);
        jEWTDialog.setPreferredSize(dimension);
        jEWTDialog.setSize(dimension);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }
}

