/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db.misc;

import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.OracleDriver;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;

public class TNSPingExample {
    private static PrintStream out = System.out;
    private static String tns = "(description = (address = (protocol = tcp)(host = stadh49.us.oracle.com)(port = 1521))(connect_data =(service_name = orcl)))";

    public static void testThread() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            String string = "jdbc:oracle:thin:@" + tns;
            Connection connection = DriverManager.getConnection(string, "klrice", "klrice");
            connection.setAutoCommit(false);
            final PreparedStatement preparedStatement = connection.prepareStatement("select systimestamp from dual");
            Thread thread = new Thread(){

                public void run() {
                    try {
                        for (int i = 0; i < 10; ++i) {
                            ResultSet resultSet = preparedStatement.executeQuery();
                            resultSet.next();
                            out.println(resultSet.getString(1));
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                }
            };
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testPingThread() {
        Thread thread = new Thread(){

            public void run() {
                NSProtocol nSProtocol = new NSProtocol();
                for (int i = 0; i < 20; ++i) {
                    try {
                        long l = System.currentTimeMillis();
                        nSProtocol.connect(tns, new Properties());
                        nSProtocol.disconnect();
                        out.println("Response:" + (System.currentTimeMillis() - l) + " ms");
                        continue;
                    }
                    catch (NetException netException) {
                        String string = netException.getMessage();
                        out.println(string);
                        if (string.indexOf("ORA-") != -1 || string.indexOf("TNS-") != -1) continue;
                        out.println("TNS-12541: TNS:no listener");
                        continue;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        TNSPingExample.testThread();
        TNSPingExample.testPingThread();
    }
}

