/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.ide.Ide;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatter {
    private static BasicEditorPane textPanelArea = new BasicEditorPane();
    private static Font font = textPanelArea.getFont();
    private static FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
    private static final String spaceStr = " ";
    private static final int spacePixelWidth = fm.stringWidth(" ");
    private DBConfig _cfg;

    private int getMaxRows() {
        if (!Ide.isRunning() || DBConfig.getInstance().getString("MAXSCRIPTROWS") == null || DBConfig.getInstance().getString("MAXSCRIPTROWS").equals("unlimited") || DBConfig.getInstance().getString("MAXSCRIPTROWS").equals("") || Integer.parseInt(DBConfig.getInstance().getString("MAXSCRIPTROWS")) < 0) {
            return Integer.MAX_VALUE;
        }
        return DBConfig.getInstance().getInt("MAXSCRIPTROWS");
    }

    public int rset2sqlplus(ResultSet resultSet, Connection connection, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = this.rset2sqlplus(resultSet, connection, stringBuffer);
        bufferedOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
        return n;
    }

    public int rset2sqlplus(ResultSet resultSet, Connection connection, StringBuffer stringBuffer) throws IOException, SQLException {
        int n;
        int n2;
        int n3 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n4 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n4 + 1];
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 1; i < n4 + 1; ++i) {
            n2 = resultSetMetaData.getColumnDisplaySize(i);
            if (resultSetMetaData.getColumnType(i) == -3) {
                n2 *= 2;
            }
            if (n2 > 4000 || n2 <= 0) {
                n2 = 4000;
            }
            nArray[i] = resultSetMetaData.getColumnType(i) == 91 || resultSetMetaData.getColumnType(i) == 92 || resultSetMetaData.getColumnType(i) == 93 ? 25 : (n2 < resultSetMetaData.getColumnName(i).length() ? resultSetMetaData.getColumnName(i).length() : n2);
            stringBuffer2.append(resultSetMetaData.getColumnName(i));
            int n5 = nArray[i] - resultSetMetaData.getColumnName(i).length();
            for (n = 0; n < n5; ++n) {
                stringBuffer2.append(spaceStr);
            }
            n5 = nArray[i];
            for (n = 0; n < n5; ++n) {
                stringBuffer3.append("-");
            }
            stringBuffer2.append(spaceStr);
            stringBuffer3.append(spaceStr);
        }
        stringBuffer.append(stringBuffer2.toString());
        stringBuffer.append("\n");
        stringBuffer.append(stringBuffer3.toString());
        stringBuffer.append("\n");
        ArrayList<StringBuffer> arrayList = new ArrayList<StringBuffer>();
        for (n2 = 0; n2 < n4 + 1; ++n2) {
            arrayList.add(new StringBuffer());
        }
        while (resultSet.next() && n3 < this.getMaxRows()) {
            ++n3;
            for (n2 = 1; n2 < n4 + 1; ++n2) {
                String string;
                Object object = null;
                if (resultSet instanceof OracleResultSet) {
                    try {
                        object = ((OracleResultSet)resultSet).getOracleObject(n2);
                    }
                    catch (SQLException sQLException) {
                        object = resultSet.getObject(n2);
                    }
                } else {
                    object = resultSet.getObject(n2);
                }
                if ((string = DataTypesUtil.stringValue(object, connection)) != null) {
                    arrayList.set(n2, new StringBuffer(DataTypesUtil.stringValue(string, resultSet.getStatement().getConnection()).replace("\r\n", "\n")));
                    continue;
                }
                arrayList.set(n2, new StringBuffer());
            }
            n2 = 0;
            n = 0;
            while (n == 0) {
                n = 1;
                for (int i = 1; i < n4 + 1; ++i) {
                    StringBuffer stringBuffer4 = (StringBuffer)arrayList.get(i);
                    int n6 = stringBuffer4.indexOf("\n");
                    if (n6 != -1) {
                        n2 = 1;
                        StringBuffer stringBuffer5 = stringBuffer4;
                        stringBuffer4 = new StringBuffer(stringBuffer4.substring(0, n6));
                        stringBuffer5 = stringBuffer5.length() - 1 > n6 ? new StringBuffer(stringBuffer5.substring(n6 + 1)) : new StringBuffer("");
                        arrayList.set(i, stringBuffer5);
                        n = 0;
                    } else {
                        arrayList.set(i, new StringBuffer(""));
                    }
                    int n7 = fm.stringWidth(stringBuffer4.toString());
                    if (n7 < nArray[i] * spacePixelWidth) {
                        int n8 = nArray[i] * spacePixelWidth - n7;
                        int n9 = n8 / spacePixelWidth;
                        for (int j = 0; j < n9; ++j) {
                            stringBuffer4.append(spaceStr);
                        }
                    }
                    stringBuffer4.append(spaceStr);
                    stringBuffer.append(stringBuffer4.toString());
                }
                stringBuffer.append("\n");
            }
            if (n2 != 1) continue;
            stringBuffer.append("\n");
        }
        if (n3 == this.getMaxRows() && resultSet.next()) {
            this.logMaxReached(stringBuffer);
        }
        return n3;
    }

    public int rset2csv(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        while (resultSet.next() && n < this.getMaxRows()) {
            ++n;
            for (int i = 0; i < n2; ++i) {
                if (resultSet.getString(i + 1) != null) {
                    bufferedOutputStream.write(34);
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).getBytes("UTF-8"));
                    bufferedOutputStream.write(34);
                }
                if (i == n2) continue;
                bufferedOutputStream.write(44);
            }
            bufferedOutputStream.write(10);
        }
        if (n == this.getMaxRows() && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public int rset2xml(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        int n2 = resultSet.getMetaData().getColumnCount();
        bufferedOutputStream.write("<results>".getBytes());
        while (resultSet.next() && n < this.getMaxRows()) {
            ++n;
            for (int i = 0; i < n2; ++i) {
                bufferedOutputStream.write("<![CDATA[".getBytes());
                if (resultSet.getBytes(i + 1) != null) {
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).getBytes("UTF-8"));
                }
                bufferedOutputStream.write("]]>".getBytes());
            }
        }
        bufferedOutputStream.write("</results>".getBytes());
        if (n == this.getMaxRows() && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public int rset2html(ResultSet resultSet, BufferedOutputStream bufferedOutputStream) throws IOException, SQLException {
        int n = 0;
        int n2 = resultSet.getMetaData().getColumnCount();
        bufferedOutputStream.write("<html>\n<body>\n<table>\n".getBytes());
        while (resultSet.next() && n < this.getMaxRows()) {
            bufferedOutputStream.write("<tr>\n".getBytes());
            ++n;
            for (int i = 0; i < n2; ++i) {
                bufferedOutputStream.write("<td>".getBytes());
                if (resultSet.getBytes(i + 1) != null) {
                    bufferedOutputStream.write(DataTypesUtil.stringValue(resultSet.getObject(i + 1), resultSet.getStatement().getConnection()).toString().getBytes("UTF-8"));
                }
                bufferedOutputStream.write("</td>".getBytes());
            }
            bufferedOutputStream.write("</tr>\n".getBytes());
        }
        bufferedOutputStream.write("</table></body></html>".getBytes());
        if (n == this.getMaxRows() && resultSet.next()) {
            this.logMaxReached(bufferedOutputStream);
        }
        return n;
    }

    public void logMaxReached(BufferedOutputStream bufferedOutputStream) throws IOException {
        bufferedOutputStream.write(("Only " + this.getMaxRows() + " rows currently supported in a script results").getBytes());
    }

    public void logMaxReached(StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("Only " + this.getMaxRows() + " rows currently supported in a script results");
    }
}

