/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.ComponentPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.ModalityEvent;
import sun.awt.windows.ModalityListener;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WCustomCursor;
import sun.awt.windows.WDesktopProperties;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WDragSourceContextPeer;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFontPeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WInputMethod;
import sun.awt.windows.WInputMethodDescriptor;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WMouseDragGestureRecognizer;
import sun.awt.windows.WPageDialog;
import sun.awt.windows.WPageDialogPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.WRobotPeer;
import sun.awt.windows.WScrollPanePeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WWindowPeer;
import sun.font.FontManager;
import sun.misc.PerformanceLogger;
import sun.print.PrintJob2D;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WToolkit
extends SunToolkit
implements Runnable {
    private static final DebugHelper dbg = DebugHelper.create(WToolkit.class);
    static GraphicsConfiguration config;
    WClipboard clipboard;
    private Hashtable cacheFontPeer;
    private WDesktopProperties wprops;
    protected boolean dynamicLayoutSetting = false;
    private static boolean loaded;
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.windows.WDataTransferer";
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String awtPrefix = "awt.";
    private static final String dndPrefix = "DnD.";
    private ModalityListenerList modalityListeners = new ModalityListenerList();

    private static native void initIDs();

    public static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new LoadLibraryAction("awt"));
            loaded = true;
        }
    }

    private static native void printWindowsVersion();

    private static native void disableCustomPalette();

    public static void resetGC() {
        config = GraphicsEnvironment.isHeadless() ? null : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static native boolean embeddedInit();

    public static native boolean embeddedDispose();

    public native void embeddedEventLoopIdleProcessing();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WToolkit() {
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("WToolkit construction");
        }
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            Thread thread = new Thread(this, "AWT-Windows");
            thread.setDaemon(true);
            thread.setPriority(6);
            AWTAutoShutdown.notifyToolkitThreadBusy();
            thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        boolean bl = this.init();
        if (bl) {
            object = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                    ThreadGroup threadGroup2 = threadGroup.getParent();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    return threadGroup;
                }
            });
            Runtime.getRuntime().addShutdownHook(new Thread((ThreadGroup)object, new Runnable(){

                public void run() {
                    WToolkit.this.shutdown();
                }
            }));
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
        if (bl) {
            this.eventLoop();
        }
    }

    private native boolean init();

    private native void eventLoop();

    private native void shutdown();

    protected native void finalize();

    public static native void startSecondaryEventLoop();

    public static native void quitSecondaryEventLoop();

    @Override
    public ButtonPeer createButton(Button button) {
        WButtonPeer wButtonPeer = new WButtonPeer(button);
        WToolkit.targetCreatedPeer(button, wButtonPeer);
        return wButtonPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        WTextFieldPeer wTextFieldPeer = new WTextFieldPeer(textField);
        WToolkit.targetCreatedPeer(textField, wTextFieldPeer);
        return wTextFieldPeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        WLabelPeer wLabelPeer = new WLabelPeer(label);
        WToolkit.targetCreatedPeer(label, wLabelPeer);
        return wLabelPeer;
    }

    @Override
    public ListPeer createList(List list) {
        WListPeer wListPeer = new WListPeer(list);
        WToolkit.targetCreatedPeer(list, wListPeer);
        return wListPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        WCheckboxPeer wCheckboxPeer = new WCheckboxPeer(checkbox);
        WToolkit.targetCreatedPeer(checkbox, wCheckboxPeer);
        return wCheckboxPeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        WScrollbarPeer wScrollbarPeer = new WScrollbarPeer(scrollbar);
        WToolkit.targetCreatedPeer(scrollbar, wScrollbarPeer);
        return wScrollbarPeer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        WScrollPanePeer wScrollPanePeer = new WScrollPanePeer(scrollPane);
        WToolkit.targetCreatedPeer(scrollPane, wScrollPanePeer);
        return wScrollPanePeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        WTextAreaPeer wTextAreaPeer = new WTextAreaPeer(textArea);
        WToolkit.targetCreatedPeer(textArea, wTextAreaPeer);
        return wTextAreaPeer;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        WChoicePeer wChoicePeer = new WChoicePeer(choice);
        WToolkit.targetCreatedPeer(choice, wChoicePeer);
        return wChoicePeer;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        WFramePeer wFramePeer = new WFramePeer(frame);
        WToolkit.targetCreatedPeer(frame, wFramePeer);
        return wFramePeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        WCanvasPeer wCanvasPeer = new WCanvasPeer(canvas);
        WToolkit.targetCreatedPeer(canvas, wCanvasPeer);
        return wCanvasPeer;
    }

    @Override
    public void disableBackgroundErase(Canvas canvas) {
        WCanvasPeer wCanvasPeer = (WCanvasPeer)canvas.getPeer();
        if (wCanvasPeer == null) {
            throw new IllegalStateException("Canvas must have a valid peer");
        }
        wCanvasPeer.disableBackgroundErase();
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        WPanelPeer wPanelPeer = new WPanelPeer(panel);
        WToolkit.targetCreatedPeer(panel, wPanelPeer);
        return wPanelPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        WWindowPeer wWindowPeer = new WWindowPeer(window);
        WToolkit.targetCreatedPeer(window, wWindowPeer);
        return wWindowPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        WDialogPeer wDialogPeer = new WDialogPeer(dialog);
        WToolkit.targetCreatedPeer(dialog, wDialogPeer);
        return wDialogPeer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        WFileDialogPeer wFileDialogPeer = new WFileDialogPeer(fileDialog);
        WToolkit.targetCreatedPeer(fileDialog, wFileDialogPeer);
        return wFileDialogPeer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = new WMenuBarPeer(menuBar);
        WToolkit.targetCreatedPeer(menuBar, wMenuBarPeer);
        return wMenuBarPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        WMenuPeer wMenuPeer = new WMenuPeer(menu);
        WToolkit.targetCreatedPeer(menu, wMenuPeer);
        return wMenuPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        WPopupMenuPeer wPopupMenuPeer = new WPopupMenuPeer(popupMenu);
        WToolkit.targetCreatedPeer(popupMenu, wPopupMenuPeer);
        return wPopupMenuPeer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        WMenuItemPeer wMenuItemPeer = new WMenuItemPeer(menuItem);
        WToolkit.targetCreatedPeer(menuItem, wMenuItemPeer);
        return wMenuItemPeer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        WCheckboxMenuItemPeer wCheckboxMenuItemPeer = new WCheckboxMenuItemPeer(checkboxMenuItem);
        WToolkit.targetCreatedPeer(checkboxMenuItem, wCheckboxMenuItemPeer);
        return wCheckboxMenuItemPeer;
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new WRobotPeer(graphicsDevice);
    }

    public WEmbeddedFramePeer createEmbeddedFrame(WEmbeddedFrame wEmbeddedFrame) {
        WEmbeddedFramePeer wEmbeddedFramePeer = new WEmbeddedFramePeer(wEmbeddedFrame);
        WToolkit.targetCreatedPeer(wEmbeddedFrame, wEmbeddedFramePeer);
        return wEmbeddedFramePeer;
    }

    WPrintDialogPeer createWPrintDialog(WPrintDialog wPrintDialog) {
        WPrintDialogPeer wPrintDialogPeer = new WPrintDialogPeer(wPrintDialog);
        WToolkit.targetCreatedPeer(wPrintDialog, wPrintDialogPeer);
        return wPrintDialogPeer;
    }

    WPageDialogPeer createWPageDialog(WPageDialog wPageDialog) {
        WPageDialogPeer wPageDialogPeer = new WPageDialogPeer(wPageDialog);
        WToolkit.targetCreatedPeer(wPageDialog, wPageDialogPeer);
        return wPageDialogPeer;
    }

    protected native void setDynamicLayoutNative(boolean var1);

    @Override
    public void setDynamicLayout(boolean bl) {
        if (bl == this.dynamicLayoutSetting) {
            return;
        }
        this.dynamicLayoutSetting = bl;
        this.setDynamicLayoutNative(bl);
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return this.dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    protected boolean isDynamicLayoutSupported() {
        Boolean bl = (Boolean)Toolkit.getDefaultToolkit().getDesktopProperty("awt.dynamicLayoutSupported");
        this.clearDesktopProperty("awt.dynamicLayoutSupported");
        return bl != null && !bl.equals(Boolean.FALSE);
    }

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSet() && this.isDynamicLayoutSupported();
    }

    @Override
    public boolean isFrameStateSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        if (config == null) {
            WToolkit.resetGC();
        }
        return config.getColorModel();
    }

    @Override
    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return this.getScreenInsets(((Win32GraphicsDevice)graphicsConfiguration.getDevice()).getScreen());
    }

    @Override
    public native int getScreenResolution();

    @Override
    protected native int getScreenWidth();

    @Override
    protected native int getScreenHeight();

    protected native Insets getScreenInsets(int var1);

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (FontManager.usePlatformFontMetrics()) {
            return WFontMetrics.getFontMetrics(font);
        }
        return super.getFontMetrics(font);
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        FontPeer fontPeer = null;
        String string2 = string.toLowerCase();
        if (null != this.cacheFontPeer && null != (fontPeer = (FontPeer)this.cacheFontPeer.get(string2 + n))) {
            return fontPeer;
        }
        fontPeer = new WFontPeer(string, n);
        if (fontPeer != null) {
            if (null == this.cacheFontPeer) {
                this.cacheFontPeer = new Hashtable(5, 0.9f);
            }
            if (null != this.cacheFontPeer) {
                this.cacheFontPeer.put(string2 + n, fontPeer);
            }
        }
        return fontPeer;
    }

    @Override
    public native void sync();

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public native void beep();

    @Override
    public boolean getLockingKeyState(int n) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n);
    }

    public native boolean getLockingKeyStateNative(int var1);

    @Override
    public void setLockingKeyState(int n, boolean bl) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        this.setLockingKeyStateNative(n, bl);
    }

    public native void setLockingKeyStateNative(int var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new WClipboard();
            }
        }
        return this.clipboard;
    }

    @Override
    protected native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        return new WInputMethodDescriptor();
    }

    public Map mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return WInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        Locale locale = WInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new WCustomCursor(image, point, string);
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) {
        return new Dimension(WCustomCursor.getCursorWidth(), WCustomCursor.getCursorHeight());
    }

    @Override
    public native int getMaximumCursorColors();

    static void paletteChanged() {
        ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).paletteChanged();
    }

    public static void displayChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).displayChanged();
            }
        });
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return WDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return (T)new WMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException("cannot load system cursor: " + string2);
            }
        }
        if (WDesktopProperties.isWindowsProperty(string) || string.startsWith(awtPrefix) || string.startsWith(dndPrefix)) {
            WToolkit wToolkit = this;
            synchronized (wToolkit) {
                if (this.wprops == null) {
                    this.wprops = new WDesktopProperties(this);
                } else if (string.equals("awt.dynamicLayoutSupported")) {
                    return this.lazilyLoadDynamicLayoutSupportedProperty(string);
                }
                Object object = this.wprops.getProperty(string);
                return object;
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected Boolean lazilyLoadDynamicLayoutSupportedProperty(String string) {
        boolean bl = this.isDynamicLayoutSupportedNative();
        Boolean bl2 = (Boolean)this.wprops.getProperty(string);
        if (bl2 == null || bl != bl2) {
            this.windowsSettingChange();
            return new Boolean(bl);
        }
        return bl2;
    }

    private void windowsSettingChange() {
        if (this.wprops != null) {
            this.wprops.firePropertyChanges();
        }
    }

    synchronized void clearDesktopProperty(String string) {
        this.desktopProperties.remove(string);
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (WDesktopProperties.isWindowsProperty(string)) {
            if (this.wprops == null) {
                this.wprops = new WDesktopProperties(this);
            }
            this.wprops.addPropertyChangeListener(string, propertyChangeListener);
        } else {
            super.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (WDesktopProperties.isWindowsProperty(string)) {
            if (this.wprops != null) {
                this.wprops.removePropertyChangeListener(string, propertyChangeListener);
            }
        } else {
            super.removePropertyChangeListener(string, propertyChangeListener);
        }
    }

    @Override
    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.wprops = new WDesktopProperties(this);
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", this.wprops.getProperty("win.drag.x"));
        try {
            this.desktopProperties.put("Shell.shellFolderManager", Class.forName("sun.awt.shell.Win32ShellFolderManager2"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static WToolkit getWToolkit() {
        WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
        return wToolkit;
    }

    public native void pushModality();

    public native void popModality();

    @Override
    protected boolean isModalExcludedSupportedImpl() {
        return true;
    }

    @Override
    protected void setModalExcludedImpl(Window window) {
        ComponentPeer componentPeer = window.getPeer();
        if (componentPeer != null && componentPeer instanceof WWindowPeer) {
            ((WWindowPeer)componentPeer).setModalExcluded();
        }
    }

    public void addModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.add(modalityListener);
    }

    public void removeModalityListener(ModalityListener modalityListener) {
        this.modalityListeners.remove(modalityListener);
    }

    final void notifyModalityChange(int n, Dialog dialog) {
        ModalityEvent modalityEvent = new ModalityEvent(this, this.modalityListeners, n, dialog);
        modalityEvent.dispatch();
    }

    static {
        loaded = false;
        WToolkit.loadLibraries();
        Win32GraphicsEnvironment.init();
        WToolkit.initIDs();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("browser");
                if (string != null && string.equals("sun.plugin")) {
                    WToolkit.disableCustomPalette();
                }
                return null;
            }
        });
    }

    class ModalityListenerList
    implements ModalityListener {
        Vector listeners = new Vector();

        ModalityListenerList() {
        }

        void add(ModalityListener modalityListener) {
            this.listeners.addElement(modalityListener);
        }

        void remove(ModalityListener modalityListener) {
            this.listeners.removeElement(modalityListener);
        }

        public void modalityPushed(ModalityEvent modalityEvent) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ModalityListener)enumeration.nextElement()).modalityPushed(modalityEvent);
            }
        }

        public void modalityPopped(ModalityEvent modalityEvent) {
            Enumeration enumeration = this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ModalityListener)enumeration.nextElement()).modalityPopped(modalityEvent);
            }
        }
    }
}

