/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JMXConnectorServer
extends NotificationBroadcasterSupport
implements JMXConnectorServerMBean,
MBeanRegistration {
    public static final String AUTHENTICATOR = "jmx.remote.authenticator";
    private MBeanServer mbeanServer = null;
    private ObjectName myName;
    private final int[] lock = new int[0];
    private List connectionIds = new ArrayList();
    private static final int[] sequenceNumberLock = new int[0];
    private static long sequenceNumber;

    public JMXConnectorServer() {
        this(null);
    }

    public JMXConnectorServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public synchronized void setMBeanServerForwarder(MBeanServerForwarder mBeanServerForwarder) {
        if (mBeanServerForwarder == null) {
            throw new IllegalArgumentException("Invalid null argument: mbsf");
        }
        if (this.mbeanServer != null) {
            mBeanServerForwarder.setMBeanServer(this.mbeanServer);
        }
        this.mbeanServer = mBeanServerForwarder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionIds() {
        List list = this.connectionIds;
        synchronized (list) {
            return this.connectionIds.toArray(new String[this.connectionIds.size()]);
        }
    }

    @Override
    public JMXConnector toJMXConnector(Map<String, ?> map) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        JMXServiceURL jMXServiceURL = this.getAddress();
        return JMXConnectorFactory.newJMXConnector(jMXServiceURL, map);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed"};
        String string = JMXConnectionNotification.class.getName();
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, string, "A client connection has been opened or closed")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionOpened(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.add(string);
        }
        this.sendNotification("jmx.remote.connection.opened", string, string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(string);
        }
        this.sendNotification("jmx.remote.connection.closed", string, string2, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionFailed(String string, String string2, Object object) {
        if (string == null) {
            throw new NullPointerException("Illegal null argument");
        }
        List list = this.connectionIds;
        synchronized (list) {
            this.connectionIds.remove(string);
        }
        this.sendNotification("jmx.remote.connection.failed", string, string2, object);
    }

    private void sendNotification(String string, String string2, String string3, Object object) {
        JMXConnectionNotification jMXConnectionNotification = new JMXConnectionNotification(string, this.getNotificationSource(), string2, JMXConnectorServer.nextSequenceNumber(), string3, object);
        this.sendNotification(jMXConnectionNotification);
    }

    private synchronized Object getNotificationSource() {
        if (this.myName != null) {
            return this.myName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long nextSequenceNumber() {
        int[] nArray = sequenceNumberLock;
        synchronized (sequenceNumberLock) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sequenceNumber++;
        }
    }

    @Override
    public synchronized ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        if (mBeanServer == null || objectName == null) {
            throw new NullPointerException("Null MBeanServer or ObjectName");
        }
        if (this.mbeanServer == null) {
            this.mbeanServer = mBeanServer;
            this.myName = objectName;
        }
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public synchronized void preDeregister() throws Exception {
        if (this.myName != null && this.isActive()) {
            this.stop();
            this.myName = null;
        }
    }

    @Override
    public void postDeregister() {
        this.myName = null;
    }
}

