/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit {
    NANOSECONDS(0),
    MICROSECONDS(1),
    MILLISECONDS(2),
    SECONDS(3);

    private final int index;
    private static final int[] multipliers;
    private static final long[] overflows;

    private TimeUnit(int n2) {
        this.index = n2;
    }

    private static long doConvert(int n, long l) {
        if (n == 0) {
            return l;
        }
        if (n < 0) {
            return l / (long)multipliers[-n];
        }
        if (l > overflows[n]) {
            return Long.MAX_VALUE;
        }
        if (l < -overflows[n]) {
            return Long.MIN_VALUE;
        }
        return l * (long)multipliers[n];
    }

    public long convert(long l, TimeUnit timeUnit) {
        return TimeUnit.doConvert(timeUnit.index - this.index, l);
    }

    public long toNanos(long l) {
        return TimeUnit.doConvert(this.index, l);
    }

    public long toMicros(long l) {
        return TimeUnit.doConvert(this.index - TimeUnit.MICROSECONDS.index, l);
    }

    public long toMillis(long l) {
        return TimeUnit.doConvert(this.index - TimeUnit.MILLISECONDS.index, l);
    }

    public long toSeconds(long l) {
        return TimeUnit.doConvert(this.index - TimeUnit.SECONDS.index, l);
    }

    private int excessNanos(long l, long l2) {
        if (this == NANOSECONDS) {
            return (int)(l - l2 * 1000L * 1000L);
        }
        if (this == MICROSECONDS) {
            return (int)(l * 1000L - l2 * 1000L * 1000L);
        }
        return 0;
    }

    public void timedWait(Object object, long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            object.wait(l2, n);
        }
    }

    public void timedJoin(Thread thread, long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            thread.join(l2, n);
        }
    }

    public void sleep(long l) throws InterruptedException {
        if (l > 0L) {
            long l2 = this.toMillis(l);
            int n = this.excessNanos(l, l2);
            Thread.sleep(l2, n);
        }
    }

    static {
        multipliers = new int[]{1, 1000, 1000000, 1000000000};
        overflows = new long[]{0L, 9223372036854775L, 9223372036854L, 9223372036L};
    }
}

