/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.EntryPair;
import java.text.MergeCollation;
import java.text.ParseException;
import java.text.PatternEntry;
import java.text.RBCollationTables;
import java.util.Vector;
import sun.text.ComposedCharIter;
import sun.text.IntHashtable;
import sun.text.NormalizerImpl;
import sun.text.UCompactIntArray;

final class RBTableBuilder {
    static final int CHARINDEX = 0x70000000;
    private static final int IGNORABLEMASK = 65535;
    private static final int PRIMARYORDERINCREMENT = 65536;
    private static final int SECONDARYORDERINCREMENT = 256;
    private static final int TERTIARYORDERINCREMENT = 1;
    private static final int INITIALTABLESIZE = 20;
    private static final int MAXKEYSIZE = 5;
    private RBCollationTables.BuildAPI tables = null;
    private MergeCollation mPattern = null;
    private boolean isOverIgnore = false;
    private char[] keyBuf = new char[5];
    private IntHashtable contractFlags = new IntHashtable(100);
    private boolean frenchSec = false;
    private boolean seAsianSwapping = false;
    private UCompactIntArray mapping = null;
    private Vector contractTable = null;
    private Vector expandTable = null;
    private short maxSecOrder = 0;
    private short maxTerOrder = 0;

    public RBTableBuilder(RBCollationTables.BuildAPI buildAPI) {
        this.tables = buildAPI;
    }

    public void build(String string, int n) throws ParseException {
        boolean bl = true;
        int n2 = 0;
        if (string.length() == 0) {
            throw new ParseException("Build rules empty.", 0);
        }
        this.mapping = new UCompactIntArray(-1);
        string = NormalizerImpl.canonicalDecomposeWithSingleQuotation(string);
        this.mPattern = new MergeCollation(string);
        int n3 = 0;
        for (n2 = 0; n2 < this.mPattern.getCount(); ++n2) {
            char c;
            PatternEntry patternEntry = this.mPattern.getItemAt(n2);
            if (patternEntry == null) continue;
            String string2 = patternEntry.getChars();
            if (string2.length() > 1) {
                switch (string2.charAt(string2.length() - 1)) {
                    case '@': {
                        this.frenchSec = true;
                        string2 = string2.substring(0, string2.length() - 1);
                        break;
                    }
                    case '!': {
                        this.seAsianSwapping = true;
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                }
            }
            n3 = this.increment(patternEntry.getStrength(), n3);
            String string3 = patternEntry.getExtension();
            if (string3.length() != 0) {
                this.addExpandOrder(string2, string3, n3);
                continue;
            }
            if (string2.length() > 1) {
                c = string2.charAt(0);
                if (Character.isHighSurrogate(c) && string2.length() == 2) {
                    this.addOrder(Character.toCodePoint(c, string2.charAt(1)), n3);
                    continue;
                }
                this.addContractOrder(string2, n3);
                continue;
            }
            c = string2.charAt(0);
            this.addOrder(c, n3);
        }
        this.addComposedChars();
        this.commit();
        this.mapping.compact();
        this.tables.fillInTables(this.frenchSec, this.seAsianSwapping, this.mapping, this.contractTable, this.expandTable, this.contractFlags, this.maxSecOrder, this.maxTerOrder);
    }

    private void addComposedChars() throws ParseException {
        int n;
        ComposedCharIter composedCharIter = new ComposedCharIter();
        while ((n = composedCharIter.next()) != -1) {
            int n2;
            int n3;
            if (this.getCharOrder(n) != -1) continue;
            String string = composedCharIter.decomposition();
            if (string.length() == 1) {
                n3 = this.getCharOrder(string.charAt(0));
                if (n3 == -1) continue;
                this.addOrder(n, n3);
                continue;
            }
            if (string.length() == 2 && Character.isHighSurrogate((char)(n3 = (int)string.charAt(0)))) {
                n2 = this.getCharOrder(string.codePointAt(0));
                if (n2 == -1) continue;
                this.addOrder(n, n2);
                continue;
            }
            n3 = this.getContractOrder(string);
            if (n3 != -1) {
                this.addOrder(n, n3);
                continue;
            }
            n2 = 1;
            for (int i = 0; i < string.length(); ++i) {
                if (this.getCharOrder(string.charAt(i)) != -1) continue;
                n2 = 0;
                break;
            }
            if (n2 == 0) continue;
            this.addExpandOrder(n, string, -1);
        }
    }

    private final void commit() {
        if (this.expandTable != null) {
            for (int i = 0; i < this.expandTable.size(); ++i) {
                int[] nArray = (int[])this.expandTable.elementAt(i);
                for (int j = 0; j < nArray.length; ++j) {
                    int n = nArray[j];
                    if (n >= 0x7E000000 || n <= 0x70000000) continue;
                    int n2 = n - 0x70000000;
                    int n3 = this.getCharOrder(n2);
                    nArray[j] = n3 == -1 ? 0xFFFF & n2 : n3;
                }
            }
        }
    }

    private final int increment(int n, int n2) {
        switch (n) {
            case 0: {
                n2 += 65536;
                n2 &= 0xFFFF0000;
                this.isOverIgnore = true;
                break;
            }
            case 1: {
                n2 += 256;
                n2 &= 0xFFFFFF00;
                if (this.isOverIgnore) break;
                this.maxSecOrder = (short)(this.maxSecOrder + 1);
                break;
            }
            case 2: {
                ++n2;
                if (this.isOverIgnore) break;
                this.maxTerOrder = (short)(this.maxTerOrder + 1);
            }
        }
        return n2;
    }

    private final void addOrder(int n, int n2) {
        int n3 = this.mapping.elementAt(n);
        if (n3 >= 0x7F000000) {
            int n4 = 1;
            if (Character.isSupplementaryCodePoint(n)) {
                n4 = Character.toChars(n, this.keyBuf, 0);
            } else {
                this.keyBuf[0] = (char)n;
            }
            this.addContractOrder(new String(this.keyBuf, 0, n4), n2);
        } else {
            this.mapping.setElementAt(n, n2);
        }
    }

    private final void addContractOrder(String string, int n) {
        this.addContractOrder(string, n, true);
    }

    private final void addContractOrder(String string, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        Vector<EntryPair> vector;
        if (this.contractTable == null) {
            this.contractTable = new Vector(20);
        }
        if ((vector = this.getContractValuesImpl((n4 = this.mapping.elementAt(n3 = string.codePointAt(0))) - 0x7F000000)) == null) {
            n2 = 0x7F000000 + this.contractTable.size();
            vector = new Vector<EntryPair>(20);
            this.contractTable.addElement(vector);
            vector.addElement(new EntryPair(string.substring(0, Character.charCount(n3)), n4));
            this.mapping.setElementAt(n3, n2);
        }
        if ((n2 = RBCollationTables.getEntry(vector, string, bl)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n2);
            entryPair.value = n;
        } else {
            EntryPair entryPair = (EntryPair)vector.lastElement();
            if (string.length() > entryPair.entryName.length()) {
                vector.addElement(new EntryPair(string, n, bl));
            } else {
                vector.insertElementAt(new EntryPair(string, n, bl), vector.size() - 1);
            }
        }
        if (bl && string.length() > 1) {
            this.addContractFlags(string);
            this.addContractOrder(new StringBuffer(string).reverse().toString(), n, false);
        }
    }

    private int getContractOrder(String string) {
        int n;
        int n2;
        Vector vector;
        int n3 = -1;
        if (this.contractTable != null && (vector = this.getContractValues(n2 = string.codePointAt(0))) != null && (n = RBCollationTables.getEntry(vector, string, true)) != -1) {
            EntryPair entryPair = (EntryPair)vector.elementAt(n);
            n3 = entryPair.value;
        }
        return n3;
    }

    private final int getCharOrder(int n) {
        int n2 = this.mapping.elementAt(n);
        if (n2 >= 0x7F000000) {
            Vector vector = this.getContractValuesImpl(n2 - 0x7F000000);
            EntryPair entryPair = (EntryPair)vector.firstElement();
            n2 = entryPair.value;
        }
        return n2;
    }

    private Vector getContractValues(int n) {
        int n2 = this.mapping.elementAt(n);
        return this.getContractValuesImpl(n2 - 0x7F000000);
    }

    private Vector getContractValuesImpl(int n) {
        if (n >= 0) {
            return (Vector)this.contractTable.elementAt(n);
        }
        return null;
    }

    private final void addExpandOrder(String string, String string2, int n) throws ParseException {
        int n2 = this.addExpansion(n, string2);
        if (string.length() > 1) {
            char c = string.charAt(0);
            if (Character.isHighSurrogate(c) && string.length() == 2) {
                char c2 = string.charAt(1);
                if (Character.isLowSurrogate(c2)) {
                    this.addOrder(Character.toCodePoint(c, c2), n2);
                }
            } else {
                this.addContractOrder(string, n2);
            }
        } else {
            this.addOrder(string.charAt(0), n2);
        }
    }

    private final void addExpandOrder(int n, String string, int n2) throws ParseException {
        int n3 = this.addExpansion(n2, string);
        this.addOrder(n, n3);
    }

    private int addExpansion(int n, String string) {
        if (this.expandTable == null) {
            this.expandTable = new Vector(20);
        }
        int n2 = n == -1 ? 0 : 1;
        int[] nArray = new int[string.length() + n2];
        if (n2 == 1) {
            nArray[0] = n;
        }
        int n3 = n2;
        for (int i = 0; i < string.length(); ++i) {
            int n4;
            int n5 = string.charAt(i);
            if (Character.isHighSurrogate((char)n5)) {
                char c;
                if (++i == string.length() || !Character.isLowSurrogate(c = string.charAt(i))) break;
                n4 = Character.toCodePoint((char)n5, c);
            } else {
                n4 = n5;
            }
            int n6 = this.getCharOrder(n4);
            nArray[n3++] = n6 != -1 ? n6 : 0x70000000 + n4;
        }
        if (n3 < nArray.length) {
            int[] nArray2 = new int[n3];
            while (--n3 >= 0) {
                nArray2[n3] = nArray[n3];
            }
            nArray = nArray2;
        }
        int n7 = 0x7E000000 + this.expandTable.size();
        this.expandTable.addElement(nArray);
        return n7;
    }

    private void addContractFlags(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            int n2 = string.charAt(i);
            int n3 = Character.isHighSurrogate((char)n2) ? Character.toCodePoint((char)n2, string.charAt(++i)) : n2;
            this.contractFlags.put(n3, 1);
        }
    }
}

