
PROCEDURE <API NAME WF>(itemtype in VARCHAR2,
                      itemkey in VARCHAR2,
                      actid in NUMBER,
                      funcmode in VARCHAR2,
                      resultout out VARCHAR2) 
IS
  case_table              VARCHAR2(62);
<WF ADDITIONAL TABLES DECLARATION>
  model_name              VARCHAR2(25);
  test_metric_name        VARCHAR2(30);
  residual_plot_data_name VARCHAR2(30);
  feature_table_name      VARCHAR2(30);
  mapping_table_name      VARCHAR2(30);
  drop_output             VARCHAR2(1);
  isDropOutput            BOOLEAN := FALSE;
BEGIN
  IF (funcmode = 'RUN') THEN
    case_table := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'CASE_TABLE');
<WF RETRIEVE ADDITIONAL TABLES>
    model_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'MODEL_NAME');
    test_metric_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'TEST_METRIC_NAME');
    residual_plot_data_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'RESIDUAL_PLOT_DATA_NAME');
    feature_table_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'FEATURE_TABLE_NAME');
    mapping_table_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'MAPPING_TABLE_NAME');
    drop_output := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'DROP_OUTPUT');
    IF (drop_output = 'Y' OR drop_output = 'y') THEN
      isDropOutput := TRUE;
    END IF;
    BEGIN
      <API NAME>(case_table,
                <additional_table_array>,
                model_name,
                test_metric_name,
                residual_plot_data_name,
                feature_table_name,
                mapping_table_name,
                isDropOutput);
      resultout :='COMPLETE:T';
    EXCEPTION WHEN OTHERS THEN
      resultout :='COMPLETE:F';
    END;
    RETURN;
  END IF;

  IF (funcmode = 'CANCEL') THEN
    resultout :='COMPLETE:';
    RETURN;
  END IF;
  
  EXCEPTION
  WHEN others THEN
    wf_core.context('<PACKAGE NAME>', '<API NAME WF>', itemtype, itemkey, actid, funcmode);
    RAISE;
END;
