
PROCEDURE <API NAME>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        <additional_table_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        test_metric_name IN VARCHAR2 DEFAULT <test_metric_name default>,
                        residual_plot_data_name IN VARCHAR2 DEFAULT <residual_plot_data_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        mapping_table IN VARCHAR2 DEFAULT <mapping_table_name default>,
                        drop_output IN BOOLEAN DEFAULT <drop_output default>)
IS
  additional_data  TABLE_ARRAY := TABLE_ARRAY(
    <additional_table_array>
  );
  v_tempTables              TABLE_ARRAY := TABLE_ARRAY();
  v_2d_view                 VARCHAR2(30);
  v_2d_view_build           VARCHAR2(30);
  v_2d_view_test            VARCHAR2(30);
  v_2d_temp_view            VARCHAR2(30);
  v_txn_views               TABLE_ARRAY := TABLE_ARRAY();
  v_txn_views_build         TABLE_ARRAY := TABLE_ARRAY();
  v_txn_views_test          TABLE_ARRAY := TABLE_ARRAY();
  v_txn_temp_views          TABLE_ARRAY := TABLE_ARRAY();
  v_input_view              VARCHAR2(30);
  v_case_data               SQL_STATEMENT_TYPE := case_table;
  v_case_id                 VARCHAR2(30) := '<CASEID>';
  v_tmp_lstmt               LSTMT_REC_TYPE;
  v_build_data              VARCHAR2(30);
  v_test_data               VARCHAR2(30);
  v_build_setting           VARCHAR2(30);
  v_test_result             VARCHAR2(30);
  v_plot_result             VARCHAR2(30);
  v_diagnostics_table       VARCHAR2(30);
  v_rms_error               NUMBER;
  v_absolute_error          NUMBER;
  v_mean_actual             NUMBER;
  v_mean_predicted          NUMBER;
  v_error_of_naive_model    NUMBER;
  v_predictive_confidence   NUMBER;
  v_gen_caseId              BOOLEAN := <generate caseid default>;
  v_txt_build               VARCHAR2(30);
  v_txt_test                VARCHAR2(30);
  v_content_index           VARCHAR2(30);
  v_content_index_pref      VARCHAR2(30);
  v_category_temp_table     VARCHAR2(30);
  v_term_final_table        VARCHAR2(30);
  v_term_final_table_index  VARCHAR2(30);
  v_mapping_table_index     VARCHAR2(30);
  v_term_final_table_test   VARCHAR2(30);
  pragma autonomous_transaction;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  CHECK_MODEL(drop_output, model_name);
  CHECK_RESULTS(drop_output, feature_table);
  CHECK_RESULTS(drop_output, mapping_table);
  CHECK_RESULTS(drop_output, test_metric_name);
  CHECK_RESULTS(drop_output, residual_plot_data_name);

  IF (v_gen_caseId) THEN
    v_case_data := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    EXECUTE IMMEDIATE 'CREATE TABLE '||v_case_data||' as SELECT rownum as <CASEID>, t.* FROM ('||case_table||') t ';
    EXECUTE IMMEDIATE 'ALTER TABLE '||v_case_data||' add constraint '||create_new_temp_table_name('PK')||' primary key (<CASEID>)';
  END IF;
  
<INPUT DATA PREPARATION>

  v_input_view := v_2d_view;

<DATA TRANSFORMATIONS>
  
<MINING DATA PREPARATION>

<BUILD SETTING>

  -- BUILD MODEL
  DBMS_DATA_MINING.CREATE_MODEL(
    model_name          => model_name,
    mining_function     => dbms_data_mining.regression,
    data_table_name     => v_build_data,
    case_id_column_name => v_case_id,
    target_column_name  => '<target default>',
    settings_table_name => v_build_setting);

  -- TEST MODEL
  IF test_metric_name IS NOT NULL THEN
    EXECUTE IMMEDIATE 'CREATE TABLE ' || test_metric_name || ' (METRIC_NAME VARCHAR2(30), METRIC_VARCHAR_VALUE VARCHAR2(31), METRIC_NUM_VALUE NUMBER)';
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', :model)' USING model_name;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''TEST_DATA_NAME'', :test_data)' USING v_test_data;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', ''REGRESSION'')';

    v_test_result := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    EXECUTE IMMEDIATE 'CREATE TABLE ' || v_test_result || ' as SELECT <CASEID>, ((PREDICTION(' || model_name || ' USING *) * <XNORM_SCALE>) + <XNORM_SHIFT>) pred, (PREDICTION(' || model_name || ' USING *)) pred_norm FROM ' || v_test_data;

    -- 1. Root Mean Square Error - Sqrt(Mean((x - x')^2))
    EXECUTE IMMEDIATE '
    SELECT SQRT(AVG(POWER((A.pred - (B.<target default> * <XNORM_SCALE> + <XNORM_SHIFT>)), 2))) rmse
      FROM ' || v_test_result || ' A,
           ' || v_test_data || ' B
     WHERE A.<CASEID> = B.<CASEID>' INTO v_rms_error;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_RMS_ERROR'', :rms_error)' USING v_rms_error;
    COMMIT;

    EXECUTE IMMEDIATE '
    SELECT SQRT(AVG(POWER((A.pred_norm - B.<target default>), 2))) rmse
      FROM ' || v_test_result || ' A,
           ' || v_test_data || ' B
     WHERE A.<CASEID> = B.<CASEID>' INTO v_rms_error;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_RMS_ERROR_NORM'', :rms_error)' USING v_rms_error;
    COMMIT;
    
    -- 2. Mean Absolute Error - Mean(|(x - x')|)
    EXECUTE IMMEDIATE '
    SELECT AVG(ABS(A.pred - B.<target default> * <XNORM_SCALE> + <XNORM_SHIFT>)) mae 
      FROM ' || v_test_result || ' A,
           ' || v_test_data || ' B
      WHERE A.<CASEID> = B.<CASEID>' INTO v_absolute_error;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ABSOLUTE_ERROR'', :absolute_error)' USING v_absolute_error;
    COMMIT;
    
    EXECUTE IMMEDIATE '
    SELECT AVG(ABS(A.pred_norm - B.<target default>)) mae 
      FROM ' || v_test_result || ' A,
           ' || v_test_data || ' B
      WHERE A.<CASEID> = B.<CASEID>' INTO v_absolute_error;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ABSOLUTE_ERROR_NORM'', :absolute_error)' USING v_absolute_error;
    COMMIT;
    
    -- 3. Mean Actual Value
    EXECUTE IMMEDIATE '
    SELECT
      AVG(<target default> * <XNORM_SCALE> + <XNORM_SHIFT>) as mean_actual_value 
    from ' || v_test_data || ' ' INTO v_mean_actual;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ACTUAL_VALUE'', :mean_actual)' USING v_mean_actual;
    COMMIT;

    EXECUTE IMMEDIATE '
    SELECT
      AVG(<target default>) as mean_actual_value 
    from ' || v_test_data || ' ' INTO v_mean_actual;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_ACTUAL_VALUE_NORM'', :mean_actual)' USING v_mean_actual;
    COMMIT;

    -- 4. Mean Predicted Value
    EXECUTE IMMEDIATE '
    SELECT
      AVG(PREDICTION(' || model_name || ' using *) * <XNORM_SCALE> + <XNORM_SHIFT>) as mean_predicted_value 
    from ' || v_test_data || ' ' INTO v_mean_predicted;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_PREDICATED_VALUE'', :mean_predicted)' USING v_mean_predicted;
    COMMIT;
    
    EXECUTE IMMEDIATE '
    SELECT
      AVG(PREDICTION(' || model_name || ' using *)) as mean_predicted_value 
    from ' || v_test_data || ' ' INTO v_mean_predicted;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''MEAN_PREDICATED_VALUE_NORM'', :mean_predicted)' USING v_mean_predicted;
    COMMIT;
        
    -- Overall predictive Confidence = 1 - ((Error of Predict)/(Error of naive model))
    EXECUTE IMMEDIATE '
    WITH
    a as 
    (SELECT SQRT(AVG(POWER((A.pred - (B.<target default> * <XNORM_SCALE> + <XNORM_SHIFT>)), 2))) rmse
      FROM ' || v_test_result || ' A,
           ' || v_test_data || ' B
     WHERE A.DMR$CASE_ID = B.DMR$CASE_ID)
    ,
    b as 
    (SELECT SQRT(count(*)/(count(*)-1) * variance(<target default> * <XNORM_SCALE> + <XNORM_SHIFT>)) ne 
      FROM ' || v_test_data || ')
    SELECT (1 - a.rmse / b.ne) * 100 FROM a, b' INTO v_predictive_confidence;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''PREDICTIVE_CONFIDENCE'', :predictive_confidence)' USING v_predictive_confidence;
    COMMIT;    
  END IF;

  -- RESIDUAL PLOT DATA
  IF residual_plot_data_name IS NOT NULL THEN
    -- Residuals
    --    If the residuals show substantial variance between
    --    the predicted value and the actual, you can consider
    --    changing the algorithm parameters.
    --
    EXECUTE IMMEDIATE 'CREATE TABLE ' || residual_plot_data_name || ' AS
      SELECT *
        FROM (SELECT A.<CASEID>, 
              (B.<target default>) "<non-quote target default>_NORM", 
              A.pred_norm PREDICTION_NORM, 
              (A.pred_norm - B.<target default>) RESIDUAL_NORM,
              (B.<target default> * <XNORM_SCALE> + <XNORM_SHIFT>) <target default>, 
              A.pred PREDICTION,
              (A.pred - (B.<target default> * <XNORM_SCALE> + <XNORM_SHIFT>)) RESIDUAL
                FROM ' || v_test_result || ' A,
                     ' || v_test_data || ' B
               WHERE A.<CASEID> = B.<CASEID>
              ORDER BY A.pred ASC)';
  END IF;

  DROP_TEMP_TABLES(v_tempTables);
  
EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  RAISE; 
END;
