
PROCEDURE <API NAME>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        <additional_table_params>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        confusion_matrix_name IN VARCHAR2 DEFAULT <confusion_matrix_name default>,
                        lift_result_name IN VARCHAR2 DEFAULT <lift_result_name default>,
                        roc_result_name IN VARCHAR2 DEFAULT <roc_result_name default>,
                        test_metric_name IN VARCHAR2 DEFAULT <test_metric_name default>,
                        feature_table IN VARCHAR2 DEFAULT <feature_table_name default>,
                        mapping_table IN VARCHAR2 DEFAULT <mapping_table_name default>,
                        drop_output IN BOOLEAN DEFAULT <drop_output default>)
IS
  additional_data  TABLE_ARRAY := TABLE_ARRAY(
    <additional_table_array>
  );
  v_tempTables              TABLE_ARRAY := TABLE_ARRAY();
  v_2d_view                 VARCHAR2(30);
  v_2d_view_build           VARCHAR2(30);
  v_2d_view_test            VARCHAR2(30);
  v_2d_temp_view            VARCHAR2(30);
  v_txn_views               TABLE_ARRAY := TABLE_ARRAY();
  v_txn_views_build         TABLE_ARRAY := TABLE_ARRAY();
  v_txn_views_test          TABLE_ARRAY := TABLE_ARRAY();
  v_txn_temp_views          TABLE_ARRAY := TABLE_ARRAY();
  v_case_data               SQL_STATEMENT_TYPE := case_table;
  v_case_id                 VARCHAR2(30) := '<CASEID>';
  v_tmp_lstmt               LSTMT_REC_TYPE;
  v_target_value            VARCHAR2(4000) := <positive target value default>;
  v_num_quantiles           NUMBER := <num_quantiles default>;
  v_build_data              VARCHAR2(30);
  v_test_data               VARCHAR2(30);
  v_prior                   VARCHAR2(30);
  v_build_setting           VARCHAR2(30);
  v_apply_result            VARCHAR2(30);
  v_build_cm                VARCHAR2(30);
  v_test_cm                 VARCHAR2(30);
  v_diagnostics_table       VARCHAR2(30);
  v_accuracy                NUMBER;
  v_area_under_curve        NUMBER;
  v_avg_accuracy            NUMBER;
  v_predictive_confidence   NUMBER;
  v_confusion_matrix        VARCHAR2(30);
  v_gen_caseId              BOOLEAN := <generate caseid default>;
  v_txt_build               VARCHAR2(30);
  v_txt_test                VARCHAR2(30);
  v_content_index           VARCHAR2(30);
  v_content_index_pref      VARCHAR2(30);
  v_category_temp_table     VARCHAR2(30);
  v_term_final_table        VARCHAR2(30);
  v_term_final_table_index  VARCHAR2(30);
  v_mapping_table_index     VARCHAR2(30);
  v_term_final_table_test   VARCHAR2(30);
  pragma autonomous_transaction;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  CHECK_MODEL(drop_output, model_name);
  CHECK_RESULTS(drop_output, feature_table);
  CHECK_RESULTS(drop_output, mapping_table);
  CHECK_RESULTS(drop_output, test_metric_name);
  CHECK_RESULTS(drop_output, confusion_matrix_name);
  CHECK_RESULTS(drop_output, lift_result_name);
  CHECK_RESULTS(drop_output, roc_result_name);

  IF (v_gen_caseId) THEN
    v_case_data := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    EXECUTE IMMEDIATE 'CREATE TABLE '||v_case_data||' as SELECT rownum as <CASEID>, t.* FROM ('||case_table||') t ';
    EXECUTE IMMEDIATE 'ALTER TABLE '||v_case_data||' add constraint '||create_new_temp_table_name('PK')||' primary key (<CASEID>)';
  END IF;
  
<INPUT DATA PREPARATION>

<DATA TRANSFORMATIONS>
  
<MINING DATA PREPARATION>

<PRIOR SETTING>

<BUILD COST MATRIX SETTING>

<BUILD SETTING>

  -- BUILD MODEL
  DBMS_DATA_MINING.CREATE_MODEL(
    model_name          => model_name,
    mining_function     => dbms_data_mining.classification,
    data_table_name     => v_build_data,
    case_id_column_name => v_case_id,
    target_column_name  => '<target default>',
    settings_table_name => v_build_setting);

<TEST COST MATRIX SETTING>

  -- TEST MODEL
  IF (test_metric_name IS NOT NULL) THEN
    -- CREATE APPLY RESULT FOR TEST
    v_apply_result := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    
    DBMS_DATA_MINING.APPLY(
      model_name          => model_name,
      data_table_name     => v_test_data,
      case_id_column_name => v_case_id,
      result_table_name   => v_apply_result);

    EXECUTE IMMEDIATE 'CREATE TABLE ' || test_metric_name || ' (METRIC_NAME VARCHAR2(30), METRIC_VARCHAR_VALUE VARCHAR2(31), METRIC_NUM_VALUE NUMBER)';
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MODEL_NAME'', :model)' USING model_name;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''TEST_DATA_NAME'', :test_data)' USING v_test_data;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''MINING_FUNCTION'', ''CLASSIFICATION'')';
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''TARGET_ATTRIBUTE'', :target)' USING '<target default>';
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''POSITIVE_TARGET_VALUE'', :target_value)' USING v_target_value;
    COMMIT;
  
    IF confusion_matrix_name IS NULL THEN
      v_confusion_matrix := ADD_TEMP_TABLE(v_tempTables, create_new_temp_table_name('DM$T'));
    ELSE
      v_confusion_matrix := confusion_matrix_name;
    END IF;

    DBMS_DATA_MINING.COMPUTE_CONFUSION_MATRIX (
      accuracy                    => v_accuracy,
      apply_result_table_name     => v_apply_result,
      target_table_name           => v_test_data,
      case_id_column_name         => v_case_id,
      target_column_name          => '<target default>',
      confusion_matrix_table_name => v_confusion_matrix,
      score_column_name           => 'PREDICTION',
      score_criterion_column_name => 'PROBABILITY',
      cost_matrix_table_name      => v_test_cm,
      apply_result_schema_name    => null,
      target_schema_name          => null,
      cost_matrix_schema_name     => null
      <USE SCORE CRITERION TYPE>
      );  
    -- DBMS_OUTPUT.PUT_LINE('**** MODEL ACCURACY ****: ' || ROUND(accuracy, 4));

    IF (confusion_matrix_name IS NOT NULL) THEN
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''ACCURACY'', :accuracy)' USING v_accuracy;
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''CONFUSION_MATRIX_TABLE'', :confusion_matrix_name)' USING confusion_matrix_name;
      COMMIT;

      -- Average Accuracy
      EXECUTE IMMEDIATE '
        WITH
        a as 
          (SELECT a.actual_target_value, sum(a.value) recall_total 
             FROM ' || confusion_matrix_name || ' a 
             group by a.actual_target_value)
          ,
        b as
          (SELECT count(distinct b.actual_target_value) num_recalls
             FROM ' || confusion_matrix_name || ' b)
          ,
        c as 
          (SELECT c.actual_target_value, value 
             FROM ' || confusion_matrix_name || ' c
             where actual_target_value = predicted_target_value)
          ,
        d as 
          (SELECT sum(c.value/a.recall_total) tot_accuracy
             FROM a, c
             where a.actual_target_value = c.actual_target_value)
        SELECT d.tot_accuracy/b.num_recalls * 100 avg_accuracy
        FROM b, d' INTO v_avg_accuracy;
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''AVG_ACCURACY'', :avg_accuracy)' USING v_avg_accuracy;
      COMMIT;
    END IF;
    
    -- Predictive Confidence
    EXECUTE IMMEDIATE '
      WITH
      a as 
        (SELECT a.actual_target_value, sum(a.value) recall_total 
           FROM ' || v_confusion_matrix || ' a 
           group by a.actual_target_value)
        ,
      b as
        (SELECT count(distinct b.actual_target_value) num_classes
           FROM ' || v_confusion_matrix || ' b)
        ,
      c as 
        (SELECT c.actual_target_value, value 
           FROM ' || v_confusion_matrix || ' c
           where actual_target_value = predicted_target_value)
        ,
      d as 
        (SELECT sum(c.value/a.recall_total) tot_accuracy
           FROM a, c
           where a.actual_target_value = c.actual_target_value)
      SELECT (1 - (1 - d.tot_accuracy/b.num_classes) / GREATEST(0.0001, ((b.num_classes-1)/b.num_classes))) * 100
      FROM b, d' INTO v_predictive_confidence;
    EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''PREDICTIVE_CONFIDENCE'', :predictive_confidence)' USING v_predictive_confidence;
    COMMIT;
    
    IF lift_result_name IS NOT NULL AND v_target_value IS NOT NULL THEN
      DBMS_DATA_MINING.COMPUTE_LIFT (
        apply_result_table_name   => v_apply_result,
        target_table_name         => v_test_data,
        case_id_column_name       => v_case_id,
        target_column_name        => '<target default>',
        lift_table_name           => lift_result_name,
        positive_target_value     => v_target_value,
        num_quantiles             => v_num_quantiles,
        cost_matrix_table_name    => v_test_cm,
        apply_result_schema_name  => null,
        target_schema_name        => null,
        cost_matrix_schema_name   => null
        <USE SCORE CRITERION TYPE>
        );  
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''LIFT_TABLE'', :lift_result_name)' USING lift_result_name;
      COMMIT;
    END IF;
    
    IF roc_result_name IS NOT NULL AND v_target_value IS NOT NULL THEN
      DBMS_DATA_MINING.COMPUTE_ROC (
        roc_area_under_curve        => v_area_under_curve,
        apply_result_table_name     => v_apply_result,
        target_table_name           => v_test_data,
        case_id_column_name         => v_case_id,
        target_column_name          => '<target default>',
        roc_table_name              => roc_result_name,
        positive_target_value       => v_target_value,
        score_column_name           => 'PREDICTION',
        score_criterion_column_name => 'PROBABILITY');
      -- DBMS_OUTPUT.PUT_LINE('**** AREA UNDER ROC CURVE ****: ' || area_under_curve );
  
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_VARCHAR_VALUE) VALUES (''ROC_TABLE'', :roc_result_name)' USING roc_result_name;
      EXECUTE IMMEDIATE 'INSERT INTO ' || test_metric_name || ' (METRIC_NAME, METRIC_NUM_VALUE) VALUES (''AREA_UNDER_CURVE'', :v_area_under_curve)' USING v_area_under_curve;
      COMMIT;
    END IF;
  END IF;

  DROP_TEMP_TABLES(v_tempTables);
  
EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  RAISE; 
END;
