
PROCEDURE <API NAME WF>(itemtype in VARCHAR2,
                      itemkey in VARCHAR2,
                      actid in NUMBER,
                      funcmode in VARCHAR2,
                      resultout out VARCHAR2) 
IS
  trans_table   VARCHAR2(62);
  model_name    VARCHAR2(25);
  drop_model    VARCHAR2(1);
  isDropModel   BOOLEAN := FALSE;
BEGIN
  IF (funcmode = 'RUN') THEN
    trans_table := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'TRANSACTIONAL_TABLE');
    model_name := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'MODEL_NAME');
    drop_model := wf_engine.GetItemAttrText (
                                  itemtype => itemtype,
                                  itemkey => itemkey,
                                  aname => 'DROP_MODEL');
    IF (drop_model = 'Y' OR drop_model = 'y') THEN
      isDropModel := TRUE;
    END IF;
    BEGIN
      <API NAME>(trans_table,
                model_name,
                isDropModel);
      resultout :='COMPLETE:T';
    EXCEPTION WHEN OTHERS THEN
      resultout :='COMPLETE:F';
    END;
    RETURN;
  END IF;

  IF (funcmode = 'CANCEL') THEN
    resultout :='COMPLETE:';
    RETURN;
  END IF;
  
  EXCEPTION
  WHEN others THEN
    wf_core.context('<PACKAGE NAME>', '<API NAME WF>', itemtype, itemkey, actid, funcmode);
    RAISE;
END;
