
PROCEDURE <API NAME>(case_table IN VARCHAR2 DEFAULT <case_table default>,
                        model_name IN VARCHAR2 DEFAULT <model_name default>,
                        drop_model IN BOOLEAN DEFAULT <drop_output default>)
IS
  v_tempTables      TABLE_ARRAY := TABLE_ARRAY();
  v_2d_view         VARCHAR2(30);
  v_2d_temp_view    VARCHAR2(30);
  v_txn_views       TABLE_ARRAY := TABLE_ARRAY();
  v_txn_temp_views  TABLE_ARRAY := TABLE_ARRAY();
  v_case_data       SQL_STATEMENT_TYPE := case_table;
  v_case_id         VARCHAR2(30) := '<CASEID>';
  v_tmp_lstmt       LSTMT_REC_TYPE;
  v_build_data      VARCHAR2(30);
  v_build_setting   VARCHAR2(30);
  pragma autonomous_transaction;
BEGIN
  execute immediate 'Alter session set NLS_NUMERIC_CHARACTERS=".,"';

  CHECK_MODEL(drop_model, model_name);
  
<INPUT DATA PREPARATION>

<DATA TRANSFORMATIONS>
  
<MINING DATA PREPARATION>
  
<BUILD SETTING>

  -- BUILD MODEL
  DBMS_DATA_MINING.CREATE_MODEL(
    model_name          => model_name,
    mining_function     => DBMS_DATA_MINING.ASSOCIATION,
    data_table_name     => v_build_data,
    case_id_column_name => v_case_id,
    settings_table_name => v_build_setting);

  DROP_TEMP_TABLES(v_tempTables);

EXCEPTION WHEN OTHERS THEN
  DROP_TEMP_TABLES(v_tempTables);
  RAISE; 
END;
