/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.icons.IdeIcons;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.LockFailedException;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.QueryFailedException;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdevimpl.library.LeafNode;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryListNode;
import oracle.jdevimpl.library.LibraryNode;
import oracle.jdevimpl.library.LibraryPanel;
import oracle.jdevimpl.library.ListNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreePanel
extends LibraryPanel {
    private static final String NEW_CMD = "New";
    private static final String ADD_CMD = "Add";
    private static final String REMOVE_CMD = "Remove";
    private static URL defDir = URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
    private CardLayout cardLayout1;
    private JSplitPane splitPane;
    private JScrollPane libsTreeScroller;
    private JPanel masterPanel;
    private JComponent detailPanel;
    private JLabel libsLabel;
    private JTree libsTree;
    private JPanel buttonPanel;
    private GridLayout buttonLayout;
    private JButton newButton;
    private JButton addButton;
    private JButton removeButton;
    private SearchField searchField;
    private GridBagLayout gridBagLayout1;
    private DefaultTreeModel libsModel;
    private DefaultTreeCellRenderer libsTreeRenderer;
    private SelectionManager selMgr;
    private boolean isSplit;
    private SearchHelper m_searchHelper;
    private LibraryJAR2TreeNodeCache m_libsJAR2TreeNode;
    private URLPath m_allJARsURLPath;

    private void $init$() {
        this.cardLayout1 = new CardLayout();
        this.splitPane = new JSplitPane();
        this.libsTreeScroller = new JScrollPane();
        this.masterPanel = new JPanel();
        this.libsLabel = new JLabel();
        this.libsTree = new JTree();
        this.buttonPanel = new JPanel();
        this.buttonLayout = new GridLayout();
        this.newButton = new JButton();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.searchField = null;
        this.gridBagLayout1 = new GridBagLayout();
        this.libsTreeRenderer = new Renderer();
        this.selMgr = new SelectionManager(null);
        this.isSplit = true;
        this.m_searchHelper = null;
        this.m_libsJAR2TreeNode = null;
        this.m_allJARsURLPath = null;
    }

    public TreePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout1);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.addTreeSelectionListener(this.selMgr);
        this.setFocusable(false);
        this.masterPanel.setBorder(BorderFactory.createEmptyBorder());
        this.masterPanel.setLayout(this.gridBagLayout1);
        this.libsTree.getSelectionModel().setSelectionMode(1);
        this.libsTree.setRootVisible(false);
        this.libsTree.setShowsRootHandles(true);
        this.libsTree.setCellRenderer(this.libsTreeRenderer);
        this.libsTree.addKeyListener(this.selMgr);
        ToolTipManager.sharedInstance().registerComponent(this.libsTree);
        this.buttonPanel.setLayout(this.buttonLayout);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder());
        this.buttonLayout.setHgap(2);
        ResourceUtils.resLabel((JLabel)this.libsLabel, (Component)this.libsTree, (String)LibraryArb.getString(51));
        this.newButton.setActionCommand(NEW_CMD);
        this.newButton.setEnabled(false);
        this.newButton.addActionListener(this.selMgr);
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.setEnabled(true);
        this.addButton.addActionListener(this.selMgr);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this.selMgr);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.libsTreeScroller.setViewportView(this.libsTree);
        ResourceUtils.resButton((AbstractButton)this.newButton, (String)LibraryArb.getString(59));
        ResourceUtils.resButton((AbstractButton)this.addButton, (String)LibraryArb.getString(72));
        ResourceUtils.resButton((AbstractButton)this.removeButton, (String)LibraryArb.getString(20));
        this.buttonPanel.add((Component)this.newButton, null);
        this.buttonPanel.add((Component)this.addButton, null);
        this.buttonPanel.add((Component)this.removeButton, null);
        this.searchField = new SearchField();
        this.setupSearchField(this.searchField);
        this.masterPanel.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.masterPanel.add((Component)this.libsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(11, 0, 6, 0), 0, 0));
        this.masterPanel.add((Component)this.libsTreeScroller, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.masterPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.splitPane.add((Component)this.masterPanel, "left");
        this.add((Component)this.splitPane, "jSplitPane1");
        this.m_searchHelper = new SearchHelper();
    }

    private List<Library> extractLibraries(DefaultMutableTreeNode root) {
        ArrayList<Library> allChildrenUnderRoot = new ArrayList<Library>();
        int i = 0;
        while (i < root.getChildCount()) {
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)root.getChildAt(i);
            if (nextChild.getUserObject() instanceof Library) {
                allChildrenUnderRoot.add((Library)nextChild.getUserObject());
            }
            if (nextChild.getChildCount() > 0) {
                allChildrenUnderRoot.addAll(this.extractLibraries(nextChild));
            }
            ++i;
        }
        return allChildrenUnderRoot;
    }

    private List<DefaultMutableTreeNode> getLibraryTreeNodeSubset(DefaultMutableTreeNode root) {
        ArrayList<DefaultMutableTreeNode> allChildrenUnderRoot = new ArrayList<DefaultMutableTreeNode>();
        int i = 0;
        while (i < root.getChildCount()) {
            DefaultMutableTreeNode nextChild = (DefaultMutableTreeNode)root.getChildAt(i);
            if (nextChild.getUserObject() instanceof Library) {
                allChildrenUnderRoot.add(nextChild);
                this.m_libsJAR2TreeNode.register(nextChild, (Library)nextChild.getUserObject());
            }
            if (nextChild.getChildCount() > 0) {
                allChildrenUnderRoot.addAll(this.getLibraryTreeNodeSubset(nextChild));
            }
            ++i;
        }
        return allChildrenUnderRoot;
    }

    private Index getIndex(Project project, URLPath urlPath) {
        IndexManager indexManager = IndexManager.getIndexManager();
        return indexManager.getIndex(project, urlPath);
    }

    private void buildAllJARsURLPath() {
        this.m_libsJAR2TreeNode = new LibraryJAR2TreeNodeCache();
        this.m_allJARsURLPath = new URLPath();
        List<Library> allLibraries = this.extractLibraries((DefaultMutableTreeNode)this.libsModel.getRoot());
        for (Library library : allLibraries) {
            this.m_allJARsURLPath.add(library.getClassPath());
        }
    }

    private void setupSearchField(SearchField searchField) {
        int currentHeight = (int)searchField.getPreferredSize().getHeight();
        searchField.setMinimumSize(new Dimension(200, currentHeight));
        searchField.setStyle(SearchField.Style.SEARCH);
        searchField.setPrompt(LibraryArb.getString(69));
        searchField.getTextField().addCaretListener((CaretListener)new 1(this, searchField));
        searchField.addSearchListener((SearchListener)new 2());
    }

    public final boolean isSplit() {
        return this.isSplit;
    }

    public void setSplit(boolean split) {
        if (this.isSplit == split) {
            return;
        }
        this.isSplit = split;
        if (this.isSplit) {
            this.remove(this.masterPanel);
            this.splitPane.add((Component)this.masterPanel, "left");
            this.splitPane.add((Component)this.detailPanel, "right");
            this.add((Component)this.splitPane, "jSplitPane1");
            this.libsTree.getSelectionModel().setSelectionMode(1);
        } else {
            this.remove(this.splitPane);
            this.add((Component)this.masterPanel, "masterPanel");
            this.libsTree.getSelectionModel().setSelectionMode(4);
        }
    }

    public void setSelectionMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: 
            case 4: {
                this.libsTree.getSelectionModel().setSelectionMode(mode);
                break;
            }
        }
    }

    public final void initPanel(ListWrapper[] lists, Object selection) {
        TreePath path;
        this.initPanel(lists);
        TreeNode node = this.findNode(null, selection);
        if (node != null && (path = new TreePath(this.libsModel.getPathToRoot(node))) != null) {
            this.libsTree.setSelectionPath(path);
            this.libsTree.scrollPathToVisible(path);
        }
    }

    @Override
    public void initPanel(ListWrapper[] lists) {
        this.libsModel = this.createTreeModel(lists);
        this.libsTree.setModel(this.libsModel);
        this.m_searchHelper.setDefaultTreeModel(this.libsModel);
        int i = lists.length - 1;
        while (i >= 0) {
            this.libsTree.expandRow(i);
            --i;
        }
        TreeNode root = (TreeNode)this.libsModel.getRoot();
        int count = root.getChildCount();
        int i2 = 0;
        while (i2 < count) {
            TreeNode node = root.getChildAt(i2);
            if (node.getChildCount() > 0) {
                TreePath path = new TreePath(((DefaultMutableTreeNode)node.getChildAt(0)).getPath());
                this.libsTree.setSelectionPath(path);
                return;
            }
            ++i2;
        }
        if (count > 0) {
            this.libsTree.setSelectionRow(0);
        }
        this.libsTree.requestFocus();
    }

    @Override
    public final ListWrapper[] getLibraryLists() {
        TreeNode root = (TreeNode)this.libsModel.getRoot();
        ListWrapper[] result = new ListWrapper[root.getChildCount()];
        int i = 0;
        while (i < result.length) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            result[i] = (ListWrapper)child.getUserObject();
            ++i;
        }
        return result;
    }

    public final void addTreeSelectionListener(TreeSelectionListener l) {
        this.libsTree.addTreeSelectionListener(l);
    }

    public final void addMouseListenerToTree(MouseListener l) {
        this.libsTree.addMouseListener(l);
    }

    protected abstract DefaultTreeModel createTreeModel(ListWrapper[] var1);

    protected final DefaultTreeModel getTreeModel() {
        return this.libsModel;
    }

    @Override
    public boolean commitChanges() {
        return true;
    }

    public Library[] getSelection() {
        return SelectionManager.mav$_getElements(this.selMgr, SelectionManager.ra$selPaths(this.selMgr));
    }

    protected final void setLeafIcon(Icon icon) {
        this.libsTreeRenderer.setLeafIcon(icon);
    }

    protected final void setDetailPanel(JComponent detail, String newTitle) {
        this.detailPanel = detail;
        this.splitPane.add((Component)this.detailPanel, "right");
    }

    protected void selectNode(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        SwingUtilities.invokeLater(new 3(this, path));
    }

    protected TreeNode findNode(TreeNode root, Object userObject) {
        if (root == null) {
            root = (TreeNode)this.libsModel.getRoot();
        }
        return TreePanel._findMatch(root, userObject);
    }

    protected static TreeNode _findMatch(TreeNode node, Object userObject) {
        TreeNode result = null;
        Object candidate = ((DefaultMutableTreeNode)node).getUserObject();
        if (candidate != null && userObject != null && candidate.equals(userObject)) {
            result = node;
        } else if (node.getAllowsChildren()) {
            int count = node.getChildCount();
            int i = 0;
            while (i < count) {
                result = TreePanel._findMatch(node.getChildAt(i), userObject);
                if (result != null) break;
                ++i;
            }
        }
        return result;
    }

    private void _updateButtons(DefaultMutableTreeNode[] sel) {
        boolean allowNew = true;
        boolean canRemove = true;
        if (sel != null && sel.length > 0) {
            int leaves = 0;
            int lists = 0;
            boolean areSiblings = true;
            ListNode listNode = null;
            int i = 0;
            while (i < sel.length) {
                if (sel[i] instanceof LeafNode) {
                    ++leaves;
                    if (listNode == null) {
                        listNode = (ListNode)sel[i].getParent();
                    } else if (listNode != sel[i].getParent()) {
                        areSiblings = false;
                        listNode = (ListNode)sel[i].getParent();
                    }
                    canRemove = canRemove && lists == 0 && this._canListChange(listNode);
                } else if (sel[i] instanceof ListNode) {
                    listNode = (ListNode)sel[i];
                    ++lists;
                    canRemove = canRemove && leaves == 0 && listNode.getList().getWrappedList() != JLibraryManager.getUserLibraries() && listNode.getList().getWrappedList() instanceof JLibraryList;
                } else {
                    canRemove = false;
                }
                ++i;
            }
        } else {
            canRemove = false;
        }
        this.newButton.setEnabled(allowNew);
        this.removeButton.setEnabled(canRemove);
    }

    public void setTree1SelectionRow(int row) {
        this.libsTree.setSelectionRow(row);
    }

    public void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private boolean _canListChange(ListNode node) {
        ListWrapper list = node.getList();
        return list.isTransient() ^ true;
    }

    protected abstract boolean updateSelection(Library var1);

    protected abstract Library createNewElement(ListWrapper[] var1);

    protected abstract ListNode addLibraryList(ListWrapper var1);

    protected abstract void nodeDeleted(LeafNode var1);

    protected abstract LibraryListNode createLibraryListNode(ListWrapper var1, Iterator var2);

    static URLPath ra$m_allJARsURLPath(TreePanel treePanel) {
        return treePanel.m_allJARsURLPath;
    }

    static Index mav$getIndex(TreePanel treePanel, Project project, URLPath uRLPath) {
        return treePanel.getIndex(project, uRLPath);
    }

    static List mav$getLibraryTreeNodeSubset(TreePanel treePanel, DefaultMutableTreeNode defaultMutableTreeNode) {
        return treePanel.getLibraryTreeNodeSubset(defaultMutableTreeNode);
    }

    static LibraryJAR2TreeNodeCache ra$m_libsJAR2TreeNode(TreePanel treePanel) {
        return treePanel.m_libsJAR2TreeNode;
    }

    static JTree ra$libsTree(TreePanel treePanel) {
        return treePanel.libsTree;
    }

    static DefaultTreeModel ra$libsModel(TreePanel treePanel) {
        return treePanel.libsModel;
    }

    static URL ra$defDir() {
        return defDir;
    }

    static void wa$defDir(URL uRL) {
        defDir = uRL;
    }

    static boolean ra$isSplit(TreePanel treePanel) {
        return treePanel.isSplit;
    }

    static JButton ra$removeButton(TreePanel treePanel) {
        return treePanel.removeButton;
    }

    static void mav$_updateButtons(TreePanel treePanel, DefaultMutableTreeNode[] defaultMutableTreeNodeArray) {
        treePanel._updateButtons(defaultMutableTreeNodeArray);
    }

    static SearchHelper ra$m_searchHelper(TreePanel treePanel) {
        return treePanel.m_searchHelper;
    }

    static void mav$buildAllJARsURLPath(TreePanel treePanel) {
        treePanel.buildAllJARsURLPath();
    }

    private final class QueryFilterHelper {
        String m_queryText;
        Boolean m_containsWildcardAnywhere;
        Boolean m_containsWildcardAtEnd;
        Boolean m_containsWildcardAtFront;
        Boolean m_doFilter;
        final Boolean m_containsDot;

        private void $init$() {
            this.m_containsWildcardAnywhere = false;
            this.m_containsWildcardAtEnd = false;
            this.m_containsWildcardAtFront = false;
        }

        QueryFilterHelper(String queryText) {
            int indexOfWildcardFromStart;
            this.$init$();
            this.m_queryText = queryText;
            int indexOfDot = this.m_queryText.lastIndexOf(".");
            if (indexOfDot != -1) {
                this.m_containsDot = true;
                if (indexOfDot == this.m_queryText.length() - 1) {
                    this.m_queryText = new StringBuffer().append(this.m_queryText).append("*").toString();
                }
            } else {
                this.m_containsDot = false;
            }
            if ((indexOfWildcardFromStart = this.m_queryText.indexOf("*")) != -1) {
                this.m_containsWildcardAnywhere = true;
                int indexOfWildcardFromEnd = this.m_queryText.lastIndexOf("*");
                if (indexOfWildcardFromEnd == indexOfWildcardFromStart) {
                    this.m_containsWildcardAtFront = indexOfWildcardFromStart == 0;
                    this.m_containsWildcardAtEnd = indexOfWildcardFromEnd == this.m_queryText.length() - 1;
                } else if (!this.m_containsDot.booleanValue()) {
                    this.m_queryText = new StringBuffer().append("*.").append(this.m_queryText).toString();
                }
            }
        }

        private String findAndEscapeDollarSigns(String source) {
            StringBuffer resultBuffer = new StringBuffer();
            int i = 0;
            while (i < source.length()) {
                if (source.charAt(i) != '$') {
                    resultBuffer.append(source.charAt(i));
                } else {
                    resultBuffer.append("\\$");
                }
                ++i;
            }
            return resultBuffer.toString();
        }

        QueryCriteria createQueryCriteria() {
            QueryCriteria queryCriteria = new QueryCriteria();
            queryCriteria.put((Object)"file.extension", (Object)".class");
            if (!this.m_containsDot.booleanValue()) {
                if (this.m_containsWildcardAnywhere.booleanValue()) {
                    if (this.m_containsWildcardAtEnd.booleanValue()) {
                        this.m_doFilter = false;
                        queryCriteria.put((Object)"file.name.starts.with", (Object)this.m_queryText.substring(0, this.m_queryText.length() - 1));
                    } else if (this.m_containsWildcardAtFront.booleanValue()) {
                        this.m_doFilter = false;
                        queryCriteria.put((Object)"file.name.ends.with", (Object)this.m_queryText.substring(1, this.m_queryText.length()));
                    } else {
                        this.m_doFilter = true;
                    }
                } else {
                    this.m_doFilter = false;
                    queryCriteria.put((Object)"file.name", (Object)this.m_queryText);
                }
            } else if (!this.m_containsWildcardAnywhere.booleanValue()) {
                int lastIndexOfDot = this.m_queryText.lastIndexOf(".");
                if (lastIndexOfDot < this.m_queryText.length() - 1) {
                    this.m_doFilter = true;
                    queryCriteria.put((Object)"file.name", (Object)this.m_queryText.substring(lastIndexOfDot + 1));
                } else {
                    this.m_doFilter = true;
                }
            } else {
                this.m_doFilter = true;
            }
            return queryCriteria;
        }

        void filterSearchResults(DefaultMutableTreeNode treeRoot) {
            if (this.m_doFilter.booleanValue()) {
                ArrayList<DefaultMutableTreeNode> treeNodesToRemove = new ArrayList<DefaultMutableTreeNode>();
                Pattern pattern = null;
                if (this.m_containsWildcardAnywhere.booleanValue()) {
                    String patternString = this.m_queryText.replaceAll("\\.", "\\\\.");
                    patternString = this.findAndEscapeDollarSigns(patternString);
                    patternString = patternString.replaceAll("\\*", ".*");
                    pattern = Pattern.compile(patternString);
                }
                int i = 0;
                while (i < treeRoot.getChildCount()) {
                    DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)treeRoot.getChildAt(i);
                    if (rootChild.getChildCount() > 0) {
                        this.filterSearchResults(rootChild);
                        if (rootChild.getChildCount() == 0 && !(rootChild instanceof ListNode)) {
                            treeNodesToRemove.add(rootChild);
                        }
                    } else if (!(rootChild instanceof ListNode)) {
                        String className = (String)rootChild.getUserObject();
                        if (this.m_containsWildcardAnywhere.booleanValue()) {
                            if (!pattern.matcher(className).matches()) {
                                treeNodesToRemove.add(rootChild);
                            }
                        } else if (!className.equalsIgnoreCase(this.m_queryText)) {
                            treeNodesToRemove.add(rootChild);
                        }
                    }
                    ++i;
                }
                for (DefaultMutableTreeNode nodeToBeRemoved : treeNodesToRemove) {
                    nodeToBeRemoved.removeFromParent();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SearchHelper {
        volatile Boolean m_searching;
        private Thread m_searchThread;
        private TreeModel m_defaultModel;
        private TreeModel m_savedModel;
        private SearchProgress m_searchProgress;

        private void $init$() {
            this.m_defaultModel = null;
            this.m_savedModel = null;
        }

        SearchHelper() {
            this.$init$();
            this.m_searching = false;
        }

        void setDefaultTreeModel(TreeModel defaultTreeModel) {
            this.m_defaultModel = defaultTreeModel;
        }

        synchronized void startSearchThread(String searchText, SearchProgress searchProgress) {
            this.m_searchProgress = searchProgress;
            this.startSearchThread(searchText);
        }

        synchronized void startSearchThread(String searchText) {
            if (this.m_searching.booleanValue() && this.m_searchThread != null) {
                this.m_searchThread.interrupt();
            }
            this.m_searchThread = new 1(this, searchText);
            this.m_searching = true;
            this.m_searchThread.start();
        }

        private void applyTreeFilter(String filterText) {
            if ((filterText == null || filterText.length() == 0) && this.m_savedModel != null) {
                TreePanel.ra$libsTree(TreePanel.this).setModel(this.m_defaultModel);
                TreePanel.this.expandAll(TreePanel.ra$libsTree(TreePanel.this), true);
            } else {
                TreePanel.this.expandAll(TreePanel.ra$libsTree(TreePanel.this), true);
                DefaultMutableTreeNode root = this.cloneTree((DefaultMutableTreeNode)this.m_defaultModel.getRoot());
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                try {
                    this.queryIndexAndFilterTree(root, filterText);
                }
                catch (InterruptedException ie) {
                    return;
                }
                SwingUtilities.invokeLater(new 2(this, root, filterText));
                LibraryJAR2TreeNodeCache.mav$clear(TreePanel.ra$m_libsJAR2TreeNode(TreePanel.this));
            }
        }

        private boolean queryIndexAndFilterTree(DefaultMutableTreeNode root, String filterText) throws InterruptedException {
            Index index = TreePanel.mav$getIndex(TreePanel.this, Ide.getDefaultProject(), TreePanel.ra$m_allJARsURLPath(TreePanel.this));
            QueryFilterHelper queryHelper = new QueryFilterHelper(filterText);
            QueryCriteria criteria = queryHelper.createQueryCriteria();
            URL[] urls = new URL[]{};
            try {
                try {
                    index.lock();
                    urls = index.blockingQuery(criteria);
                    index.unlock();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (QueryFailedException e) {
                    e.printStackTrace();
                }
                catch (LockFailedException e) {
                    e.printStackTrace();
                }
            }
            finally {
                index.release();
            }
            ArrayList<DefaultMutableTreeNode> libraryTreeNodesToBeRemoved = new ArrayList<DefaultMutableTreeNode>();
            libraryTreeNodesToBeRemoved.addAll(TreePanel.mav$getLibraryTreeNodeSubset(TreePanel.this, root));
            URL[] uRLArray = urls;
            int n = 0;
            while (n < uRLArray.length) {
                URL nextHitURL = uRLArray[n];
                ArrayList<DefaultMutableTreeNode> treeChildrenThatContainTheHit = TreePanel.ra$m_libsJAR2TreeNode(TreePanel.this).getTreeNodes(this.getJarFileNameFromFileInJarUrl(nextHitURL));
                for (DefaultMutableTreeNode libraryTreeNode : treeChildrenThatContainTheHit) {
                    DefaultMutableTreeNode classChild = new DefaultMutableTreeNode();
                    classChild.setUserObject(this.formatToFullyQualifiedClassName(this.getFileNameFromFileInJarUrl(nextHitURL)));
                    this.removeLibraryTreeNodeByLibraryName(libraryTreeNodesToBeRemoved, ((Library)libraryTreeNode.getUserObject()).getName());
                    libraryTreeNode.insert(classChild, libraryTreeNode.getChildCount());
                }
                ++n;
            }
            for (DefaultMutableTreeNode libraryTreeNode : libraryTreeNodesToBeRemoved) {
                libraryTreeNode.removeFromParent();
            }
            queryHelper.filterSearchResults(root);
            return true;
        }

        private void removeLibraryTreeNodeByLibraryName(ArrayList<DefaultMutableTreeNode> libraryTreeNodes, String libraryName) {
            int i = 0;
            while (i < libraryTreeNodes.size()) {
                String libraryNameFromUserObject;
                DefaultMutableTreeNode libraryNode = libraryTreeNodes.get(i);
                if (libraryNode.getUserObject() instanceof Library && libraryName.equals(libraryNameFromUserObject = ((Library)libraryNode.getUserObject()).getName())) {
                    libraryTreeNodes.remove(i);
                    return;
                }
                ++i;
            }
        }

        private String getJarFileNameFromFileInJarUrl(URL fileInJAR) {
            String jarClassFromJarNameSeparator = "!/";
            String fileInJARAsString = fileInJAR.getFile();
            int indexOfSeparator = fileInJARAsString.indexOf("!/");
            if (indexOfSeparator != -1) {
                return fileInJARAsString.substring(0, indexOfSeparator + "!/".length());
            }
            return null;
        }

        private String getFileNameFromFileInJarUrl(URL fileInJAR) {
            String jarClassFromJarNameSeparator = "!/";
            String fileInJARAsString = fileInJAR.getFile();
            int indexOfSeparator = fileInJARAsString.indexOf("!/");
            if (indexOfSeparator != -1) {
                return fileInJARAsString.substring(indexOfSeparator + "!/".length());
            }
            return null;
        }

        private String formatToFullyQualifiedClassName(String classNameFromJarFile) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(classNameFromJarFile.replace('/', '.').substring(0, classNameFromJarFile.length() - ".class".length()));
            return buffer.toString();
        }

        private DefaultMutableTreeNode cloneTree(DefaultMutableTreeNode root) {
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
            newRoot.setUserObject(root.getUserObject());
            this.cloneTreeChildren(root, newRoot);
            return newRoot;
        }

        private void cloneTreeChildren(DefaultMutableTreeNode original, DefaultMutableTreeNode copy) {
            int i = 0;
            while (i < original.getChildCount()) {
                DefaultMutableTreeNode childCopy;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)original.getChildAt(i);
                if (child instanceof LibraryNode) {
                    childCopy = new DefaultMutableTreeNode();
                    childCopy.setUserObject(child.getUserObject());
                } else if (child instanceof ListNode) {
                    childCopy = TreePanel.this.createLibraryListNode((ListWrapper)child.getUserObject(), null);
                } else {
                    childCopy = new DefaultMutableTreeNode();
                    childCopy.setUserObject(child.getUserObject());
                }
                copy.add(childCopy);
                this.cloneTreeChildren(child, childCopy);
                ++i;
            }
        }

        static TreeModel ra$m_defaultModel(SearchHelper searchHelper) {
            return searchHelper.m_defaultModel;
        }

        static SearchProgress ra$m_searchProgress(SearchHelper searchHelper) {
            return searchHelper.m_searchProgress;
        }

        static void mav$applyTreeFilter(SearchHelper searchHelper, String string) {
            searchHelper.applyTreeFilter(string);
        }

        final class 1
        extends Thread {
            private final /* synthetic */ String v$searchText;
            final /* synthetic */ SearchHelper this$0;

            public void run() {
                TreePanel.mav$buildAllJARsURLPath(this.this$0.TreePanel.this);
                SearchHelper.mav$applyTreeFilter(this.this$0, this.v$searchText);
                this.this$0.m_searching = false;
            }

            public 1(SearchHelper searchHelper, String string) {
                this.v$searchText = string;
                this.this$0 = searchHelper;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ DefaultMutableTreeNode v$root;
            private final /* synthetic */ String v$filterText;
            final /* synthetic */ SearchHelper this$0;

            public void run() {
                TreePanel.ra$libsTree(this.this$0.TreePanel.this).setModel(new DefaultTreeModel(this.v$root));
                this.this$0.TreePanel.this.expandAll(TreePanel.ra$libsTree(this.this$0.TreePanel.this), true);
                if (TreePanel.ra$libsTree(this.this$0.TreePanel.this).getRowCount() > 0) {
                    this.this$0.TreePanel.this.setTree1SelectionRow(0);
                }
                if (SearchHelper.ra$m_searchProgress(this.this$0) != null) {
                    SearchHelper.ra$m_searchProgress(this.this$0).finish();
                }
            }

            public 2(SearchHelper searchHelper, DefaultMutableTreeNode defaultMutableTreeNode, String string) {
                this.v$filterText = string;
                this.v$root = defaultMutableTreeNode;
                this.this$0 = searchHelper;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LibraryJAR2TreeNodeCache {
        private Map<String, ArrayList<DefaultMutableTreeNode>> jarURL2TreeNode = new HashMap<String, ArrayList<DefaultMutableTreeNode>>();

        LibraryJAR2TreeNodeCache() {
        }

        void register(DefaultMutableTreeNode root, Library library) {
            List allFiles = library.getClassPath().asList();
            for (URL jarURL : allFiles) {
                String jarURLAsString = jarURL.getFile();
                if (this.jarURL2TreeNode.containsKey(jarURLAsString)) {
                    this.jarURL2TreeNode.get(jarURLAsString).add(root);
                    continue;
                }
                ArrayList<DefaultMutableTreeNode> value = new ArrayList<DefaultMutableTreeNode>();
                value.add(root);
                this.jarURL2TreeNode.put(jarURLAsString, value);
            }
        }

        ArrayList<DefaultMutableTreeNode> getTreeNodes(String jarFileUrlAsString) {
            return this.jarURL2TreeNode.get(jarFileUrlAsString);
        }

        private void clear() {
            this.jarURL2TreeNode.clear();
        }

        static void mav$clear(LibraryJAR2TreeNodeCache libraryJAR2TreeNodeCache) {
            libraryJAR2TreeNodeCache.clear();
        }
    }

    final class 1
    implements CaretListener {
        private final /* synthetic */ SearchField v$searchField;
        final /* synthetic */ TreePanel this$0;

        public void caretUpdate(CaretEvent e) {
            String queryText = this.v$searchField.getText();
            if ((queryText == null || queryText.length() == 0) && SearchHelper.ra$m_defaultModel(TreePanel.ra$m_searchHelper(this.this$0)) != null) {
                TreePanel.ra$libsTree(this.this$0).setModel(SearchHelper.ra$m_defaultModel(TreePanel.ra$m_searchHelper(this.this$0)));
                this.this$0.expandAll(TreePanel.ra$libsTree(this.this$0), true);
            }
        }

        public 1(TreePanel treePanel, SearchField searchField) {
            this.v$searchField = searchField;
            this.this$0 = treePanel;
        }
    }

    final class 2
    implements SearchListener {
        public void searchPerformed(SearchEvent e) {
            String searchText = e.isFromClear() ? "" : e.getSearchText().trim();
            TreePanel.ra$m_searchHelper(TreePanel.this).startSearchThread(searchText, e.getSearchProgress());
        }

        public void searchCategoryChanged(SearchEvent e) {
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ TreePath v$path;
        final /* synthetic */ TreePanel this$0;

        public void run() {
            TreePanel.ra$libsTree(this.this$0).setSelectionPath(this.v$path);
            TreePanel.ra$libsTree(this.this$0).scrollPathToVisible(this.v$path);
        }

        public 3(TreePanel treePanel, TreePath treePath) {
            this.v$path = treePath;
            this.this$0 = treePanel;
        }
    }

    private final class SelectionManager
    extends KeyAdapter
    implements ActionListener,
    TreeSelectionListener {
        private TreePath[] selPaths;

        private Library[] _getElements(TreePath[] paths) {
            if (paths == null || paths.length == 0) {
                return null;
            }
            ArrayList<Library> list = new ArrayList<Library>();
            int i = 0;
            while (i < paths.length) {
                DefaultMutableTreeNode node;
                DefaultMutableTreeNode defaultMutableTreeNode = node = paths[i] != null ? (DefaultMutableTreeNode)paths[i].getLastPathComponent() : null;
                if (node.getUserObject() instanceof Library) {
                    list.add((Library)node.getUserObject());
                }
                ++i;
            }
            if (list.size() > 0) {
                return list.toArray(new Library[list.size()]);
            }
            return null;
        }

        public final void actionPerformed(ActionEvent ae) {
            String cmd = ae.getActionCommand();
            if (TreePanel.NEW_CMD.equals(cmd)) {
                this.createLibrary();
            } else if (TreePanel.ADD_CMD.equals(cmd)) {
                this.addDirectory();
            } else if (TreePanel.REMOVE_CMD.equals(cmd)) {
                this.deleteSelection();
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            Library[] sel = null;
            TreePath[] paths = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            DefaultMutableTreeNode[] nodes = null;
            if (paths != null) {
                nodes = new DefaultMutableTreeNode[paths.length];
                int i = 0;
                while (i < paths.length) {
                    nodes[i] = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
                    ++i;
                }
                sel = this._getElements(paths);
            }
            TreePanel.mav$_updateButtons(TreePanel.this, nodes);
            if (!TreePanel.this.updateSelection(sel != null && sel.length > 0 ? sel[0] : null)) {
                SwingUtilities.invokeLater(new 1());
            } else {
                this.selPaths = paths;
            }
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (TreePanel.ra$removeButton(TreePanel.this).isEnabled()) {
                    this.deleteSelection();
                }
                e.consume();
            }
        }

        private void createLibrary() {
            ListWrapper[] selectedWrapper;
            Library elem;
            boolean commited;
            TreePath[] paths = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            Object o = paths != null && paths.length > 0 ? paths[0].getLastPathComponent() : null;
            ListNode listNode = null;
            if (o instanceof ListNode) {
                listNode = (ListNode)o;
            } else if (o instanceof LeafNode) {
                listNode = (ListNode)((LeafNode)o).getParent();
            }
            boolean bl = commited = TreePanel.ra$isSplit(TreePanel.this) ? TreePanel.this.commitChanges() : true;
            if (commited && (elem = TreePanel.this.createNewElement(selectedWrapper = new ListWrapper[]{listNode != null ? listNode.getList() : null})) != null) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)TreePanel.this.findNode(null, elem);
                if (child != null) {
                    child.setUserObject(elem);
                    TreePanel.ra$libsModel(TreePanel.this).nodeChanged(child);
                } else {
                    ListNode temp = (ListNode)TreePanel.this.findNode(null, selectedWrapper[0]);
                    if (temp != null) {
                        listNode = temp;
                    }
                    child = (DefaultMutableTreeNode)listNode.add(elem);
                    TreePanel.ra$libsModel(TreePanel.this).nodesWereInserted(listNode, new int[]{listNode.getIndex(child)});
                }
                TreePanel.this.selectNode(child);
            }
        }

        private void addDirectory() {
            URL url;
            URLChooser chooser = DialogUtil.newURLChooser((URL)TreePanel.ra$defDir());
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(1);
            chooser.setShowJarsAsDirs(false);
            int result = chooser.showOpenDialog((Component)TreePanel.this, LibraryArb.getString(10));
            if (result == 0 && (url = chooser.getSelectedURL()) != null) {
                JLibraryList list = JLibraryManager.addLibraryList(url);
                ListWrapper[] lists = TreePanel.this.getLibraryLists();
                boolean found = false;
                if (lists != null) {
                    int i = 0;
                    while (i < lists.length) {
                        if (list == lists[i]) {
                            found = true;
                        }
                        ++i;
                    }
                }
                if (!found) {
                    ListWrapper wrapper = new ListWrapper(list);
                    ListNode listNode = TreePanel.this.addLibraryList(wrapper);
                    TreePath path = new TreePath(listNode.getPath());
                    TreePanel.wa$defDir(URLFileSystem.getParent((URL)url));
                    TreePanel.ra$libsTree(TreePanel.this).expandPath(path);
                    TreePanel.this.selectNode(listNode);
                }
            }
        }

        private void deleteSelection() {
            TreePath[] paths = TreePanel.ra$libsTree(TreePanel.this).getSelectionPaths();
            if (paths == null) {
                return;
            }
            HashMap<ListWrapper, ArrayList<Library>> listMap = new HashMap<ListWrapper, ArrayList<Library>>();
            int i = 0;
            while (i < paths.length) {
                Object o = paths[i].getLastPathComponent();
                if (o instanceof ListNode) {
                    ListNode node = (ListNode)o;
                    ListWrapper list = node.getList();
                    JLibraryManager.removeLibraryList(list.getWrappedList());
                    TreePanel.ra$libsModel(TreePanel.this).removeNodeFromParent(node);
                } else if (o instanceof LeafNode) {
                    LeafNode leaf = (LeafNode)o;
                    ListNode parent = (ListNode)leaf.getParent();
                    Library library = (Library)leaf.getUserObject();
                    ListWrapper wrapper = parent.getList();
                    ArrayList<Library> deletions = (ArrayList<Library>)listMap.get(wrapper);
                    if (deletions == null) {
                        deletions = new ArrayList<Library>();
                        listMap.put(wrapper, deletions);
                    }
                    deletions.add(library);
                }
                ++i;
            }
            if (!listMap.isEmpty()) {
                CheckBoxListModel listModel = new CheckBoxListModel();
                Iterator i2 = listMap.keySet().iterator();
                ArrayList<Library> confirmations = new ArrayList<Library>();
                while (i2.hasNext()) {
                    Object key = i2.next();
                    ArrayList list = (ArrayList)listMap.get(key);
                    int x = list.size() - 1;
                    while (x >= 0) {
                        Library lib = (Library)list.get(x);
                        Object id = lib.getID();
                        String desc = id instanceof URL ? URLFileSystem.getPlatformPathName((URL)((URL)id)) : id.toString();
                        listModel.addElement((Object)lib, lib.getIcon(), true, true, desc);
                        --x;
                    }
                }
                int listSize = listModel.getSize();
                if (listSize > 0) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Library lib = (Library)listModel.getUserObjectAt(0);
                    String string = LibraryArb.format(54, new String[]{lib instanceof JDK ? LibraryArb.getString(21) : LibraryArb.getString(64)});
                    if (lib instanceof JDK) {
                        Object[] objectArray3 = new String[2];
                        objectArray3[0] = LibraryArb.getString(21);
                        objectArray2 = objectArray3;
                        objectArray3[1] = listModel.findTextForElement(0);
                    } else {
                        String[] stringArray = new String[2];
                        stringArray[0] = LibraryArb.getString(64);
                        objectArray2 = stringArray;
                        stringArray[1] = listModel.findTextForElement(0);
                    }
                    String string2 = LibraryArb.format(48, objectArray2);
                    if (lib instanceof JDK) {
                        Object[] objectArray4 = new String[1];
                        objectArray = objectArray4;
                        objectArray4[0] = LibraryArb.getString(21);
                    } else {
                        String[] stringArray = new String[1];
                        objectArray = stringArray;
                        stringArray[0] = LibraryArb.getString(63);
                    }
                    if (SelectFilesPanel.showDialog((String)string, (String)string2, (String)LibraryArb.format(71, objectArray), (CheckBoxListModel)listModel, (boolean)true, (int)0, null) == 0) {
                        int x = 0;
                        while (x < listSize) {
                            if (listModel.isElementSelected(x)) {
                                lib = (Library)listModel.getUserObjectAt(x);
                                confirmations.add(lib);
                            }
                            ++x;
                        }
                        int x2 = confirmations.size() - 1;
                        while (x2 >= 0) {
                            lib = (Library)confirmations.get(x2);
                            LeafNode node = (LeafNode)TreePanel.this.findNode(null, lib);
                            ListNode parent = (ListNode)node.getParent();
                            ListWrapper wrapper = parent.getList();
                            wrapper.remove(lib);
                            TreePanel.ra$libsModel(TreePanel.this).removeNodeFromParent(node);
                            --x2;
                        }
                    }
                }
            }
        }

        private SelectionManager() {
        }

        static TreePath[] ra$selPaths(SelectionManager selectionManager) {
            return selectionManager.selPaths;
        }

        static Library[] mav$_getElements(SelectionManager selectionManager, TreePath[] treePathArray) {
            return selectionManager._getElements(treePathArray);
        }

        SelectionManager(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            public void run() {
                if (SelectionManager.ra$selPaths(SelectionManager.this) != null && SelectionManager.ra$selPaths(SelectionManager.this).length > 0) {
                    TreePanel.ra$libsTree(TreePanel.this).setSelectionPaths(SelectionManager.ra$selPaths(SelectionManager.this));
                }
            }
        }
    }

    private static final class Renderer
    extends DefaultTreeCellRenderer {
        public Renderer() {
            this.setOpenIcon(IdeArb.getIcon((int)74));
            this.setClosedIcon(OracleIcons.getIcon((String)"folder.png"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean set, boolean expanded, boolean leaf, int row, boolean focus) {
            JLabel c = (JLabel)super.getTreeCellRendererComponent(tree, value, set, expanded, leaf, row, focus);
            Object obj = ((DefaultMutableTreeNode)value).getUserObject();
            if (obj instanceof Displayable) {
                Displayable displayable = (Displayable)obj;
                if (obj instanceof Node && !((Node)obj).isOpen()) {
                    try {
                        ((Node)obj).open();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                this.setText(displayable.getShortLabel());
                this.setToolTipText(displayable.getToolTipText());
                if (obj instanceof Library) {
                    this.setIcon(this.getIcon((Library)obj));
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            } else if (obj != null) {
                this.setToolTipText(obj.toString());
                if (leaf) {
                    this.setIcon(this.getLeafIcon());
                } else if (expanded) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return c;
        }

        private Icon getIcon(Library lib) {
            URLPath path = lib.getClassPath();
            if (!(path != null && path.size() != 0 || (path = lib.getSourcePath()) != null && path.size() != 0 || (path = lib.getDocPath()) != null && path.size() != 0)) {
                this.setForeground(Color.red);
                return IdeIcons.getIcon((int)2);
            }
            return lib.getIcon();
        }
    }
}

