/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdevimpl.compiler.CompilerOption;
import oracle.jdevimpl.compiler.CompilerOptionManager;
import oracle.jdevimpl.resource.CompilerArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerOptionPanel
extends ProjectSettingsTraversablePanel
implements TreeExpansionListener,
MouseListener,
KeyListener,
TreeSelectionListener {
    private JTree optionTree;
    private DefaultMutableTreeNode rootNode;
    private boolean optionsLoaded;
    private JTextField cellEditorTextField;

    public CompilerOptionPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDataKey() {
        return OjcConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return CompilerOptionManager.getOptionKeys();
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        if (tc != null && CompilerOptionPanel.isDefaultProject((Namespace)tc)) {
            this.setHelpID("f1_com_proset_optionsdpp_html");
        } else {
            this.setHelpID("f1_com_proset_options_html");
        }
        CompilerOptionManager compilerOptionManager = CompilerOptionPanel.getCompilerOptions(tc);
        this.loadFrom(compilerOptionManager);
    }

    public void onExit(TraversableContext tc) {
        CompilerOptionManager compilerOptionManager = CompilerOptionPanel.getCompilerOptions(tc);
        this.commitTo(compilerOptionManager);
        this.preserveTreeState();
    }

    private static CompilerOptionManager getCompilerOptions(TraversableContext tc) {
        PropertyStorage propertyData = CompilerOptionPanel.getPropertyData((Namespace)tc);
        return CompilerOptionManager.getInstance(propertyData);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        TreePath path = event.getPath();
        if (path.getLastPathComponent() instanceof CategoryNode) {
            CategoryNode categoryNode = (CategoryNode)path.getLastPathComponent();
            int childCount = categoryNode.getChildCount();
            int x = 0;
            while (x < childCount) {
                TreeNode node = categoryNode.getChildAt(x);
                if (node instanceof OptionNode) {
                    OptionNode optionNode = (OptionNode)node;
                    if (optionNode.compilerOption.getArgument() != null) {
                        TreePath optionPath = path.pathByAddingChild(optionNode);
                        this.optionTree.expandPath(optionPath);
                    }
                }
                ++x;
            }
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.rootNode = new DefaultMutableTreeNode();
        this.optionTree = new 1(this, new DefaultTreeModel(this.rootNode));
        this.optionTree.setRootVisible(false);
        this.optionTree.setShowsRootHandles(true);
        this.optionTree.setEditable(true);
        this.optionTree.setRowHeight(0);
        this.optionTree.addTreeExpansionListener(this);
        OptionCellRenderer cellRenderer = new OptionCellRenderer();
        this.optionTree.setCellRenderer(cellRenderer);
        this.optionTree.getSelectionModel().setSelectionMode(1);
        this.optionTree.addMouseListener(this);
        this.optionTree.addKeyListener(this);
        this.optionTree.addTreeSelectionListener(this);
        this.cellEditorTextField = new JTextField("", 40);
        OptionCellEditor cellEditor = new OptionCellEditor(this.cellEditorTextField);
        this.optionTree.setCellEditor(cellEditor);
        JLabel compilerOptionsLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)compilerOptionsLabel, (Component)this.optionTree, (String)CompilerArb.getString(27));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.add(compilerOptionsLabel, gbc);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add((Component)this.optionTree, null);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 10, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this.add(scrollPane, gbc);
    }

    private void loadFrom(CompilerOptionManager compilerOptionManager) {
        if (!this.optionsLoaded) {
            this.optionsLoaded = true;
            DefaultTreeModel model = (DefaultTreeModel)this.optionTree.getModel();
            Hashtable<String, DefaultMutableTreeNode> categoryNodes = new Hashtable<String, DefaultMutableTreeNode>();
            Hashtable<String, DefaultMutableTreeNode> compilerNodes = new Hashtable<String, DefaultMutableTreeNode>();
            Collection<CompilerOption> compilerOptions = compilerOptionManager.getOptionsOfAllCompilers();
            for (CompilerOption option : compilerOptions) {
                DefaultMutableTreeNode categoryNode;
                DefaultMutableTreeNode compilerNode = (DefaultMutableTreeNode)compilerNodes.get(option.getCompilerName());
                if (compilerNode == null) {
                    boolean isCurrentCompiler = option.getCompilerName().equalsIgnoreCase(compilerOptionManager.getCurrentCompiler());
                    compilerNode = new CompilerNode(option.getCompilerName(), isCurrentCompiler);
                    model.insertNodeInto(compilerNode, this.rootNode, this.rootNode.getChildCount());
                    compilerNodes.put(option.getCompilerName(), compilerNode);
                }
                if ((categoryNode = (DefaultMutableTreeNode)categoryNodes.get(option.getCompilerName() + option.getCategory())) == null) {
                    categoryNode = new CategoryNode(option.getCategory());
                    model.insertNodeInto(categoryNode, compilerNode, compilerNode.getChildCount());
                    categoryNodes.put(option.getCompilerName() + option.getCategory(), categoryNode);
                }
                OptionNode optionNode = new OptionNode();
                optionNode.compilerOption = option;
                optionNode.checkBox.setSelected(option.isTurnedOn());
                StringBuffer buf = new StringBuffer();
                if (option.getName().equals("additional.options")) {
                    buf.append(CompilerArb.getString(44));
                } else {
                    buf.append(option.getName());
                }
                buf.append("     (");
                buf.append(option.getDescription());
                buf.append(')');
                optionNode.label.setText(buf.toString());
                model.insertNodeInto(optionNode, categoryNode, categoryNode.getChildCount());
                if (option.getArgument() == null) continue;
                ArgumentNode argumentNode = new ArgumentNode();
                argumentNode.setText(option.getArgument());
                model.insertNodeInto(argumentNode, optionNode, optionNode.getChildCount());
            }
        } else {
            this.updateNodes(compilerOptionManager, this.rootNode);
        }
        TreePath treePath = new TreePath(this.rootNode);
        this.optionTree.expandPath(treePath);
        if (CompilerOptionManager.compilerOptionPanelTreeState != null) {
            this.initializeTreeState(treePath, CompilerOptionManager.compilerOptionPanelTreeState);
        }
    }

    private void commitTo(CompilerOptionManager optionManager) {
        this.visitOptionNodes(optionManager, this.rootNode);
    }

    private void updateNodes(CompilerOptionManager optionManager, TreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.optionTree.getModel();
        if (node instanceof CompilerNode) {
            String currentCompiler = optionManager.getCurrentCompiler();
            boolean wasCurrentCompiler = ((CompilerNode)node).isCurrentCompiler;
            if (currentCompiler.equalsIgnoreCase(((CompilerNode)node).getUserObject().toString())) {
                if (!wasCurrentCompiler) {
                    ((CompilerNode)node).isCurrentCompiler = true;
                    model.nodeChanged(node);
                }
            } else if (wasCurrentCompiler) {
                ((CompilerNode)node).isCurrentCompiler = false;
                model.nodeChanged(node);
            }
        } else if (node instanceof OptionNode) {
            OptionNode optionNode = (OptionNode)node;
            CompilerOption option = optionNode.compilerOption;
            CompilerOption newOption = optionManager.getCompilerOption(option.getQualifiedName());
            if (!option.equals(newOption)) {
                optionNode.compilerOption = newOption;
                optionNode.checkBox.setSelected(newOption.isTurnedOn());
                model.nodeChanged(node);
            }
        }
        int x = 0;
        while (x < node.getChildCount()) {
            this.updateNodes(optionManager, node.getChildAt(x));
            ++x;
        }
    }

    private void visitOptionNodes(CompilerOptionManager optionManager, TreeNode node) {
        if (node instanceof OptionNode) {
            TreeNode child;
            CompilerOption option = ((OptionNode)node).compilerOption;
            if (node.getChildCount() > 0 && (child = node.getChildAt(0)) instanceof ArgumentNode) {
                option.setArgument(((ArgumentNode)child).textField.getText().trim());
            }
            option.setTurnedOn(((OptionNode)node).checkBox.isSelected());
            optionManager.setCompilerOption(option);
        }
        int x = 0;
        while (x < node.getChildCount()) {
            this.visitOptionNodes(optionManager, node.getChildAt(x));
            ++x;
        }
    }

    private void preserveTreeState() {
        TreePath treePath = new TreePath(this.rootNode);
        Enumeration<TreePath> enumeration = this.optionTree.getExpandedDescendants(treePath);
        ArrayList<String> expandedNodesList = new ArrayList<String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode parent;
                TreePath expandedPath = enumeration.nextElement();
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)expandedPath.getLastPathComponent();
                if (node instanceof OptionNode || node instanceof ArgumentNode || (parent = (DefaultMutableTreeNode)node.getParent()) == null) continue;
                if (parent.getUserObject() != null) {
                    expandedNodesList.add(parent.getUserObject().toString() + node.getUserObject().toString());
                    continue;
                }
                expandedNodesList.add(node.getUserObject().toString());
            }
        }
        CompilerOptionManager.compilerOptionPanelTreeState = expandedNodesList;
    }

    private void initializeTreeState(TreePath nodePath, List<String> expandedNodesList) {
        DefaultMutableTreeNode parent;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodePath.getLastPathComponent();
        boolean expandPath = false;
        if (!(node instanceof OptionNode) && !(node instanceof ArgumentNode) && (parent = (DefaultMutableTreeNode)node.getParent()) != null) {
            if (parent.getUserObject() != null) {
                if (expandedNodesList.contains(parent.getUserObject().toString() + node.getUserObject().toString())) {
                    expandPath = true;
                }
            } else if (expandedNodesList.contains(node.getUserObject().toString())) {
                expandPath = true;
            }
        }
        if (expandPath) {
            this.optionTree.expandPath(nodePath);
        }
        int x = 0;
        while (x < node.getChildCount()) {
            this.initializeTreeState(nodePath.pathByAddingChild(node.getChildAt(x)), expandedNodesList);
            ++x;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        int x;
        int row;
        TreePath path;
        if (e.getComponent() == this.optionTree && (path = this.optionTree.getPathForRow(row = this.optionTree.getRowForLocation(x = e.getX(), y = e.getY()))) != null) {
            if (path.getLastPathComponent() instanceof OptionNode) {
                OptionNode node = (OptionNode)path.getLastPathComponent();
                node.checkBox.setSelected(node.checkBox.isSelected() ^ true);
                ((DefaultTreeModel)this.optionTree.getModel()).nodeChanged(node);
            } else if (path.getLastPathComponent() instanceof ArgumentNode) {
                this.optionTree.startEditingAtPath(path);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        TreePath path;
        if (e.getKeyCode() == 32 && e.getComponent() == this.optionTree && (path = this.optionTree.getSelectionPath()) != null && path.getLastPathComponent() instanceof OptionNode) {
            OptionNode node = (OptionNode)path.getLastPathComponent();
            node.checkBox.setSelected(node.checkBox.isSelected() ^ true);
            ((DefaultTreeModel)this.optionTree.getModel()).nodeChanged(node);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node;
        if (e.getSource() == this.optionTree && (node = (DefaultMutableTreeNode)this.optionTree.getLastSelectedPathComponent()) instanceof ArgumentNode) {
            SwingUtilities.invokeLater(new 2());
        }
    }

    static JTree ra$optionTree(CompilerOptionPanel compilerOptionPanel) {
        return compilerOptionPanel.optionTree;
    }

    final class 1
    extends OptionTree {
        public boolean isPathEditable(TreePath path) {
            return path.getLastPathComponent() instanceof ArgumentNode;
        }

        public 1(CompilerOptionPanel compilerOptionPanel2, TreeModel treeModel) {
            super(treeModel);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            TreePath path = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getSelectionPath();
            if (path != null) {
                CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).startEditingAtPath(path);
            }
        }
    }

    private class OptionNode
    extends DefaultMutableTreeNode {
        JCheckBox checkBox;
        JLabel label;
        CompilerOption compilerOption;
        JPanel panel;

        private void $init$() {
            this.checkBox = new JCheckBox();
            this.label = new JLabel();
            this.panel = new JPanel();
        }

        OptionNode() {
            this.$init$();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            this.panel.add((Component)this.checkBox, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.insets = new Insets(0, 12, 0, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            this.panel.add((Component)this.label, gbc);
        }
    }

    private class ArgumentNode
    extends DefaultMutableTreeNode {
        JTextField textField;
        JPanel panel;

        private void $init$() {
            this.textField = new JTextField("", 40);
            this.panel = new JPanel();
        }

        ArgumentNode() {
            this.$init$();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            this.panel.add((Component)this.textField, gbc);
        }

        void setText(String text) {
            this.textField.setText(text);
            this.textField.setCaretPosition(0);
        }
    }

    private class CategoryNode
    extends DefaultMutableTreeNode {
        JPanel panel;
        JLabel label;

        private void $init$() {
            this.panel = new JPanel();
            this.label = new JLabel();
        }

        CategoryNode(String text) {
            super(text);
            this.$init$();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            this.panel.add((Component)this.label, gbc);
        }
    }

    private class CompilerNode
    extends DefaultMutableTreeNode {
        JLabel label;
        boolean isCurrentCompiler;
        JPanel panel;

        private void $init$() {
            this.label = new JLabel();
            this.panel = new JPanel();
        }

        CompilerNode(String text, boolean isCurrentCompiler) {
            super(text);
            this.$init$();
            this.isCurrentCompiler = isCurrentCompiler;
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 0, 0);
            gbc.ipadx = 0;
            gbc.ipady = 0;
            this.panel.add((Component)this.label, gbc);
        }
    }

    private class OptionCellRenderer
    extends DefaultTreeCellRenderer {
        OptionCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component componentFromSuper = super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof OptionNode) {
                JPanel panel = ((OptionNode)value).panel;
                JLabel label = ((OptionNode)value).label;
                JCheckBox checkBox = ((OptionNode)value).checkBox;
                if (selected) {
                    panel.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    panel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    checkBox.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    checkBox.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    panel.setBackground(UIManager.getColor("Tree.textBackground"));
                    panel.setForeground(UIManager.getColor("Tree.textForeground"));
                    label.setBackground(UIManager.getColor("Tree.textBackground"));
                    label.setForeground(UIManager.getColor("Tree.textForeground"));
                    checkBox.setBackground(UIManager.getColor("Tree.textBackground"));
                    checkBox.setForeground(UIManager.getColor("Tree.textForeground"));
                }
                panel.setEnabled(tree.isEnabled());
                label.setEnabled(tree.isEnabled());
                checkBox.setEnabled(tree.isEnabled());
                return panel;
            }
            if (value instanceof ArgumentNode) {
                JPanel panel = ((ArgumentNode)value).panel;
                JTextField textField = ((ArgumentNode)value).textField;
                if (selected) {
                    panel.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    panel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    textField.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    textField.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    panel.setBackground(UIManager.getColor("Tree.textBackground"));
                    panel.setForeground(UIManager.getColor("Tree.textForeground"));
                    textField.setBackground(UIManager.getColor("Tree.textBackground"));
                    textField.setForeground(UIManager.getColor("Tree.textForeground"));
                }
                panel.setEnabled(tree.isEnabled());
                textField.setEnabled(tree.isEnabled());
                return panel;
            }
            if (value instanceof CompilerNode) {
                String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                JPanel panel = ((CompilerNode)value).panel;
                JLabel compilerLabel = ((CompilerNode)value).label;
                if (selected) {
                    panel.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    panel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    compilerLabel.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    compilerLabel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    panel.setBackground(UIManager.getColor("Tree.textBackground"));
                    panel.setForeground(UIManager.getColor("Tree.textForeground"));
                    compilerLabel.setBackground(UIManager.getColor("Tree.textBackground"));
                    compilerLabel.setForeground(UIManager.getColor("Tree.textForeground"));
                }
                if (((CompilerNode)value).isCurrentCompiler) {
                    StringBuilder buf = new StringBuilder();
                    buf.append(stringValue);
                    buf.append(" (");
                    buf.append(CompilerArb.getString(75));
                    buf.append(')');
                    compilerLabel.setText(buf.toString());
                } else {
                    compilerLabel.setText(stringValue);
                }
                panel.setEnabled(tree.isEnabled());
                compilerLabel.setEnabled(tree.isEnabled());
                return panel;
            }
            if (value instanceof CategoryNode) {
                String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
                JPanel panel = ((CategoryNode)value).panel;
                JLabel label = ((CategoryNode)value).label;
                if (selected) {
                    panel.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    panel.setForeground(UIManager.getColor("Tree.selectionForeground"));
                    label.setBackground(UIManager.getColor("Tree.selectionBackground"));
                    label.setForeground(UIManager.getColor("Tree.selectionForeground"));
                } else {
                    panel.setBackground(UIManager.getColor("Tree.textBackground"));
                    panel.setForeground(UIManager.getColor("Tree.textForeground"));
                    label.setBackground(UIManager.getColor("Tree.textBackground"));
                    label.setForeground(UIManager.getColor("Tree.textForeground"));
                }
                label.setText(stringValue);
                panel.setEnabled(tree.isEnabled());
                label.setEnabled(tree.isEnabled());
                return panel;
            }
            return componentFromSuper;
        }
    }

    private class OptionCellEditor
    extends DefaultCellEditor
    implements KeyListener {
        ArgumentNode argumentNode;

        public OptionCellEditor(JTextField textField) {
            super(textField);
            textField.addKeyListener(this);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Component comp = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
            if (value instanceof ArgumentNode) {
                this.argumentNode = (ArgumentNode)value;
                comp.setPreferredSize(this.argumentNode.textField.getSize());
            }
            return comp;
        }

        public boolean stopCellEditing() {
            this.argumentNode = null;
            return super.stopCellEditing();
        }

        public void cancelCellEditing() {
            this.argumentNode = null;
            super.cancelCellEditing();
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
            TreePath path;
            TreePath path2;
            if (e.getKeyCode() == 38 && (path2 = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getSelectionPath()) != null) {
                int row = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getRowForPath(path2);
                path2 = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getPathForRow(row - 1);
                if (path2 != null) {
                    CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).setSelectionPath(path2);
                }
            }
            if (e.getKeyCode() == 40 && (path = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getSelectionPath()) != null) {
                int row = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getRowForPath(path);
                path = CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).getPathForRow(row + 1);
                if (path != null) {
                    CompilerOptionPanel.ra$optionTree(CompilerOptionPanel.this).setSelectionPath(path);
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            if (this.argumentNode != null) {
                this.argumentNode.setText(((JTextField)this.editorComponent).getText());
            }
        }
    }

    private class OptionTree
    extends JTree {
        OptionTree(TreeModel newModel) {
            super(newModel);
        }

        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof ArgumentNode) {
                return ((ArgumentNode)value).textField.getText().trim();
            }
            return super.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

