/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.compiler.CompilerDescription;
import oracle.jdevimpl.compiler.CompilerOption;
import oracle.jdevimpl.compiler.JavacCompilerDescription;
import oracle.jdevimpl.compiler.OjcCompilerDescription;
import oracle.jdevimpl.resource.CompilerArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerOptionManager
extends HashStructureAdapter {
    public static final String COMPILER_NAME = "compiler.name";
    public static final String DEFAULT_COMPILER_NAME = "Ojc";
    public static final String COMPILER_OPTIONS_AS_STRING = "commandline.options";
    public static final String COMPILER_OPTIONS_AS_LIST = "commandline.optionlist";
    static List<String> compilerOptionPanelTreeState;
    static final String ADDITIONAL_OPTIONS = "additional.options";
    private static List<CompilerDescription> compilers;
    private String jdkVersion;

    static {
        compilers = new ArrayList<CompilerDescription>();
        compilers.add(new OjcCompilerDescription());
        compilers.add(new JavacCompilerDescription());
        compilerOptionPanelTreeState = null;
    }

    public static CompilerOptionManager getInstance(PropertyStorage project) {
        return new CompilerOptionManager(CompilerOptionManager.findOrCreate((PropertyStorage)project, (String)OjcConfiguration.DATA_KEY), project);
    }

    protected CompilerOptionManager(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.jdkVersion = this.getJdkVersion(project);
    }

    public void setToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            this.rebuildStorageOfOptions(compiler.getCompilerName(), true);
        }
    }

    public void reSetToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            String[] optionKeys;
            String[] stringArray = optionKeys = compiler.getQualifiedOptionNames();
            int n = 0;
            while (n < stringArray.length) {
                String optionKey = stringArray[n];
                this._hash.remove(optionKey);
                ++n;
            }
            this.rebuildStorageOfOptions(compiler.getCompilerName(), true);
        }
    }

    public String[] getCompilerOptionsAsArray(String compilerName) {
        return this.getCompilerOptionsAsArray(compilerName, false);
    }

    private String[] getCompilerOptionsAsArray(String compilerName, boolean useDefaultOptions) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = useDefaultOptions ? this.getDefaultCompilerOptions(compilerName) : this.getCompilerOptions(compilerName);
        String additionalOptions = null;
        ArrayList<String> optionStrings = new ArrayList<String>();
        for (CompilerOption option : compilerOptions) {
            if (!option.isTurnedOn()) continue;
            if (option.getName().equals(ADDITIONAL_OPTIONS)) {
                if (option.getArgument() == null || option.getArgument().trim().length() <= 0) continue;
                additionalOptions = option.getArgument().trim();
                continue;
            }
            if (option.getArgument() != null && option.getArgument().trim().length() == 0) continue;
            String trimmedOptionName = option.getName().trim();
            if (trimmedOptionName.endsWith(":")) {
                if (option.getArgument() != null) {
                    optionStrings.add(trimmedOptionName + option.getArgument().trim());
                    continue;
                }
                optionStrings.add(trimmedOptionName);
                continue;
            }
            optionStrings.add(trimmedOptionName);
            if (option.getArgument() == null) continue;
            optionStrings.add(option.getArgument().trim());
        }
        if (additionalOptions != null) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ");
            while (tokenizer.hasMoreTokens()) {
                optionStrings.add(tokenizer.nextToken().trim());
            }
        }
        return optionStrings.toArray(new String[optionStrings.size()]);
    }

    public String getCompilerOptionsAsString(String compilerName) {
        return this.getCompilerOptionsAsString(compilerName, false);
    }

    private String getCompilerOptionsAsString(String compilerName, boolean useDefaultOptions) {
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        StringBuffer buf = new StringBuffer();
        String[] stringArray = options;
        int n = 0;
        while (n < stringArray.length) {
            String option = stringArray[n];
            buf.append(option);
            buf.append(' ');
            ++n;
        }
        return buf.toString();
    }

    static String[] getOptionKeys() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (CompilerDescription provider : compilers) {
            keyList.addAll(Arrays.asList(provider.getQualifiedOptionNames()));
        }
        return keyList.toArray(new String[keyList.size()]);
    }

    Collection<CompilerOption> getOptionsOfAllCompilers() {
        return this.getCompilerOptions(null);
    }

    private Collection<CompilerOption> getCompilerOptions(String compilerName) {
        ArrayList<CompilerOption> optionList = new ArrayList<CompilerOption>();
        for (CompilerDescription provider : compilers) {
            if (compilerName != null && !compilerName.equalsIgnoreCase(provider.getCompilerName())) continue;
            String[] qualifiedOptionNames = provider.getQualifiedOptionNames();
            int x = 0;
            while (x < qualifiedOptionNames.length) {
                optionList.add(this.getCompilerOption(qualifiedOptionNames[x]));
                ++x;
            }
        }
        return this.filterCompilerOptions(compilerName, optionList);
    }

    public List<String> getCompilers() {
        ArrayList<String> compilerList = new ArrayList<String>();
        for (CompilerDescription provider : compilers) {
            compilerList.add(provider.getCompilerName());
        }
        return compilerList;
    }

    public String getCurrentCompiler() {
        boolean useJavac;
        if (this._hash.containsKey("useJavac") && (useJavac = this._hash.getBoolean("useJavac"))) {
            return "Javac";
        }
        String compilerName = this._hash.getString(COMPILER_NAME);
        if (compilerName == null) {
            return DEFAULT_COMPILER_NAME;
        }
        return compilerName;
    }

    public void setCurrentCompiler(String compilerName) {
        this._hash.remove("useJavac");
        for (CompilerDescription provider : compilers) {
            if (!provider.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            this._hash.putString(COMPILER_NAME, compilerName);
        }
    }

    private CompilerOption getCompilerOption(String compilerName, String optionName) {
        StringBuffer buf = new StringBuffer();
        buf.append(compilerName);
        buf.append('.');
        buf.append(optionName);
        return this.getCompilerOption(buf.toString());
    }

    CompilerOption getCompilerOption(String fullyQualifiedOptionName) {
        CompilerOption option = this.getOldStyleOption(fullyQualifiedOptionName, "-g", "debugInformation", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-forcecodegen", "alwaysGenClasses", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn", "showWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:320", "showObjectDotStaticWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:320", "showObjectDotStaticWarnings", true);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-deprecation", "showDeprecations", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-deprecation:self", "showSelfDeprecations", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:486", "showUnusedImportWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:486", "showUnusedImportWarnings", true);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn:487", "showPartialImportWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-nowarn:487", "showPartialImportWarnings", true);
        if (option != null) {
            return option;
        }
        if (fullyQualifiedOptionName.endsWith("-exclude") && (option = this.getOldStyleExclude(fullyQualifiedOptionName)) != null) {
            return option;
        }
        String optionString = this._hash.getString(fullyQualifiedOptionName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(fullyQualifiedOptionName);
        if (optionString == null) {
            return defaultOption;
        }
        return CompilerOption.createCompilerOption(defaultOption, fullyQualifiedOptionName, optionString);
    }

    private CompilerOption getOldStyleOption(String optionName, String name, String key, boolean reverseOption) {
        if (optionName.endsWith(name) && this._hash.containsKey(key)) {
            boolean optionOn = this._hash.getBoolean(key);
            if (reverseOption) {
                optionOn ^= true;
            }
            CompilerOption option = this.getDefaultCompilerOption(optionName);
            option.setTurnedOn(optionOn);
            return option;
        }
        return null;
    }

    private CompilerOption getOldStyleExclude(String optionName) {
        ListStructure list;
        if (this._hash.containsKey("excludedClasses") && (list = this._hash.getListStructure("excludedClasses")) != null) {
            CompilerOption option = this.getDefaultCompilerOption(optionName);
            option.setTurnedOn(true);
            String[] strArray = (String[])list.toArray((Object[])new String[list.size()]);
            option.setArgument(this.stringArrayToString(strArray));
            return option;
        }
        return null;
    }

    void setCompilerOption(CompilerOption option) {
        String qualifiedName = option.getQualifiedName();
        CompilerOption currentOption = this.getCompilerOption(option.getQualifiedName());
        if (currentOption.equals(option)) {
            return;
        }
        this.setOldStyleOption(qualifiedName, "-g", "debugInformation");
        this.setOldStyleOption(qualifiedName, "-forcecodegen", "alwaysGenClasses");
        this.setOldStyleOption(qualifiedName, "-warn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-warn:320", "showObjectDotStaticWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:320", "showObjectDotStaticWarnings");
        this.setOldStyleOption(qualifiedName, "-deprecation", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-deprecation:self", "showSelfDeprecations");
        this.setOldStyleOption(qualifiedName, "-warn:368", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-nowarn:368", "showDeprecations");
        this.setOldStyleOption(qualifiedName, "-warn:486", "showUnusedImportWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:486", "showUnusedImportWarnings");
        this.setOldStyleOption(qualifiedName, "-warn:487", "showPartialImportWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn:487", "showPartialImportWarnings");
        this.setOldStyleOption(qualifiedName, "-exclude", "excludedClasses");
        this._hash.remove(qualifiedName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(qualifiedName);
        if (!defaultOption.equals(option)) {
            String optionString;
            String string = optionString = option.isTurnedOn() ? "true" : "false";
            if (option.getArgument() != null) {
                optionString = optionString + option.getArgument();
            }
            this._hash.putString(qualifiedName, optionString);
        }
        this.rebuildStorageOfOptions(option.getCompilerName(), false);
    }

    private void rebuildStorageOfOptions(String compilerName, boolean useDefaultOptions) {
        this._hash.remove(compilerName + "." + COMPILER_OPTIONS_AS_STRING);
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        ListStructure listStruct = ListStructure.newInstance();
        int x = 0;
        while (x < options.length) {
            listStruct.add((Object)options[x]);
            ++x;
        }
        this._hash.putListStructure(compilerName + "." + COMPILER_OPTIONS_AS_LIST, listStruct);
    }

    private void setOldStyleOption(String optionName, String name, String key) {
        if (optionName.endsWith(name)) {
            this._hash.remove(key);
        }
    }

    private CompilerOption getDefaultCompilerOption(String name) {
        for (CompilerDescription compiler : compilers) {
            CompilerOption option = compiler.getDefaultCompilerOption(name);
            if (option == null) continue;
            return new CompilerOption(option.getCompilerName(), option.getCategory(), option.isTurnedOn(), option.getName(), option.getArgument(), option.getDescription());
        }
        int dotIndex = name.indexOf(46);
        String compilerName = this.getCurrentCompiler();
        if (dotIndex > 0) {
            compilerName = name.substring(0, dotIndex);
            name = name.substring(dotIndex + 1);
        }
        return new CompilerOption(compilerName, CompilerArb.getString(38), false, name, null, "fake option");
    }

    private Collection<CompilerOption> getDefaultCompilerOptions(String compilerName) {
        for (CompilerDescription provider : compilers) {
            if (!provider.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return this.filterCompilerOptions(compilerName, provider.getDefaultCompilerOptions());
        }
        return null;
    }

    private Collection<CompilerOption> filterCompilerOptions(String compilerName, Collection<CompilerOption> options) {
        if (compilerName == null || compilerName.equalsIgnoreCase("javac")) {
            ArrayList<CompilerOption> filteredOptions = new ArrayList<CompilerOption>();
            for (CompilerOption option : options) {
                if (this.filterJavacOption(option, compilerName, "1.6", new String[]{"-proc", "-Xprint"}) || this.filterJavacOption(option, compilerName, "1.5", new String[]{"-X", "-cp", "-endors", "-version"}) || this.filterJavacOption(option, compilerName, "1.3", new String[]{"-g:", "-boot", "-ext"})) continue;
                filteredOptions.add(option);
            }
            return filteredOptions;
        }
        return options;
    }

    boolean filterJavacOption(CompilerOption option, String compilerName, String firstSupportedVersion, String[] filteredOptions) {
        if (this.jdkVersion.compareTo(firstSupportedVersion) < 0) {
            String[] stringArray = filteredOptions;
            int n = 0;
            while (n < stringArray.length) {
                String filteredOption = stringArray[n];
                if (option.getName().startsWith(filteredOption) && (compilerName != null || option.getCompilerName().equalsIgnoreCase("javac"))) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isUseJavac() {
        return this.getCurrentCompiler().equalsIgnoreCase("Javac");
    }

    public boolean isUseOjc() {
        return this.getCurrentCompiler().equalsIgnoreCase(DEFAULT_COMPILER_NAME);
    }

    public void setUseJavac(boolean useJavac) {
        this.setCurrentCompiler(useJavac ? "Javac" : DEFAULT_COMPILER_NAME);
    }

    public boolean isForceCodeGen() {
        return this.getCompilerOption(DEFAULT_COMPILER_NAME, "-forcecodegen").isTurnedOn();
    }

    public void setForceCodeGen(boolean forceCodeGen) {
        CompilerOption option = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-forcecodegen");
        option.setTurnedOn(forceCodeGen);
        this.setCompilerOption(option);
    }

    public boolean isShowWarnings() {
        String currentCompiler = this.getCurrentCompiler();
        return this.getCompilerOption(currentCompiler, "-warn").isTurnedOn();
    }

    public void setShowWarnings(boolean showWarnings) {
        String currentCompiler = this.getCurrentCompiler();
        CompilerOption option = this.getCompilerOption(currentCompiler, "-warn");
        option.setTurnedOn(showWarnings);
        this.setCompilerOption(option);
    }

    public boolean isShowUnusedImportWarnings() {
        return this.isShowWarnings("486");
    }

    public void setShowUnusedImportWarnings(boolean showUnusedImportWarnings) {
        this.setShowWarnings(showUnusedImportWarnings, "486");
    }

    public boolean isShowPartialImportWarnings() {
        return this.isShowWarnings("487");
    }

    public void setShowPartialImportWarnings(boolean showPartialImportWarnings) {
        this.setShowWarnings(showPartialImportWarnings, "487");
    }

    public boolean isShowObjectDotStaticWarnings() {
        return this.isShowWarnings("370");
    }

    public void setShowObjectDotStaticWarnings(boolean showObjectDotStaticWarnings) {
        this.setShowWarnings(showObjectDotStaticWarnings, "370");
    }

    public boolean isShowDeprecations() {
        String currentCompiler = this.getCurrentCompiler();
        return this.getCompilerOption(currentCompiler, "-deprecation").isTurnedOn();
    }

    public void setShowDeprecations(boolean showDeprecations) {
        String currentCompiler = this.getCurrentCompiler();
        CompilerOption option = this.getCompilerOption(currentCompiler, "-deprecation");
        option.setTurnedOn(showDeprecations);
        this.setCompilerOption(option);
    }

    public boolean isShowSelfDeprecations() {
        return this.getCompilerOption(DEFAULT_COMPILER_NAME, "-deprecation:self").isTurnedOn();
    }

    public void setShowSelfDeprecations(boolean showSelfDeprecations) {
        CompilerOption option = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-deprecation:self");
        option.setTurnedOn(showSelfDeprecations);
        this.setCompilerOption(option);
    }

    public boolean isDebugInformation() {
        String currentCompiler = this.getCurrentCompiler();
        return this.getCompilerOption(currentCompiler, "-g").isTurnedOn();
    }

    public boolean isDebugInformation(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getCompilerName().equalsIgnoreCase(compilerName)) continue;
            return this.getCompilerOption(compilerName, "-g").isTurnedOn();
        }
        return false;
    }

    public void setDebugInformation(boolean debugInformation) {
        String currentCompiler = this.getCurrentCompiler();
        this.setDebugInformation(currentCompiler, debugInformation);
    }

    public void setDebugInformation(String compilerName, boolean debugInformation) {
        CompilerOption option = this.getCompilerOption(compilerName, "-g");
        option.setTurnedOn(debugInformation);
        this.setCompilerOption(option);
        if (debugInformation) {
            option = this.getCompilerOption(compilerName, "-g:none");
            option.setTurnedOn(false);
            this.setCompilerOption(option);
        }
    }

    public String[] getExcludedClasses() {
        CompilerOption option = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-exclude");
        if (option.isTurnedOn() && option.getArgument() != null && option.getArgument().trim().length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(option.getArgument(), ";");
            ArrayList<String> excludeClasses = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                excludeClasses.add(tokenizer.nextToken());
            }
            return excludeClasses.toArray(new String[excludeClasses.size()]);
        }
        return null;
    }

    public void setExcludedClasses(String[] excludedClasses) {
        CompilerOption option = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-exclude");
        if (excludedClasses != null && excludedClasses.length > 0) {
            option.setTurnedOn(true);
            option.setArgument(this.stringArrayToString(excludedClasses));
        }
        this.setCompilerOption(option);
    }

    private boolean isShowWarnings(String optionNumber) {
        boolean warningsOn = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-warn").isTurnedOn();
        boolean thisWarningOn = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-warn:" + optionNumber).isTurnedOn();
        boolean thisWarningOff = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-nowarn:" + optionNumber).isTurnedOn();
        return warningsOn && !thisWarningOff || thisWarningOn;
    }

    private void setShowWarnings(boolean showWarnings, String optionNumber) {
        CompilerOption option = this.getCompilerOption(DEFAULT_COMPILER_NAME, "-nowarn:" + optionNumber);
        option.setTurnedOn(showWarnings ^ true);
        this.setCompilerOption(option);
    }

    private String stringArrayToString(String[] strArray) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strArray.length) {
            buffer.append(strArray[i]).append(";");
            ++i;
        }
        if (strArray.length > 0) {
            int lastCharIndex = buffer.length() - 1;
            buffer.deleteCharAt(lastCharIndex);
        }
        return buffer.toString().trim();
    }

    private String getJdkVersion(PropertyStorage project) {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance(project);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver.toString();
        }
        return "1.1";
    }
}

