/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdevimpl.library.LibraryArb;

public class LibraryModel {
    protected Component panel;
    protected Library lib;
    protected String name;
    protected MutableLibraryList list;
    protected URLPath clsPath;
    protected URLPath srcPath;
    protected URLPath docPath;

    public LibraryModel(Library lib, MutableLibraryList list, Component panel) {
        this.lib = lib;
        this.list = list;
        this.panel = panel;
    }

    public void setName(String name) {
        this.name = name != null ? name.trim() : "";
    }

    public void setClassPath(URLPath path) {
        this.clsPath = path;
    }

    public void setSourcePath(URLPath path) {
        this.srcPath = path;
    }

    public void setDocPath(URLPath path) {
        this.docPath = path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Library commit() throws Exception {
        URLPath oldPath;
        if (this.lib == null) {
            return this.lib;
        }
        boolean isJDK = this.lib instanceof JDK;
        String oldName = this.lib.getName();
        if (!ModelUtil.hasLength((String)this.name)) {
            this.showError(ControlsArb.getString(64), ControlsArb.getString(59));
            throw new Exception();
        }
        if (!ModelUtil.areEqual((Object)oldName, (Object)this.name)) {
            Object id = this.list.createIDFromName(this.name, isJDK);
            if (id != null) {
                if (oldName != null && oldName.trim().length() > 0) {
                    String msg = LibraryArb.format(60, new String[]{LibraryArb.getString(isJDK ? 21 : 64)});
                    String title = LibraryArb.format(14, new String[]{LibraryArb.getString(isJDK ? 21 : 64)});
                    if (!MessageDialog.confirm((Component)this.panel, (Object)msg, (String)title, null, (boolean)true)) {
                        throw new Exception();
                    }
                }
                Library conflict = null;
                conflict = isJDK ? this.list.findJDK(id) : this.list.findLibrary(id);
                if (conflict != null) {
                    String msg = ComponentArb.format((int)22, (Object[])new String[]{LibraryArb.getString(isJDK ? 21 : 64), this.name});
                    if (!MessageDialog.confirm((Component)this.panel, (Object)msg, (String)ComponentArb.getString((int)18), null, (boolean)true)) throw new Exception();
                    if (this.list.isTransient() || conflict.isLocked()) {
                        this.showError(ComponentArb.format((int)19, (Object[])new String[]{this.name}), ComponentArb.getString((int)32));
                        throw new Exception();
                    }
                }
            } else {
                this.showError(ControlsArb.getString(64), ControlsArb.getString(59));
                throw new Exception();
            }
            Library temp = null;
            this.list.remove(this.lib);
            temp = isJDK ? this.list.addJDK(this.name, ((JDK)this.lib).getJavaExecutable()) : this.list.addLibrary(this.name);
            if (temp != null) {
                temp.initFromLibrary(this.lib);
            }
            this.lib = temp;
        }
        if (!ModelUtil.areEqual((Object)this.clsPath, (Object)(oldPath = this.lib.getClassPath()))) {
            this.lib.setClassPath(this.clsPath);
        }
        if (!ModelUtil.areEqual((Object)this.srcPath, (Object)(oldPath = this.lib.getSourcePath()))) {
            this.lib.setSourcePath(this.srcPath);
        }
        if (ModelUtil.areEqual((Object)this.docPath, (Object)(oldPath = this.lib.getDocPath()))) return this.lib;
        this.lib.setDocPath(this.docPath);
        return this.lib;
    }

    protected void showError(String errMsg, String title) {
        MessageDialog.error((Component)this.panel, (Object)errMsg, (String)title, null);
    }
}

