/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URL;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.java.v1.JavaParser;
import oracle.javatools.parser.java.v1.symbol.RootSymbol;
import oracle.javatools.parser.java.v2.scanner.JavaLexer;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.model.PackagedSource;

public final class JavaSourceNode
extends JavaNode
implements PackagedSource {
    public static final String EXT = ".java";
    public static final String SQLJ_EXT = ".sqlj";
    public static final String defaultName = ModelArb.getString((int)24);
    private SoftReference _rootMemberRef;
    private SoftReference _rootFullRef;
    private SoftReference _root1MemberRef;
    private SoftReference _root1FullRef;
    private static final JavaParser.ParsingOptions PARSER_OPTIONS1 = new JavaParser.ParsingOptions();
    private TextBufferListener _listener;

    private void $init$() {
        this._listener = new ParserListener(null);
    }

    static {
        JavaSourceNode.PARSER_OPTIONS1.startOffset = 0;
        JavaSourceNode.PARSER_OPTIONS1.inputType = 1;
        JavaSourceNode.PARSER_OPTIONS1.parseDepth = 3;
        JavaSourceNode.PARSER_OPTIONS1.reportErrors = true;
    }

    public JavaSourceNode() {
        this.$init$();
        this.getAttributes().set(ElementAttributes.BUILDABLE);
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
        this._clearRoot();
    }

    public boolean isSqlj() {
        return URLFileSystem.hasSuffix((URL)this.getURL(), (String)SQLJ_EXT);
    }

    public String getPackage() {
        String pkg = "";
        TextBuffer txtBuf = this.acquireTextBuffer();
        if (txtBuf != null) {
            txtBuf.readLock();
            try {
                JavaLexer lexer = new JavaLexer();
                lexer.setTextBuffer((ReadTextBuffer)txtBuf);
                lexer.setPosition(0);
                lexer.setSkipComments(true);
                LexerToken lexTkn = lexer.createLexerToken();
                int tkn = lexer.lex(lexTkn);
                if (tkn == 125) {
                    FastStringBuffer buf = new FastStringBuffer();
                    boolean foundDot = false;
                    block7: while (true) {
                        switch (lexer.lex(lexTkn)) {
                            case 4: {
                                if (foundDot) {
                                    buf.append('.');
                                    foundDot = false;
                                }
                                int start = lexTkn.getStartOffset();
                                int len = lexTkn.getEndOffset() - start;
                                buf.append(txtBuf.getChars(start, len));
                                continue block7;
                            }
                            case 43: {
                                foundDot = true;
                                continue block7;
                            }
                        }
                        break;
                    }
                    pkg = buf.toString();
                }
            }
            finally {
                txtBuf.readUnlock();
                this.releaseTextBuffer();
            }
        }
        return pkg;
    }

    public String getPackage(Project project) {
        return this.getPackage();
    }

    public String getSourceFile() {
        return URLFileSystem.getFileName((URL)this.getURL());
    }

    public RootSymbol parse1(boolean fullDepth) {
        RootSymbol root = this._getRoot1(fullDepth);
        if (root == null) {
            TextBuffer buf = this.acquireTextBuffer();
            if (buf != null) {
                buf.addTextBufferListener(this._listener);
                buf.readLock();
                try {
                    try {
                        JavaSourceNode.PARSER_OPTIONS1.parseDepth = fullDepth ? 3 : 2;
                        root = (RootSymbol)JavaParser.parse((ReadTextBuffer)buf, (JavaParser.ParsingOptions)PARSER_OPTIONS1);
                    }
                    catch (Exception ex) {}
                }
                finally {
                    buf.readUnlock();
                    this.releaseTextBuffer();
                }
            }
            this._setRoot1(root, fullDepth);
        }
        return root;
    }

    public RootSymbol parse1() {
        return this.parse1(true);
    }

    private void _clearRoot() {
        if (this._rootMemberRef != null) {
            this._rootMemberRef.clear();
        }
        this._rootMemberRef = null;
        if (this._rootFullRef != null) {
            this._rootFullRef.clear();
        }
        this._rootFullRef = null;
        if (this._root1MemberRef != null) {
            this._root1MemberRef.clear();
        }
        this._root1MemberRef = null;
        if (this._root1FullRef != null) {
            this._root1FullRef.clear();
        }
        this._root1FullRef = null;
        this.removeTextBufferListener(this._listener);
    }

    private RootSymbol _getRoot1(boolean full) {
        RootSymbol root = null;
        if (this._root1FullRef != null) {
            root = (RootSymbol)this._root1FullRef.get();
        }
        if (root == null && !full && this._root1MemberRef != null) {
            root = (RootSymbol)this._root1MemberRef.get();
        }
        return root;
    }

    private void _setRoot1(RootSymbol root, boolean full) {
        if (this._root1MemberRef != null) {
            this._root1MemberRef.clear();
        }
        if (full) {
            if (this._root1FullRef != null) {
                this._root1FullRef.clear();
            }
            this._root1FullRef = new SoftReference<RootSymbol>(root);
            this._root1MemberRef = this._rootFullRef;
        } else {
            this._root1MemberRef = new SoftReference<RootSymbol>(root);
        }
    }

    static void mav$_clearRoot(JavaSourceNode javaSourceNode) {
        javaSourceNode._clearRoot();
    }

    private class ParserListener
    implements TextBufferListener {
        public void insertUpdate(TextBuffer buffer, int offset, int count, char[] insertedData) {
            JavaSourceNode.mav$_clearRoot(JavaSourceNode.this);
        }

        public void removeUpdate(TextBuffer buffer, int offset, int count, char[] removedData) {
            JavaSourceNode.mav$_clearRoot(JavaSourceNode.this);
        }

        public void attributeUpdate(TextBuffer buffer, int attribute) {
        }

        private ParserListener() {
        }

        ParserListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

