/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import oracle.ide.Ide;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ModelArb;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.jar.JarNode;

public final class JavaProject
extends HashStructureAdapter {
    public static final String EXT = ".jpr";
    public static final String SOURCEPATH_PROPERTY = "sourcePath";
    public static final String CLASSPATH_PROPERTY = "classPath";
    public static final String PROJECT_SOURCEPATH_PROPERTY = "projectSourcePath";
    public static final String DOCPATH_PROPERTY = "docPath";
    private static final int SRC_PATH_EXIST = 0;
    private static final int SRC_PATH_ADD = 1;
    private static final int SRC_PATH_CANCEL_ADD = 2;
    private static ProjectChangeListener _sourcepathListener;
    private static ProjectChangeListener _projectSourcepathListener;
    private static ProjectChangeListener _classpathListener;
    private static ProjectChangeListener _docpathListener;
    private static ProjectChangeListener _exportedRefListener;
    private final Project _project;
    private final HashStructure _user;
    public static final String OUTPUT_DIRECTORY_LOCAL_KEY = "outputDirectory";
    public static final String OUTPUT_DIRECTORY;
    public static final String DEFAULT_PACKAGE = "defaultPackage";
    private static final String MOST_RECENT_PACKAGE = "mostRecentPackage";
    private static final String RECENT_PACKAGES = "recentlyUsedPackages";

    private JavaProject(Project project, HashStructure hash) {
        super(hash);
        this._project = project;
        this._user = project.getUserPropertiesOnly();
    }

    public static JavaProject getInstance(Project project) {
        return new JavaProject(project, project.getProperties());
    }

    public static JavaProject getInstance(Project project, HashStructure hash) {
        return new JavaProject(project, hash);
    }

    public URL getOutputDirectory() {
        URL projectDirURL;
        URL out = this._hash.getURL(OUTPUT_DIRECTORY);
        if (out == null && (projectDirURL = URLFileSystem.getParent((URL)this._project.getURL())) != null) {
            out = URLFactory.newDirURL((URL)projectDirURL, (String)"classes");
        }
        return out;
    }

    public void setOutputDirectory(URL outputDirectory) {
        this._hash.putURL(OUTPUT_DIRECTORY, outputDirectory);
    }

    public String getDefaultPackage() {
        String pkg = this._hash.getString(DEFAULT_PACKAGE);
        if (pkg == null) {
            pkg = JavaProject.generateDefaultPackageName(this._project);
        }
        return pkg;
    }

    public static String generateDefaultPackageName(Project project) {
        if (project == null) {
            return ModelArb.getString((int)27);
        }
        return JavaProject.generateDefaultPackageName(project.getShortLabel());
    }

    public static String generateDefaultPackageName(String projectName) {
        String pkg;
        String projectLabel = projectName.toLowerCase();
        int len = projectLabel.length();
        int extLen = EXT.length();
        String name = projectLabel.endsWith(EXT) && len > extLen ? projectLabel.substring(0, len - EXT.length()) : projectLabel;
        if (IdeUtil.isPackageIdentifier((String)name)) {
            pkg = name;
        } else {
            StringBuffer sb = new StringBuffer(name.length());
            char[] characters = name.toCharArray();
            int maxLen = characters.length - 1;
            int i = 0;
            while (i <= maxLen) {
                int textLen = sb.length();
                if (textLen == 15) break;
                if (textLen == 0 && Character.isJavaIdentifierStart(characters[i]) || textLen > 0 && Character.isJavaIdentifierPart(characters[i])) {
                    sb.append(characters[i]);
                } else if (textLen == 0 && i == maxLen) {
                    sb.append(ModelArb.getString((int)3));
                    i = -1;
                }
                ++i;
            }
            pkg = sb.toString();
        }
        return pkg;
    }

    void setDefaultPackage(String defaultPackage) {
        this._hash.putString(DEFAULT_PACKAGE, defaultPackage);
        this.setMostRecentPackage(defaultPackage);
    }

    public String getMostRecentPackage() {
        String pkg = this._user.getString(MOST_RECENT_PACKAGE);
        if (pkg == null) {
            pkg = this.getDefaultPackage();
            this.setMostRecentPackage(pkg);
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMostRecentPackage(String mostRecentPackage) {
        ListStructure recentPkgs;
        this._user.putString(MOST_RECENT_PACKAGE, mostRecentPackage);
        ListStructure listStructure = recentPkgs = this.getRecentPackages();
        synchronized (listStructure) {
            int idx = recentPkgs.indexOf((Object)mostRecentPackage);
            if (idx == -1) {
                recentPkgs.add(0, (Object)mostRecentPackage);
            } else if (idx > 0) {
                recentPkgs.remove(idx);
                recentPkgs.add(0, (Object)mostRecentPackage);
            }
        }
    }

    public ListStructure getRecentPackages() {
        return this.getOrCreateRecentPackages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecentPackages(List pkgs) {
        ListStructure recentPkgs;
        ListStructure listStructure = recentPkgs = this.getOrCreateRecentPackages();
        synchronized (listStructure) {
            recentPkgs.mirror(pkgs);
        }
    }

    private ListStructure getOrCreateRecentPackages() {
        HashStructure shared = this._project.getSharedPropertiesOnly();
        boolean initializeFromMigratedSettings = !this._user.containsKey(RECENT_PACKAGES) && shared.containsKey(RECENT_PACKAGES);
        ListStructure recentPackages = this._user.getOrCreateListStructure(RECENT_PACKAGES);
        if (initializeFromMigratedSettings) {
            try {
                ListStructure migratedRecentPackages = shared.getListStructure(RECENT_PACKAGES);
                migratedRecentPackages.copyTo(recentPackages);
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        return recentPackages;
    }

    public void addToProjectSourcePath(JavaSourceNode node) {
        boolean[] ask = new boolean[]{true};
        this.addToProjectSourcePath(node, ask);
    }

    public void addToProject(Collection elements, boolean askToAdd) {
        if (elements.size() > 0) {
            boolean addSrcPath = true;
            boolean addClsPath = true;
            boolean[] ask1 = new boolean[]{askToAdd};
            boolean[] ask2 = new boolean[]{askToAdd};
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                if (!this._project.canAdd(element)) {
                    iterator.remove();
                    continue;
                }
                if (!(element instanceof Locatable)) continue;
                Locatable locatable = (Locatable)element;
                if (addSrcPath && locatable instanceof JavaSourceNode) {
                    switch (this.addToProjectSourcePath((JavaSourceNode)locatable, ask1)) {
                        case 2: {
                            addSrcPath = false;
                        }
                        case 0: 
                        case 1: {
                            break;
                        }
                    }
                    continue;
                }
                if ((!addClsPath || !(locatable instanceof JarNode)) && !(locatable instanceof JavaClassNode)) continue;
                switch (this.addToAdditionalClassPath(locatable.getURL(), ask2)) {
                    case 2: {
                        addClsPath = false;
                    }
                    case 0: 
                    case 1: {
                        break;
                    }
                }
            }
        }
    }

    private int addToAdditionalClassPath(URL url, boolean[] ask) {
        JProjectPaths jProjectPaths = JProjectPaths.getInstance((PropertyStorage)this._project);
        URLPath classPath = jProjectPaths.getAdditionalClassPath();
        if (classPath.contains(url = this.validateJarURL(url))) {
            return 0;
        }
        if (ask[0]) {
            ask[0] = false;
            String msg = JProjectArb.getString(52);
            if (JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), msg, JProjectArb.getString(97), 0) == 1) {
                return 2;
            }
        }
        classPath.add(url);
        jProjectPaths.setAdditionalClassPath(classPath);
        return 1;
    }

    private URL validateJarURL(URL url) {
        if (JarUtil.isArchive((String)url.getPath())) {
            return URLFactory.newJarURL((URL)url, (String)"");
        }
        return url;
    }

    private int addToProjectSourcePath(JavaSourceNode node, boolean[] ask) {
        URL nodeURL;
        URLPath urlPath = PathsConfiguration.getInstance(this._project).getProjectSourcePath();
        if (urlPath.toRelativePath(nodeURL = node.getURL()) != null) {
            return 0;
        }
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String pack = node.getPackage(this._project);
        if (ModelUtil.hasLength((String)pack)) {
            pack = pack.replace('.', '/');
            pack = pack.concat("/");
            File packFile = new File(pack);
            URL[] entries = urlPath.getEntries();
            int i = 0;
            while (i < entries.length) {
                File parent;
                URL entryURL = entries[i];
                String relPath = URLFileSystem.toRelativeSpec((URL)node.getURL(), (URL)entryURL, (boolean)true);
                if (ModelUtil.hasLength((String)relPath) && (parent = new File(relPath).getParentFile()) != null && packFile.compareTo(parent) == 0) {
                    return 0;
                }
                ++i;
            }
        } else if (urlPath.contains(parentURL)) {
            return 0;
        }
        if (ask[0]) {
            ask[0] = false;
            String msg = JProjectArb.getString(79);
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), msg, JProjectArb.getString(51), 0);
            if (result == 1 || result == -1) {
                return 2;
            }
        }
        URL srcPathURL = JProjectUtil.determineSourceRoot(node, true, new boolean[]{false});
        PathsConfiguration pathsConfig = PathsConfiguration.getInstance(this._project);
        URLPath paths = pathsConfig.getProjectSourcePath();
        paths.add(srcPathURL);
        pathsConfig.setProjectSourcePath(paths);
        return 1;
    }

    static void init() {
        JavaProject.initSourcepathListener();
        JavaProject.initProjectSourcepathListener();
        JavaProject.initClasspathListener();
        JavaProject.initDocpathListener();
        JavaProject.initExportedRefListener();
    }

    private static void initSourcepathListener() {
        if (_sourcepathListener == null) {
            _sourcepathListener = new 1();
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_sourcepathListener);
            JavaProject.registerJDKLibrariesDependencies(_sourcepathListener);
        }
    }

    private static void initProjectSourcepathListener() {
        if (_projectSourcepathListener == null) {
            _projectSourcepathListener = new 2();
            Project.addProjectChangeListener((String)PathsConfiguration.JAVA_CONTENT_SET_KEY, (ProjectChangeListener)_projectSourcepathListener);
        }
    }

    private static void initClasspathListener() {
        if (_classpathListener == null) {
            _classpathListener = new 3();
            Project.addProjectChangeListener((String)OUTPUT_DIRECTORY, (ProjectChangeListener)_classpathListener);
            Project.addProjectChangeListener((String)(JProjectPaths.DATA_KEY + "/" + "additionalClassPath"), (ProjectChangeListener)_classpathListener);
            JavaProject.registerJDKLibrariesDependencies(_classpathListener);
        }
    }

    private static void initDocpathListener() {
        if (_docpathListener == null) {
            _docpathListener = new 4();
            JavaProject.registerJDKLibrariesDependencies(_docpathListener);
        }
    }

    private static void initExportedRefListener() {
        if (_exportedRefListener == null) {
            _exportedRefListener = new 5();
            Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/exportedReferences", (ProjectChangeListener)_exportedRefListener);
        }
    }

    private static void registerJDKLibrariesDependencies(ProjectChangeListener listener) {
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/jdkReference", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions", (ProjectChangeListener)listener);
        Project.addProjectChangeListener((String)(DependencyConfiguration.DATA_KEY + "/" + "dependencyList"), (ProjectChangeListener)listener);
    }

    static {
        OUTPUT_DIRECTORY = JProjectPaths.DATA_KEY + "/" + OUTPUT_DIRECTORY_LOCAL_KEY;
    }

    private static abstract class CachingProjectChangeListener
    extends ProjectChangeListener {
        private static int _debugLevel = Integer.getInteger("ProjectChangeListener.debug.level", 0);

        protected abstract Object getValue(Project var1);

        protected abstract String getUpdateMessageName();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectOpened(Project project) {
            Object initialValue = this.getValue(project);
            Map tp = project.getTransientProperties();
            String key = this.getUpdateMessageName();
            Map map = tp;
            synchronized (map) {
                tp.put(key, initialValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void projectPropertiesChanged(ProjectChangeEvent event) {
            Project project = event.getProject();
            Map tp = project.getTransientProperties();
            String key = this.getUpdateMessageName();
            Object curValue = this.getValue(project);
            Map map = tp;
            synchronized (map) {
                Object lastValue = tp.get(key);
                if (ModelUtil.areDifferent(lastValue, (Object)curValue)) {
                    tp.put(key, curValue);
                    String updateMessageName = this.getUpdateMessageName();
                    if (_debugLevel > 0) {
                        System.out.println(">>>>> Updated " + updateMessageName);
                    }
                    PropertyChangeEvent pce = new PropertyChangeEvent(project, updateMessageName, lastValue, curValue);
                    PropertyChangeEvent[] pces = new PropertyChangeEvent[]{pce};
                    this.fireEvents(project, pces, (Object)this);
                }
            }
        }

        void fireEvents(Project project, PropertyChangeEvent[] pces, Object origin) {
            UpdateMessage.firePropertiesChanged((Subject)project, (PropertyChangeEvent[])pces, (Object)origin);
        }

        private CachingProjectChangeListener() {
        }

        CachingProjectChangeListener(5 var1_1) {
            this();
        }

        CachingProjectChangeListener(4 var1_1) {
            this();
        }

        CachingProjectChangeListener(3 var1_1) {
            this();
        }

        CachingProjectChangeListener(2 var1_1) {
            this();
        }

        CachingProjectChangeListener(1 var1_1) {
            this();
        }
    }

    static final class 1
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getSourcePath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.SOURCEPATH_PROPERTY;
        }

        public 1() {
            super((1)null);
        }
    }

    static final class 2
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getProjectSourcePath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.PROJECT_SOURCEPATH_PROPERTY;
        }

        public 2() {
            super((2)null);
        }
    }

    static final class 3
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getClassPath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.CLASSPATH_PROPERTY;
        }

        public 3() {
            super((3)null);
        }
    }

    static final class 4
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return PathsConfiguration.getInstance(project).getDocPath();
        }

        protected String getUpdateMessageName() {
            return JavaProject.DOCPATH_PROPERTY;
        }

        public 4() {
            super((4)null);
        }
    }

    static final class 5
    extends CachingProjectChangeListener {
        protected Object getValue(Project project) {
            return JProjectLibraries.getInstance((PropertyStorage)project).getExports();
        }

        protected String getUpdateMessageName() {
            return "exportedReferences";
        }

        public 5() {
            super((5)null);
        }
    }
}

