/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.SourceRootHelper;
import oracle.jdeveloper.resource.JProjectArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JProjectUtil {
    private static final String JAVA_NODE_KEY = "java-node-key";
    private static boolean canceled;

    private JProjectUtil() {
    }

    public static URL getProjectBasePath(Project project) {
        URLPath srcPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL result = srcPath.getFirstEntry();
        if (result == null) {
            result = URLFileSystem.getParent((URL)project.getURL());
        }
        return result;
    }

    public static void addLibraries(Project proj, Object[] libraries) {
        JProjectUtil._updateLibraries(proj, libraries, true);
    }

    public static void removeLibraries(Project proj, Object[] libraries) {
        JProjectUtil._updateLibraries(proj, libraries, false);
    }

    public static void setOutputDirectory(Project project, URL outputDirectory) {
        JavaProject.getInstance(project).setOutputDirectory(outputDirectory);
    }

    public static void execturePathChange(Project project, Runnable runnable) {
        project.applyBatchChanges(runnable);
    }

    public static String getLibraryNameFromPath(URL path) {
        String name = URLFileSystem.getFileName((URL)path);
        if (!URLFileSystem.isDirectory((URL)path) && name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (name != null && !Character.isUpperCase(name.charAt(0))) {
            name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    private static void _updateLibraries(Project project, Object[] libraries, boolean add) {
        if (libraries != null && libraries.length > 0) {
            project.applyBatchChanges((Runnable)new 1(libraries, add, project));
        }
    }

    private static void resetCancelState() {
        canceled = false;
    }

    static void notifyCanceled() {
        canceled = true;
    }

    static URL[] getSourceRoots(URL[] urls, SourceRootHelper[] helpers) {
        JProjectUtil.resetCancelState();
        ArrayList<URL> found = new ArrayList<URL>();
        URL[] uRLArray = urls;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (canceled) {
                return new URL[0];
            }
            ArrayList<URL> roots = JProjectUtil.findSourceRootsFromURL(url, helpers);
            if (roots.size() > 0) {
                found.addAll(roots);
            } else {
                found.add(url);
            }
            JProjectUtil.ensureRootContentIsIncluded(url, found, helpers);
            ++n;
        }
        URL[] urlArray = new URL[found.size()];
        found.toArray(urlArray);
        return urlArray;
    }

    private static void ensureRootContentIsIncluded(URL rootFolderURL, List<URL> found, SourceRootHelper[] helpers) {
        URLFilter filter;
        URL[] children;
        if (found.contains(rootFolderURL)) {
            return;
        }
        boolean shouldAddURL = false;
        for (URL u : found) {
            if (!URLFileSystem.isBaseURLFor((URL)rootFolderURL, (URL)u)) continue;
            shouldAddURL = true;
            break;
        }
        if (shouldAddURL && (children = URLFileSystem.list((URL)rootFolderURL, (URLFilter)(filter = GlobalIgnoreList.getURLFilter()))) != null) {
            boolean addRoot = false;
            URL[] uRLArray = children;
            int n = 0;
            while (n < uRLArray.length) {
                URL nextChild = uRLArray[n];
                if (URLFileSystem.hasSuffix((URL)nextChild, (String)".java")) {
                    addRoot = true;
                    break;
                }
                SourceRootHelper[] sourceRootHelperArray = helpers;
                int n2 = 0;
                while (n2 < sourceRootHelperArray.length) {
                    SourceRootHelper nextHelper = sourceRootHelperArray[n2];
                    if (URLFileSystem.hasSuffix((URL)nextChild, (String)nextHelper.getFileExtension())) {
                        addRoot = true;
                        break;
                    }
                    ++n2;
                }
                if (addRoot) break;
                ++n;
            }
            if (addRoot) {
                found.add(0, rootFolderURL);
            }
        }
    }

    static ArrayList getSourceRootsFromFolder(URL folder, SourceRootHelper[] helpers) {
        JProjectUtil.resetCancelState();
        return JProjectUtil.findSourceRootsFromURL(folder, helpers);
    }

    private static ArrayList<URL> findSourceRootsFromURL(URL folder, SourceRootHelper[] helpers) {
        ArrayList<URL> results = new ArrayList<URL>();
        URLFilter filter = GlobalIgnoreList.getURLFilter();
        URL[] children = URLFileSystem.list((URL)folder, (URLFilter)filter);
        if (children != null) {
            URL[] directories;
            Node[] javaSourceNodes;
            Map<String, List<Node>> nodeMap = JProjectUtil.buildNodeMap(children, helpers);
            Node[] nodeArray = javaSourceNodes = JProjectUtil.getNodesForKey(nodeMap, JAVA_NODE_KEY);
            int n = 0;
            while (n < nodeArray.length) {
                Node node = nodeArray[n];
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                JavaSourceNode javaSourceNode = (JavaSourceNode)node;
                boolean[] errorStatus = new boolean[]{false};
                URL root = JProjectUtil.determineSourceRoot(javaSourceNode, false, errorStatus);
                if (!errorStatus[0] && !results.contains(root)) {
                    results.add(root);
                    return results;
                }
                ++n;
            }
            SourceRootHelper[] sourceRootHelperArray = helpers;
            int n2 = 0;
            while (n2 < sourceRootHelperArray.length) {
                Node[] otherNodes;
                SourceRootHelper nextHelper = sourceRootHelperArray[n2];
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                String key = nextHelper.getClass().getName();
                Node[] nodeArray2 = otherNodes = JProjectUtil.getNodesForKey(nodeMap, key);
                int n3 = 0;
                while (n3 < nodeArray2.length) {
                    Node node = nodeArray2[n3];
                    boolean[] errorStatus = new boolean[]{false};
                    URL root = nextHelper.determineSourceRoot(node, errorStatus);
                    if (!errorStatus[0] && !results.contains(root)) {
                        results.add(root);
                        return results;
                    }
                    ++n3;
                }
                ++n2;
            }
            URL[] uRLArray = directories = JProjectUtil.getDirectories(children);
            int n4 = 0;
            while (n4 < uRLArray.length) {
                URL url = uRLArray[n4];
                if (canceled) {
                    return new ArrayList<URL>(0);
                }
                ArrayList<URL> list = JProjectUtil.findSourceRootsFromURL(url, helpers);
                if (list.size() == 1) {
                    URL root = (URL)list.get(0);
                    if (!results.contains(root)) {
                        results.add(root);
                    }
                    if (URLFileSystem.isBaseURLFor((URL)root, (URL)folder)) {
                        return results;
                    }
                } else if (list.size() > 0) {
                    for (URL u : list) {
                        if (results.contains(u)) continue;
                        results.add(u);
                    }
                }
                ++n4;
            }
        } else if (URLFileSystem.isDirectoryPath((URL)folder)) {
            results.add(folder);
        }
        if (canceled) {
            return new ArrayList<URL>(0);
        }
        return results;
    }

    static URL getSourceRootForFile(URL fileURL, boolean showError, SourceRootHelper[] helpers) {
        URL[] oneFile = new URL[]{fileURL};
        Map<String, List<Node>> map = JProjectUtil.buildNodeMap(oneFile, helpers);
        Node[] javaNodes = JProjectUtil.getNodesForKey(map, JAVA_NODE_KEY);
        if (javaNodes.length == 1) {
            boolean[] errorStatus = new boolean[]{false};
            URL root = JProjectUtil.determineSourceRoot((JavaSourceNode)javaNodes[0], showError, errorStatus);
            return root;
        }
        SourceRootHelper[] sourceRootHelperArray = helpers;
        int n = 0;
        while (n < sourceRootHelperArray.length) {
            Node[] otherNodes;
            SourceRootHelper nextHelper = sourceRootHelperArray[n];
            String key = nextHelper.getClass().getName();
            Node[] nodeArray = otherNodes = JProjectUtil.getNodesForKey(map, key);
            int n2 = 0;
            while (n2 < nodeArray.length) {
                Node node = nodeArray[n2];
                boolean[] errorStatus = new boolean[]{false};
                URL root = nextHelper.determineSourceRoot(node, errorStatus);
                if (!errorStatus[0]) {
                    return root;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private static Node[] getNodesForKey(Map<String, List<Node>> map, String key) {
        if (map.containsKey(key)) {
            List<Node> nodes = map.get(key);
            Node[] nodeArray = new Node[nodes.size()];
            nodes.toArray(nodeArray);
            return nodeArray;
        }
        return new Node[0];
    }

    private static Map<String, List<Node>> buildNodeMap(URL[] fileList, SourceRootHelper[] helpers) {
        HashMap<String, List<Node>> map = new HashMap<String, List<Node>>(helpers.length + 1);
        URL[] uRLArray = fileList;
        int n = 0;
        while (n < uRLArray.length) {
            URL url = uRLArray[n];
            if (URLFileSystem.hasSuffix((URL)url, (String)".java")) {
                try {
                    Node node = NodeFactory.findOrCreate((URL)url);
                    JProjectUtil.store(node, map, JAVA_NODE_KEY);
                }
                catch (Exception e) {}
            } else {
                SourceRootHelper[] sourceRootHelperArray = helpers;
                int n2 = 0;
                while (n2 < sourceRootHelperArray.length) {
                    SourceRootHelper nextHelper = sourceRootHelperArray[n2];
                    if (URLFileSystem.hasSuffix((URL)url, (String)nextHelper.getFileExtension())) {
                        try {
                            Node node = NodeFactory.findOrCreate((Class)nextHelper.getNodeClass(), (URL)url);
                            JProjectUtil.store(node, map, nextHelper.getClass().getName());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return map;
    }

    private static void store(Node node, Map<String, List<Node>> map, String key) {
        List<Object> nodeList;
        if (map.containsKey(key)) {
            nodeList = map.get(key);
        } else {
            nodeList = new ArrayList();
            map.put(key, nodeList);
        }
        nodeList.add(node);
    }

    private static URL[] getDirectories(URL[] directoryList) {
        ArrayList<URL> dirs = new ArrayList<URL>(directoryList.length);
        URL[] uRLArray = directoryList;
        int n = 0;
        while (n < uRLArray.length) {
            URL dir = uRLArray[n];
            if (URLFileSystem.isDirectory((URL)dir)) {
                dirs.add(dir);
            }
            ++n;
        }
        URL[] urls = new URL[dirs.size()];
        dirs.toArray(urls);
        return urls;
    }

    static URL determineSourceRoot(JavaSourceNode node, boolean showError, boolean[] errorStatus) {
        URL nodeURL = node.getURL();
        URL parentURL = URLFileSystem.getParent((URL)nodeURL);
        String pack = node.getPackage();
        if (ModelUtil.hasLength((String)pack)) {
            pack = pack.replace('.', '/');
            pack = pack.concat("/");
        }
        URL srcPathURL = parentURL;
        if (ModelUtil.hasLength((String)pack) && (srcPathURL = URLFileSystem.getBaseParent((URL)parentURL, (String)pack)).equals(parentURL)) {
            errorStatus[0] = true;
            if (showError) {
                String msg = JProjectArb.format(25, URLFileSystem.getPlatformPathName((URL)node.getURL()));
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)msg, (String)JProjectArb.getString(51), null);
            }
        }
        return srcPathURL;
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ Object[] v$libraries;
        private final /* synthetic */ boolean v$add;
        private final /* synthetic */ Project v$project;

        public void run() {
            int i = 0;
            while (i < this.v$libraries.length) {
                if (this.v$libraries[i] != null) {
                    if (this.v$add) {
                        JProjectLibraries.getInstance((PropertyStorage)this.v$project).addLibrary(this.v$libraries[i]);
                    } else {
                        JProjectLibraries.getInstance((PropertyStorage)this.v$project).removeLibrary(this.v$libraries[i]);
                    }
                }
                ++i;
            }
        }

        public 1(Object[] objectArray, boolean bl, Project project) {
            this.v$project = project;
            this.v$add = bl;
            this.v$libraries = objectArray;
        }
    }
}

