/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ListWrapper;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.model.JLibraryModel;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.library.JDKPanel;
import oracle.jdevimpl.library.LibrariesPanel;
import oracle.jdevimpl.library.LibraryArb;
import oracle.jdevimpl.library.LibraryEditPanel;
import oracle.jdevimpl.library.LibraryPanel;

public class JProjectLibrariesPanel
extends ProjectSettingsTraversablePanel {
    private static final LocalChangeListener LISTENER = new LocalChangeListener(null);
    private static final LocalChangeListener2 LISTENER2 = new LocalChangeListener2(null);
    private static final String[] COLUMN_NAMES = new String[]{"  " + ControlsArb.getString(58) + "  ", ControlsArb.getString(21)};
    private static final String[] PROPERTYKEYS = new String[]{"jdkReference", "libraryReferences", "internalDefinitions", "exportedReferences"};
    private static URL DEF_DIR = URLFactory.newDirURL((String)Ide.getWorkDirectory());
    private GridBagLayout mainLayout;
    private JLabel jdkPrompt;
    private JTextField jdkField;
    private JLabel libsPrompt;
    private JScrollPane libsScrollPane;
    private LibraryTableModel tableModel;
    private JTable libTable;
    private JButton editJDKButton;
    private JButton addPathButton;
    private JButton addLibButton;
    private JButton editLibButton;
    private JButton removeLibButton;
    private JButton shareLibButton;
    private JButton upButton;
    private JButton downButton;
    private LibraryList[] libLists;
    private JProjectLibraryList prjLibList;
    private JProjectLibraries projectLibraries;
    private ButtonHandler buttonHandler;
    private ListHandler listHandler;

    private void $init$() {
        this.mainLayout = new GridBagLayout();
        this.jdkPrompt = new JLabel();
        this.jdkField = new JTextField();
        this.libsPrompt = new JLabel();
        this.libsScrollPane = new JScrollPane();
        this.tableModel = new LibraryTableModel(COLUMN_NAMES, 0, null);
        this.libTable = new JTable(this.tableModel);
        this.editJDKButton = new JButton();
        this.addPathButton = new JButton();
        this.addLibButton = new JButton();
        this.editLibButton = new JButton();
        this.removeLibButton = new JButton();
        this.shareLibButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.buttonHandler = new ButtonHandler(null);
        this.listHandler = new ListHandler(null);
    }

    public JProjectLibrariesPanel() {
        this.$init$();
        try {
            TableColumnModel model = this.libTable.getColumnModel();
            JTableHeader header = this.libTable.getTableHeader();
            header.setReorderingAllowed(false);
            TableColumn column = model.getColumn(0);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setHorizontalAlignment(0);
            column.setCellEditor(new DefaultCellEditor(jCheckBox));
            column.setCellRenderer(new BooleanCellRenderer());
            column.setHeaderRenderer(header.getDefaultRenderer());
            column.sizeWidthToFit();
            column = model.getColumn(1);
            column.setCellRenderer(new LibraryCellRenderer(null));
            this.setHelpID("f1_idedprojsetlibrariesdpp_html");
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.jdkField.setEnabled(false);
        this.jdkField.setEditable(false);
        this.editJDKButton.addActionListener(this.buttonHandler);
        this.libTable.setColumnSelectionAllowed(false);
        this.libTable.setAutoResizeMode(3);
        this.libTable.getSelectionModel().addListSelectionListener(this.listHandler);
        this.libTable.addKeyListener(this.listHandler);
        this.addPathButton.addActionListener(this.buttonHandler);
        this.addLibButton.addActionListener(this.buttonHandler);
        this.editLibButton.addActionListener(this.buttonHandler);
        this.removeLibButton.addActionListener(this.buttonHandler);
        this.shareLibButton.addActionListener(this.buttonHandler);
        this.upButton.addActionListener(this.buttonHandler);
        this.downButton.addActionListener(this.buttonHandler);
        this.libsScrollPane.getViewport().add((Component)this.libTable, null);
        this.libsScrollPane.getViewport().setBackground(this.libTable.getBackground());
        this.add(this.jdkPrompt, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(this.jdkField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.libsPrompt, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add(this.libsScrollPane, new GridBagConstraints(0, 3, 1, 9, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.editJDKButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.addLibButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.addPathButton, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.removeLibButton, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.editLibButton, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.shareLibButton, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 10, 0), 0, 0));
        this.add(this.upButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add(this.downButton, new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 12, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.jdkPrompt, (Component)this.editJDKButton, (String)JProjectArb.getString(33));
        ResourceUtils.resButton((AbstractButton)this.editJDKButton, (String)ControlsArb.getString(70));
        ResourceUtils.resLabel((JLabel)this.libsPrompt, (Component)this.libTable, (String)ControlsArb.getString(55));
        ResourceUtils.resButton((AbstractButton)this.addPathButton, (String)ControlsArb.getString(28));
        ResourceUtils.resButton((AbstractButton)this.addLibButton, (String)ControlsArb.getString(17));
        ResourceUtils.resButton((AbstractButton)this.editLibButton, (String)ControlsArb.getString(0));
        ResourceUtils.resButton((AbstractButton)this.removeLibButton, (String)ControlsArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.shareLibButton, (String)ControlsArb.getString(71));
        ResourceUtils.resButton((AbstractButton)this.upButton, (String)ControlsArb.getString(29));
        ResourceUtils.resButton((AbstractButton)this.downButton, (String)ControlsArb.getString(34));
    }

    public String getDataKey() {
        return "oracle.jdevimpl.config.JProjectLibraries";
    }

    public String[] getPropertyKeys() {
        return PROPERTYKEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(tc);
        this.reload();
        this.listHandler.valueChanged(null);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this.projectLibraries = JProjectLibrariesPanel.getJProjectLibraries(tc);
        this.commit();
    }

    public void hideShareButton() {
        if (this.shareLibButton.getParent() != null) {
            this.remove(this.shareLibButton);
        }
    }

    private static JProjectLibraries getJProjectLibraries(TraversableContext tc) {
        if (tc.getWizardCallbacks() != null) {
            return (JProjectLibraries)((Object)tc.find("oracle.jdevimpl.config.JProjectLibraries"));
        }
        PropertyStorage propertyData = JProjectLibrariesPanel.getPropertyData((Namespace)tc);
        return JProjectLibraries.getInstance(propertyData);
    }

    protected Component getDefaultFocusComponent() {
        return this.addLibButton;
    }

    private void reload() {
        LibraryList[] builtInLists = JLibraryManager.getAllLibraryLists();
        this.prjLibList = this.projectLibraries.getProjectLibraryList();
        this.libLists = new LibraryList[builtInLists.length + 1];
        System.arraycopy(builtInLists, 0, this.libLists, 0, builtInLists.length);
        this.libLists[this.libLists.length - 1] = this.prjLibList;
        JDK jdk = this.projectLibraries.getJDK();
        if (jdk != null) {
            this.jdkField.setText(jdk.toString());
        }
        this.tableModel.setRowCount(0);
        JLibrary[] libs = this.projectLibraries.getLibraries();
        JLibrary[] exps = this.projectLibraries.getExports();
        if (libs != null) {
            int i = 0;
            while (i < libs.length) {
                block6: {
                    if (exps != null) {
                        int j = 0;
                        while (j < exps.length) {
                            if (exps[j].equals(libs[i])) {
                                this.tableModel.addRow(new Object[]{Boolean.TRUE, libs[i]});
                                break block6;
                            }
                            ++j;
                        }
                    }
                    this.tableModel.addRow(new Object[]{Boolean.FALSE, libs[i]});
                }
                ++i;
            }
        }
    }

    private void commit() throws TraversalException {
        ArrayList<JLibrary> libs = new ArrayList<JLibrary>();
        ArrayList<JLibrary> exps = new ArrayList<JLibrary>();
        int count = this.tableModel.getRowCount();
        int i = 0;
        while (i < count) {
            boolean exported = (Boolean)this.tableModel.getValueAt(i, 0);
            JLibrary lib = (JLibrary)this.tableModel.getValueAt(i, 1);
            if (exported) {
                exps.add(lib);
            }
            libs.add(lib);
            ++i;
        }
        JLibrary[] libraries = new JLibrary[exps.size()];
        exps.toArray(libraries);
        this.projectLibraries.setExports(libraries);
        libraries = new JLibrary[libs.size()];
        libs.toArray(libraries);
        this.projectLibraries.setLibraries(libraries);
    }

    private void syncProjectLibraries(JProjectLibraryList originals) {
        List libs = originals != null ? originals.getLibraryList() : null;
        Iterator i = libs != null ? libs.iterator() : null;
        JProjectLibraryList libList = this.projectLibraries.getProjectLibraryList();
        if (i != null && libList != null) {
            while (i.hasNext()) {
                int row;
                JLibrary lib = (JLibrary)i.next();
                if (libList.findLibrary(lib.getID()) != null || (row = this.findRow(lib)) < 0) continue;
                this.tableModel.removeRow(row);
            }
        }
        libs = libList != null ? libList.getLibraryList() : null;
        Iterator iterator = i = libs != null ? libs.iterator() : null;
        if (i != null && originals != null) {
            while (i.hasNext()) {
                int row;
                JLibrary lib = (JLibrary)i.next();
                if (originals.findLibrary(lib.getID()) != null || (row = this.findRow(lib)) >= 0) continue;
                this.tableModel.addRow(new Object[]{Boolean.TRUE, lib});
            }
        }
    }

    private int findRow(Library lib) {
        Object id;
        Object object = id = lib != null ? lib.getID() : null;
        if (id != null) {
            int count = this.libTable.getRowCount();
            int i = 0;
            while (i < count) {
                if (((Library)this.libTable.getValueAt(i, 1)).equivalent(lib)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private void deleteSelection() {
        int count;
        int[] rows = this.libTable.getSelectedRows();
        if (rows != null) {
            int i = 0;
            while (i < rows.length) {
                int j = i + 1;
                while (j < rows.length) {
                    if (rows[j] < rows[i]) {
                        int temp = rows[i];
                        rows[i] = rows[j];
                        rows[j] = temp;
                    }
                    ++j;
                }
                ++i;
            }
            int i2 = rows.length - 1;
            while (i2 >= 0) {
                this.prjLibList.remove((Library)this.libTable.getValueAt(rows[i2], 1));
                this.tableModel.removeRow(rows[i2]);
                --i2;
            }
        }
        if ((count = this.libTable.getRowCount()) != 0) {
            int lastDeletedRow = rows[rows.length - 1];
            int row = count > lastDeletedRow ? lastDeletedRow : count - 1;
            this.selectRow(row);
        }
    }

    private void selectRow(int row) {
        SwingUtilities.invokeLater(new 1(this, row));
    }

    private void selectRows(Library[] elems) {
        SwingUtilities.invokeLater(new 2(this, elems));
    }

    static JProjectLibraryList ra$prjLibList(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.prjLibList;
    }

    static JButton ra$editJDKButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.editJDKButton;
    }

    static JProjectLibraries ra$projectLibraries(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.projectLibraries;
    }

    static LibraryList[] ra$libLists(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.libLists;
    }

    static LocalChangeListener ra$LISTENER() {
        return LISTENER;
    }

    static void mav$commit(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.commit();
    }

    static void mav$reload(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.reload();
    }

    static JButton ra$addPathButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.addPathButton;
    }

    static URL ra$DEF_DIR() {
        return DEF_DIR;
    }

    static LibraryTableModel ra$tableModel(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.tableModel;
    }

    static void wa$DEF_DIR(URL uRL) {
        DEF_DIR = uRL;
    }

    static void mav$selectRows(JProjectLibrariesPanel jProjectLibrariesPanel, Library[] libraryArray) {
        jProjectLibrariesPanel.selectRows(libraryArray);
    }

    static JButton ra$addLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.addLibButton;
    }

    static int mav$findRow(JProjectLibrariesPanel jProjectLibrariesPanel, Library library) {
        return jProjectLibrariesPanel.findRow(library);
    }

    static void mav$syncProjectLibraries(JProjectLibrariesPanel jProjectLibrariesPanel, JProjectLibraryList jProjectLibraryList) {
        jProjectLibrariesPanel.syncProjectLibraries(jProjectLibraryList);
    }

    static JButton ra$editLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.editLibButton;
    }

    static JTable ra$libTable(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.libTable;
    }

    static LocalChangeListener2 ra$LISTENER2() {
        return LISTENER2;
    }

    static void mav$selectRow(JProjectLibrariesPanel jProjectLibrariesPanel, int n) {
        jProjectLibrariesPanel.selectRow(n);
    }

    static JButton ra$removeLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.removeLibButton;
    }

    static void mav$deleteSelection(JProjectLibrariesPanel jProjectLibrariesPanel) {
        jProjectLibrariesPanel.deleteSelection();
    }

    static JButton ra$shareLibButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.shareLibButton;
    }

    static JButton ra$upButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.upButton;
    }

    static ListHandler ra$listHandler(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.listHandler;
    }

    static JButton ra$downButton(JProjectLibrariesPanel jProjectLibrariesPanel) {
        return jProjectLibrariesPanel.downButton;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ int v$row;
        final /* synthetic */ JProjectLibrariesPanel this$0;

        public void run() {
            JProjectLibrariesPanel.ra$libTable(this.this$0).setRowSelectionInterval(this.v$row, this.v$row);
        }

        public 1(JProjectLibrariesPanel jProjectLibrariesPanel, int n) {
            this.v$row = n;
            this.this$0 = jProjectLibrariesPanel;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ Library[] v$elems;
        final /* synthetic */ JProjectLibrariesPanel this$0;

        public void run() {
            if (this.v$elems == null) {
                return;
            }
            JProjectLibrariesPanel.ra$libTable(this.this$0).clearSelection();
            int i = 0;
            while (i < this.v$elems.length) {
                int row = JProjectLibrariesPanel.mav$findRow(this.this$0, this.v$elems[i]);
                if (row >= 0) {
                    JProjectLibrariesPanel.ra$libTable(this.this$0).addRowSelectionInterval(row, row);
                }
                ++i;
            }
            JProjectLibrariesPanel.ra$libTable(this.this$0).requestFocus();
        }

        public 2(JProjectLibrariesPanel jProjectLibrariesPanel, Library[] libraryArray) {
            this.v$elems = libraryArray;
            this.this$0 = jProjectLibrariesPanel;
        }
    }

    private final class ButtonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            int row;
            Object source = e.getSource();
            if (source == JProjectLibrariesPanel.ra$editJDKButton(JProjectLibrariesPanel.this)) {
                JDK jdk = JProjectLibrariesPanel.ra$projectLibraries(JProjectLibrariesPanel.this).getJDK();
                JDKPanel panel = new JDKPanel();
                ListWrapper[] copies = new ListWrapper[JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length];
                boolean jdkInList = false;
                int i = 0;
                while (i < JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length) {
                    copies[i] = new ListWrapper(JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this)[i]);
                    if (!jdkInList) {
                        boolean bl = jdkInList = copies[i].findJDK(jdk.getID()) != null;
                    }
                    if (!jdkInList && JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this)[i] instanceof JProjectLibraryList) {
                        copies[i].addJDK(jdk.getName(), jdk.getJavaExecutable());
                    }
                    ++i;
                }
                panel.initPanel(copies, jdk);
                panel.setSelectionMode(1);
                LocalChangeListener.wa$_panel(JProjectLibrariesPanel.ra$LISTENER(), panel);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(40), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER())) {
                    copies = panel.getLibraryLists();
                    int i2 = 0;
                    while (i2 < copies.length) {
                        copies[i2].commit(copies[i2].getWrappedList() != JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this));
                        ++i2;
                    }
                    Library[] sel = panel.getSelection();
                    if (sel != null && sel.length > 0) {
                        jdk = (JDK)sel[0];
                    }
                    JProjectLibrariesPanel.ra$projectLibraries(JProjectLibrariesPanel.this).setJDK(jdk);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                }
            } else if (source == JProjectLibrariesPanel.ra$addPathButton(JProjectLibrariesPanel.this)) {
                URLChooser chooser = DialogUtil.newURLChooser((URL)JProjectLibrariesPanel.ra$DEF_DIR());
                chooser.setSelectionMode(2);
                chooser.setSelectionScope(1);
                chooser.setShowJarsAsDirs(true);
                int result = chooser.showOpenDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(3));
                if (result == 0) {
                    URL[] paths = chooser.getSelectedURLs();
                    int n = paths.length;
                    int i = 0;
                    while (i < n) {
                        URL url = paths[i];
                        String urlSuffix = URLFileSystem.getSuffix((URL)url);
                        if ((urlSuffix.equals(".jar") || urlSuffix.equals(".zip")) && URLFileSystem.exists((URL)url) && !URLFileSystem.isDirectory((URL)url)) {
                            paths[i] = URLFactory.newJarURL((URL)url, (String)"");
                        }
                        ++i;
                    }
                    ArrayList<JLibrary> newLibs = new ArrayList<JLibrary>();
                    int i3 = 0;
                    while (i3 < n) {
                        String name = JProjectUtil.getLibraryNameFromPath(paths[i3]);
                        JLibrary lib = JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).addLibrary(name);
                        if (lib != null) {
                            lib.setClassPath(new URLPath(paths[i3]));
                            lib.setDeployedByDefault(Boolean.TRUE);
                            lib.setLocked(true);
                            JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).addRow(new Object[]{Boolean.TRUE, lib});
                            newLibs.add(lib);
                            JProjectLibrariesPanel.wa$DEF_DIR(URLFileSystem.getParent((URL)paths[i3]));
                        }
                        ++i3;
                    }
                    if (newLibs.size() > 0) {
                        Library[] elems = new JLibrary[newLibs.size()];
                        newLibs.toArray(elems);
                        JProjectLibrariesPanel.mav$selectRows(JProjectLibrariesPanel.this, elems);
                    }
                }
            } else if (source == JProjectLibrariesPanel.ra$addLibButton(JProjectLibrariesPanel.this)) {
                LibrariesPanel panel = new LibrariesPanel();
                panel.makeDoubleClickCloseDialog();
                ListWrapper[] copies = new ListWrapper[JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this).length];
                int i = 0;
                while (i < copies.length) {
                    copies[i] = new ListWrapper(JProjectLibrariesPanel.ra$libLists(JProjectLibrariesPanel.this)[i]);
                    ++i;
                }
                panel.setSplit(false);
                int numExistingLibs = JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).getRowCount();
                if (numExistingLibs > 0) {
                    ArrayList<JLibrary> exLibs = new ArrayList<JLibrary>(numExistingLibs);
                    int i4 = 0;
                    while (i4 < numExistingLibs) {
                        JLibrary existingLib = (JLibrary)JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).getValueAt(i4, 1);
                        exLibs.add(existingLib);
                        ++i4;
                    }
                    panel.setExistingLibraries(exLibs);
                }
                panel.initPanel(copies);
                LocalChangeListener.wa$_panel(JProjectLibrariesPanel.ra$LISTENER(), panel);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(49), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER())) {
                    HashStructure hash = HashStructure.newInstance();
                    JProjectLibraryList originals = new JProjectLibraryList(hash);
                    JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).copyTo(originals);
                    copies = panel.getLibraryLists();
                    int i5 = 0;
                    while (i5 < copies.length) {
                        copies[i5].commit(copies[i5].getWrappedList() != JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this));
                        ++i5;
                    }
                    Library[] elems = panel.getSelection();
                    if (elems != null) {
                        int i6 = 0;
                        while (i6 < elems.length) {
                            if (JProjectLibrariesPanel.mav$findRow(JProjectLibrariesPanel.this, elems[i6]) < 0) {
                                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).addRow(new Object[]{Boolean.TRUE, elems[i6]});
                            }
                            ++i6;
                        }
                    }
                    JProjectLibrariesPanel.mav$syncProjectLibraries(JProjectLibrariesPanel.this, originals);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                    JProjectLibrariesPanel.mav$selectRows(JProjectLibrariesPanel.this, elems);
                }
            } else if (source == JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this)) {
                int row2 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary lib = row2 >= 0 ? (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row2, 1) : null;
                LibraryList wrapper = null;
                if (lib instanceof JProjectLibraries.UnresolvedLibrary) {
                    Object id = lib.getID();
                    JLibraryList list = JLibraryManager.getUserLibraries();
                    if (id instanceof URL) {
                        URL listURL = URLFileSystem.getParent((URL)((URL)id));
                        list = JLibraryManager.addLibraryList(listURL);
                        if (((String)(id = URLFileSystem.getFileName((URL)((URL)id)))).endsWith(".library")) {
                            id = ((String)id).substring(0, ((String)id).length() - ".library".length());
                        }
                    }
                    wrapper = new ListWrapper(list);
                    lib = ((ListWrapper)wrapper).addLibrary(id.toString());
                }
                LibraryEditPanel panel = new LibraryEditPanel(lib);
                LibraryList list = wrapper != null ? wrapper : this.findOwningList(lib);
                panel.setListsVisible(false);
                panel.setLibraryList(list);
                JProjectLibrariesPanel.ra$LISTENER2().initialize(panel, lib, list);
                if (OnePageWizardDialogFactory.runDialog((Component)((Object)JProjectLibrariesPanel.this), (Component)panel, null, (String)ControlsArb.getString(31), (int)7, (VetoableChangeListener)JProjectLibrariesPanel.ra$LISTENER2())) {
                    JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).setValueAt(JProjectLibrariesPanel.ra$LISTENER2().getLibrary(), row2, 1);
                    try {
                        JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                    }
                    catch (Exception x) {
                        // empty catch block
                    }
                    JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                    if (row2 >= 0) {
                        JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, row2);
                    }
                }
            } else if (source == JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this)) {
                JProjectLibrariesPanel.mav$deleteSelection(JProjectLibrariesPanel.this);
            } else if (source == JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this)) {
                JLibrary lib;
                int row3 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary jLibrary = lib = row3 >= 0 ? (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row3, 1) : null;
                if (lib != null) {
                    URL url;
                    URLChooser chooser = DialogUtil.newURLChooser((URL)JProjectLibrariesPanel.ra$DEF_DIR());
                    chooser.setSelectionMode(0);
                    chooser.setSelectionScope(0);
                    chooser.setShowJarsAsDirs(false);
                    chooser.clearChooseableURLFilters();
                    chooser.setURLFilter(JLibraryList.LIB_FILTER);
                    int result = chooser.showSaveDialog((Component)((Object)JProjectLibrariesPanel.this), ControlsArb.getString(1));
                    if (result == 0 && (url = chooser.getSelectedURL()) != null) {
                        JLibrary newLib;
                        JLibraryList list;
                        URL parent;
                        if (URLFileSystem.exists((URL)(url = URLFileSystem.ensureSuffix((URL)url, (String)".library")))) {
                            if (MessageDialog.confirm((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)22, (Object[])new String[]{ComponentArb.getString((int)26), URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)18), null, (boolean)true)) {
                                if (URLFileSystem.isReadOnly((URL)url)) {
                                    MessageDialog.error((Component)((Object)JProjectLibrariesPanel.this), (Object)ComponentArb.format((int)19, (Object[])new String[]{URLFileSystem.getPlatformPathName((URL)url)}), (String)ComponentArb.getString((int)32), null);
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                        if ((parent = URLFileSystem.getParent((URL)url)) != null && (list = JLibraryManager.addLibraryList(parent)) != null && (newLib = list.addLibrary(null, url)) != null) {
                            newLib.setClassPath(lib.getClassPath());
                            newLib.setSourcePath(lib.getSourcePath());
                            newLib.setDocPath(lib.getDocPath());
                            newLib.setDeployedByDefault(lib.getDeployedByDefault());
                            JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).remove(lib);
                            JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).setValueAt(newLib, row3, 1);
                            try {
                                JProjectLibrariesPanel.mav$commit(JProjectLibrariesPanel.this);
                            }
                            catch (Exception x) {
                                // empty catch block
                            }
                            JProjectLibrariesPanel.mav$reload(JProjectLibrariesPanel.this);
                            if (lib != null && (row3 = JProjectLibrariesPanel.mav$findRow(JProjectLibrariesPanel.this, newLib)) >= 0) {
                                JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, row3);
                            }
                        }
                    }
                }
            } else if (source == JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this)) {
                int row4 = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                if (row4 > 0) {
                    Object exported = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row4, 0);
                    Object lib = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row4, 1);
                    JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectionModel().removeListSelectionListener(JProjectLibrariesPanel.ra$listHandler(JProjectLibrariesPanel.this));
                    JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).removeRow(row4);
                    JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).insertRow(--row4, new Object[]{exported, lib});
                    JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectionModel().addListSelectionListener(JProjectLibrariesPanel.ra$listHandler(JProjectLibrariesPanel.this));
                    JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, row4);
                }
            } else if (source == JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this) && (row = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow()) < JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getRowCount() - 1) {
                Object exported = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row, 0);
                Object lib = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row, 1);
                JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectionModel().removeListSelectionListener(JProjectLibrariesPanel.ra$listHandler(JProjectLibrariesPanel.this));
                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).removeRow(row);
                JProjectLibrariesPanel.ra$tableModel(JProjectLibrariesPanel.this).insertRow(++row, new Object[]{exported, lib});
                JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectionModel().addListSelectionListener(JProjectLibrariesPanel.ra$listHandler(JProjectLibrariesPanel.this));
                JProjectLibrariesPanel.mav$selectRow(JProjectLibrariesPanel.this, row);
            }
        }

        private LibraryList findOwningList(JLibrary lib) {
            Object id = lib.getID();
            if (JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this).findLibrary(id) != null) {
                return JProjectLibrariesPanel.ra$prjLibList(JProjectLibrariesPanel.this);
            }
            LibraryList[] lists = JLibraryManager.getAllLibraryLists();
            int i = 0;
            while (i < lists.length) {
                if (lists[i].findLibrary(id) != null) {
                    if (lists[i] instanceof JLibraryList && id instanceof URL) {
                        URL listURL = URLFileSystem.getParent((URL)((URL)id));
                        return JLibraryManager.addLibraryList(listURL);
                    }
                    return lists[i];
                }
                ++i;
            }
            return null;
        }

        private ButtonHandler() {
        }

        ButtonHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ListHandler
    extends KeyAdapter
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
            if (e != null && e.getValueIsAdjusting()) {
                return;
            }
            int[] rows = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRows();
            if (rows == null || rows.length != 1) {
                JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this).setEnabled(false);
                JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).setEnabled(rows != null && rows.length > 0);
            } else {
                int row = JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getSelectedRow();
                JLibrary lib = (JLibrary)JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getValueAt(row, 1);
                if (lib != null && !lib.isLocked()) {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this), (String)ControlsArb.getString(0));
                } else {
                    ResourceUtils.resButton((AbstractButton)JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this), (String)ControlsArb.getString(30));
                }
                JProjectLibrariesPanel.ra$editLibButton(JProjectLibrariesPanel.this).setEnabled(true);
                JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).setEnabled(true);
                JProjectLibrariesPanel.ra$shareLibButton(JProjectLibrariesPanel.this).setEnabled(lib instanceof HashStructureAdapter);
                JProjectLibrariesPanel.ra$upButton(JProjectLibrariesPanel.this).setEnabled(row > 0);
                JProjectLibrariesPanel.ra$downButton(JProjectLibrariesPanel.this).setEnabled(row < JProjectLibrariesPanel.ra$libTable(JProjectLibrariesPanel.this).getRowCount() - 1);
            }
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\u007f') {
                if (JProjectLibrariesPanel.ra$removeLibButton(JProjectLibrariesPanel.this).isEnabled()) {
                    JProjectLibrariesPanel.mav$deleteSelection(JProjectLibrariesPanel.this);
                }
                e.consume();
            }
        }

        private ListHandler() {
        }

        ListHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class LibraryCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setDisabledIcon(null);
            this.setIcon(this.getIcon(value));
            if (value instanceof Library) {
                String libTooltip = ((Library)value).getToolTipText();
                if (!ModelUtil.hasLength((String)libTooltip)) {
                    libTooltip = LibraryArb.getString(18);
                    this.setText(libTooltip);
                }
                this.setToolTipText(libTooltip);
                this.setText(((Library)value).getName());
            }
            return this;
        }

        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        private Icon getIcon(Object value) {
            if (value instanceof JLibrary) {
                Library lib = (Library)value;
                URLPath path = lib.getClassPath();
                if (path.size() == 0 && (path = lib.getSourcePath()).size() == 0 && (path = lib.getDocPath()).size() == 0) {
                    super.setForeground(Color.red);
                    return LibraryArb.getIcon(25);
                }
                return lib.getIcon();
            }
            return null;
        }

        private LibraryCellRenderer() {
        }

        LibraryCellRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class BooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        private Color unselectedForeground;
        private Color unselectedBackground;

        BooleanCellRenderer() {
            this.setOpaque(true);
            this.setBorderPainted(true);
            this.setBorder(noFocusBorder);
            this.setHorizontalAlignment(0);
        }

        public void setForeground(Color c) {
            super.setForeground(c);
            this.unselectedForeground = c;
        }

        public void setBackground(Color c) {
            super.setBackground(c);
            this.unselectedBackground = c;
        }

        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(value);
            return this;
        }

        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        protected void setValue(Object value) {
            boolean selected = value instanceof Boolean ? (Boolean)value : false;
            this.setSelected(selected);
        }
    }

    private static final class LocalChangeListener
    implements VetoableChangeListener {
        private LibraryPanel _panel;
        private boolean _vetoThrown;

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            if (!this._panel.commitChanges()) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }

        private LocalChangeListener() {
        }

        LocalChangeListener(1 var1_1) {
            this();
        }

        static void wa$_panel(LocalChangeListener localChangeListener, LibraryPanel libraryPanel) {
            localChangeListener._panel = libraryPanel;
        }

        public final class 1 {
        }
    }

    private static final class LocalChangeListener2
    implements VetoableChangeListener {
        private boolean _vetoThrown;
        private LibraryEditPanel _newPanel;
        private Library _lib;
        private LibraryList _list;

        public void initialize(LibraryEditPanel panel, Library lib, LibraryList list) {
            this._newPanel = panel;
            this._lib = lib;
            this._list = list;
        }

        public Library getLibrary() {
            return this._lib;
        }

        public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
            if (this._vetoThrown) {
                this._vetoThrown = false;
                return;
            }
            try {
                if (!(this._list instanceof MutableLibraryList)) {
                    return;
                }
                JLibraryModel model = new JLibraryModel((JLibrary)this._lib, (MutableLibraryList)this._list, (Component)this._newPanel);
                model.setName(this._newPanel.getLibraryName());
                model.setClassPath(this._newPanel.getClassPath());
                model.setSourcePath(this._newPanel.getSourcePath());
                model.setDocPath(this._newPanel.getDocPath());
                model.setDeployedByDefault(this._newPanel.isDeployByDefault());
                this._lib = model.commit();
                if (this._list instanceof ListWrapper) {
                    ((ListWrapper)this._list).commit(true);
                }
            }
            catch (Exception x) {
                this._vetoThrown = true;
                throw new PropertyVetoException(null, e);
            }
        }

        private LocalChangeListener2() {
        }

        LocalChangeListener2(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class LibraryTableModel
    extends DefaultTableModel {
        private LibraryTableModel(String[] columnNames, int rows) {
            super(columnNames, rows);
        }

        public boolean isCellEditable(int row, int column) {
            return column == 0 && row >= 0 && row < this.getRowCount();
        }

        LibraryTableModel(String[] stringArray, int n, 1 var3_3) {
            this(stringArray, n);
        }

        public final class 1 {
        }
    }
}

