/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.AbstractDerivedLibrary;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public final class ProjectLibrary
extends AbstractDerivedLibrary {
    public URLPath getClassPath() throws TransientMarker {
        return this.getClassPath(false);
    }

    public URLPath getClassPath(boolean onlyDeployLibs) throws TransientMarker {
        JProjectLibraries jProjectLibraries;
        JLibrary[] exports;
        URLPath urlPath = new URLPath();
        URL outputDir = JavaProject.getInstance(this.getProject()).getOutputDirectory();
        urlPath.add(outputDir);
        urlPath.add(JProjectPaths.getInstance((PropertyStorage)this.getProject()).getAdditionalClassPath());
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance(this.getProject());
        if (moduleConfig != null) {
            urlPath.add(moduleConfig.getClassPath());
        }
        if ((exports = (jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)this.getProject())).getExports()) != null) {
            int i = 0;
            while (i < exports.length) {
                if (!onlyDeployLibs || exports[i].getDeployedByDefault().booleanValue()) {
                    urlPath.add(exports[i].getClassPath());
                }
                ++i;
            }
        }
        return urlPath;
    }

    public URLPath getSourcePath() throws TransientMarker {
        URLPath urlPath = new URLPath(PathsConfiguration.getInstance(this.getProject()).getProjectSourcePath());
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)this.getProject());
        JLibrary[] exports = jProjectLibraries.getExports();
        if (exports != null) {
            int i = 0;
            while (i < exports.length) {
                urlPath.add(exports[i].getSourcePath());
                ++i;
            }
        }
        return urlPath;
    }

    public URLPath getDocPath() throws TransientMarker {
        URLPath urlPath = new URLPath();
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)this.getProject());
        JLibrary[] exports = jProjectLibraries.getExports();
        if (exports != null) {
            int i = 0;
            while (i < exports.length) {
                urlPath.add(exports[i].getDocPath());
                ++i;
            }
        }
        return urlPath;
    }

    public Iterator getDependencies() {
        return DependencyConfiguration.getInstance((Project)this.getProject()).getDependencies();
    }

    public void update(Object observed, UpdateMessage change) {
        if (!this.isPropertyChange(change)) {
            return;
        }
        ArrayList pceList = new ArrayList();
        this.checkPropertyChange("classPath", "classPath", change, pceList);
        this.checkPropertyChange("docPath", "docPath", change, pceList);
        this.checkPropertyChange("sourcePath", "sourcePath", change, pceList);
        this.firePropertiesChanged(pceList);
    }

    public Object copyTo(Object object) {
        ProjectLibrary copy = object != null ? (ProjectLibrary)object : new ProjectLibrary();
        this.copyToImpl(copy);
        return copy;
    }

    public Project getProject() {
        return (Project)this.getSource();
    }
}

