/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;

public class ListWrapper
implements MutableLibraryList {
    public static final int LIBRARY_LIST = 0;
    public static final int JDK_LIST = 1;
    public static final int BOTH_LISTS = 2;
    private LibraryList _list;
    private List _initialLibStates;
    private int _initialLibCount;
    private HashMap _masterLibMap;
    private HashMap _redirectLibMap;
    private List _initialJDKStates;
    private int _initialJDKCount;
    private HashMap _masterJDKMap;
    private HashMap _redirectJDKMap;

    public ListWrapper(LibraryList list) {
        this(list, 2);
    }

    public ListWrapper(LibraryList list, int mode) {
        this._list = list;
        if (mode == 0 || mode == 2) {
            this._initialLibStates = this._list.getLibraryList();
            if (this._initialLibStates == null) {
                this._initialLibStates = new ArrayList();
            }
            this._initialLibCount = this._initialLibStates.size();
            this._masterLibMap = new HashMap();
            this._redirectLibMap = new HashMap();
            int i = 0;
            while (i < this._initialLibCount) {
                JLibrary lib = (JLibrary)this._initialLibStates.get(i);
                this._masterLibMap.put(new Integer(i), lib.getID());
                this._redirectLibMap.put(lib.getID(), lib);
                ++i;
            }
        }
        if (mode == 1 || mode == 2) {
            this._initialJDKStates = this._list.getJdkList();
            if (this._initialJDKStates == null) {
                this._initialJDKStates = new ArrayList();
            }
            this._initialJDKCount = this._initialJDKStates.size();
            this._masterJDKMap = new HashMap();
            this._redirectJDKMap = new HashMap();
            int i = 0;
            while (i < this._initialJDKCount) {
                JDK jdk = (JDK)this._initialJDKStates.get(i);
                this._masterJDKMap.put(new Integer(i), jdk.getID());
                this._redirectJDKMap.put(jdk.getID(), jdk);
                ++i;
            }
        }
    }

    public JDK findJDK(Object id) {
        return this._redirectJDKMap != null ? (JDK)this._redirectJDKMap.get(id) : null;
    }

    public JLibrary findLibrary(Object id) {
        return this._redirectLibMap != null ? (JLibrary)this._redirectLibMap.get(id) : null;
    }

    public List getJdkList() {
        if (this._redirectJDKMap != null) {
            ArrayList list = new ArrayList();
            Collection values = this._redirectJDKMap.values();
            list.addAll(values);
            return list;
        }
        return null;
    }

    public List getLibraryList() {
        if (this._redirectLibMap != null) {
            ArrayList list = new ArrayList();
            Collection values = this._redirectLibMap.values();
            list.addAll(values);
            return list;
        }
        return null;
    }

    public String getListName() {
        return this._list != null ? this._list.getListName() : null;
    }

    public boolean isTransient() {
        return this._list != null ? this._list.isTransient() : true;
    }

    public String getShortLabel() {
        return this._list != null ? this._list.getShortLabel() : null;
    }

    public String getLongLabel() {
        return this._list != null ? this._list.getLongLabel() : null;
    }

    public Icon getIcon() {
        return this._list != null ? this._list.getIcon() : null;
    }

    public String getToolTipText() {
        return this._list != null ? this._list.getToolTipText() : null;
    }

    public void setJdkList(List jdks) {
    }

    public void setLibraryList(List libraries) {
    }

    public void setListName(String name) {
    }

    public JDK addJDK(String name, URL exeURL) {
        JDK jdk = null;
        if (this._list instanceof MutableLibraryList && this._redirectJDKMap != null) {
            Object id = ((MutableLibraryList)this._list).createIDFromName(name, true);
            jdk = (JDK)this._redirectJDKMap.get(id);
            if (jdk == null) {
                HashStructure hash = HashStructure.newInstance();
                jdk = new JDKAdapter(hash);
                jdk.setName(name);
                ((JDKAdapter)jdk).setID(id);
                this._initialJDKStates.add(null);
                this._masterJDKMap.put(new Integer(this._initialJDKStates.size() - 1), id);
                this._redirectJDKMap.put(id, jdk);
            } else {
                jdk.setName(name);
            }
            JDKUtil.initJDK(jdk, exeURL);
        }
        return jdk;
    }

    public JLibrary addLibrary(String name) {
        JLibrary lib = null;
        if (this._list instanceof MutableLibraryList && this._redirectLibMap != null) {
            Object id = ((MutableLibraryList)this._list).createIDFromName(name, false);
            lib = (JLibrary)this._redirectLibMap.get(id);
            if (lib == null) {
                HashStructure hash = HashStructure.newInstance();
                lib = new JLibraryAdapter(hash);
                lib.setName(name);
                ((JLibraryAdapter)lib).setIcon(((MutableLibraryList)this._list).getDefaultIcon());
                ((JLibraryAdapter)lib).setID(id);
                this._initialLibStates.add(null);
                this._masterLibMap.put(new Integer(this._initialLibStates.size() - 1), id);
                this._redirectLibMap.put(id, lib);
            } else {
                lib.setName(name);
            }
        }
        return lib;
    }

    public boolean remove(Library library) {
        block8: {
            Object id;
            block7: {
                Iterator i;
                Object object = id = library != null ? library.getID() : null;
                if (id == null) {
                    return false;
                }
                if (!(this._list instanceof MutableLibraryList)) {
                    return false;
                }
                if (!(library instanceof JDK)) break block7;
                if (this._redirectJDKMap == null) break block8;
                Set set = this._masterJDKMap.keySet();
                Iterator iterator = i = set != null ? set.iterator() : null;
                if (i != null) {
                    while (i.hasNext()) {
                        Object masterKey = i.next();
                        if (!id.equals(this._masterJDKMap.get(masterKey))) continue;
                        this._masterJDKMap.put(masterKey, null);
                        this._redirectJDKMap.remove(id);
                        return true;
                    }
                }
                break block8;
            }
            if (library instanceof JLibrary && this._redirectLibMap != null) {
                Iterator i;
                Set set = this._masterLibMap.keySet();
                Iterator iterator = i = set != null ? set.iterator() : null;
                if (i != null) {
                    while (i.hasNext()) {
                        Object masterKey = i.next();
                        if (!id.equals(this._masterLibMap.get(masterKey))) continue;
                        this._masterLibMap.put(masterKey, null);
                        this._redirectLibMap.remove(id);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public Object createIDFromName(String name, boolean isJDK) {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).createIDFromName(name, isJDK) : null;
    }

    public LibraryList getWrappedList() {
        return this._list;
    }

    public void commit(boolean notify) {
        if (this._list instanceof MutableLibraryList) {
            if (this._redirectLibMap != null) {
                this.commit(this._masterLibMap, this._redirectLibMap, this._initialLibStates, this._initialLibCount, notify, false);
            }
            if (this._redirectJDKMap != null) {
                this.commit(this._masterJDKMap, this._redirectJDKMap, this._initialJDKStates, this._initialJDKCount, notify, true);
            }
        }
    }

    public String toString() {
        return this._list.toString();
    }

    private void commit(HashMap masterMap, HashMap redirectMap, List initialStates, int initialCount, boolean notify, boolean isJDK) {
        if (redirectMap != null) {
            MutableLibraryList list = (MutableLibraryList)this._list;
            ArrayList<Object> additions = new ArrayList<Object>();
            ArrayList deletions = new ArrayList();
            ArrayList<Library> modifications = new ArrayList<Library>();
            int size = initialStates.size();
            int i = 0;
            while (i < size) {
                Integer masterKey = new Integer(i);
                Object redirectKey = masterMap.get(masterKey);
                if (i >= initialCount) {
                    if (redirectKey != null) {
                        additions.add(redirectMap.get(redirectKey));
                    }
                } else if (redirectKey == null) {
                    deletions.add(initialStates.get(i));
                } else {
                    Library current;
                    Library original = (Library)initialStates.get(i);
                    if (original != null && !original.equivalent(current = (Library)redirectMap.get(redirectKey))) {
                        original.initFromLibrary(current);
                        modifications.add(original);
                    }
                }
                ++i;
            }
            size = deletions.size();
            if (size > 0) {
                int i2 = 0;
                while (i2 < size) {
                    list.remove((Library)deletions.get(i2));
                    ++i2;
                }
                if (notify) {
                    UpdateMessage.fireChildrenRemoved((Subject)JLibraryManager.getInstance(), deletions);
                }
            }
            if ((size = additions.size()) > 0) {
                int i3 = size - 1;
                while (i3 >= 0) {
                    Library template = (Library)additions.get(i3);
                    Library newLib = null;
                    newLib = isJDK ? list.addJDK(template.getName(), ((JDK)template).getJavaExecutable()) : list.addLibrary(template.getName());
                    if (newLib != null) {
                        newLib.initFromLibrary(template);
                        if (newLib instanceof Node) {
                            try {
                                ((Node)newLib).save();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        additions.set(i3, newLib);
                    } else {
                        additions.remove(i3);
                    }
                    --i3;
                }
                if (notify) {
                    UpdateMessage.fireChildrenAdded((Subject)JLibraryManager.getInstance(), additions);
                }
            }
            if ((size = modifications.size()) > 0) {
                int i4 = size - 1;
                while (i4 >= 0) {
                    Library lib = (Library)modifications.get(i4);
                    if (lib instanceof Node) {
                        try {
                            ((Node)lib).save();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    --i4;
                }
                if (notify) {
                    UpdateMessage.fireStructureChanged((Subject)JLibraryManager.getInstance(), modifications);
                }
            }
        }
    }

    public Icon getDefaultIcon() {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).getDefaultIcon() : null;
    }
}

