/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.ProductInformation;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.ClientSetting;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.model.Dependable;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.IdeSubject;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.library.AddinLibraryList;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryList;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.ProjectDependencyFactory;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.LibraryArb;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JLibraryManager
implements Addin,
ShutdownHook,
Subject,
DependableRecognizer {
    public static final String LEGACY_LIBRARY_FILE = "library.ini";
    public static final String LIBRARY_LIST_FILE = "libraries.xml";
    public static final String LIBRARY_EXTENSION = ".library";
    public static final String JDK_EXTENSION = ".jdk";
    public static final int LIBRARY_ADDED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_ADDED");
    public static final int LIBRARY_REMOVED = UpdateMessage.newMessageID((String)"JLibraryManager.LIBRARY_REMOVED");
    public static final String SETTINGS_KEY = "LibraryManagerOptions";
    private static final HashMap LISTS = new HashMap();
    private static JLibraryManager _instance;
    private static JLibraryList _userLibs;
    private static AddinLibraryList _addinLibs;
    private static IdeSubject _delegate;
    private static HashMap _dependableRegistry;
    private static JDK _defaultJDK;
    private List<DynamicLibraryProvider> _dynamicProviders;

    private void $init$() {
        this._dynamicProviders = Collections.synchronizedList(new ArrayList());
    }

    static {
        _delegate = new IdeSubject();
        _dependableRegistry = new HashMap();
        JLibraryManager.registerDerivedLibrary(Project.class, ProjectLibrary.class);
    }

    public JLibraryManager() throws SingletonClassException {
        this.$init$();
        if (_instance != null) {
            throw new SingletonClassException("oracle.jdeveloper.library.JLibraryManager");
        }
        _instance = this;
    }

    public void registerDynamicLibraryProvider(DynamicLibraryProvider provider) {
        if (provider == null) {
            throw new NullPointerException("provider is null");
        }
        this._dynamicProviders.add(provider);
    }

    public void unregisterDynamicLibraryProvider(DynamicLibraryProvider provider) {
        this._dynamicProviders.remove(provider);
    }

    public Collection<DynamicLibraryProvider> getDynamicLibraryProviders() {
        return Collections.unmodifiableCollection(this._dynamicProviders);
    }

    public static JLibraryManager getInstance() {
        return _instance;
    }

    public static LibraryList[] getAllLibraryLists() {
        ArrayList<LibraryList> lists = new ArrayList<LibraryList>();
        lists.add(JLibraryManager.getAddinLibraries());
        lists.add(JLibraryManager.getUserLibraries());
        Collection values = LISTS.values();
        if (values != null) {
            lists.addAll(LISTS.values());
        }
        return lists.toArray(new LibraryList[lists.size()]);
    }

    public static List getLibraries() {
        LibraryList[] libLists = JLibraryManager.getAllLibraryLists();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < libLists.length) {
            List list = libLists[i].getLibraryList();
            result.addAll(list);
            ++i;
        }
        return result;
    }

    public static List getJDKs() {
        LibraryList[] libLists = JLibraryManager.getAllLibraryLists();
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < libLists.length) {
            List list = libLists[i].getJdkList();
            result.addAll(list);
            ++i;
        }
        return result;
    }

    public static synchronized JDK getDefaultJDK() {
        if (_defaultJDK == null) {
            _defaultJDK = JLibraryManager.findOrCreateDefaultJDK();
        }
        return _defaultJDK;
    }

    public static JLibrary createLibrary(Object id, MutableLibraryList list) {
        JLibrary lib = null;
        if (list != null && list.findLibrary(id) == null) {
            lib = list.addLibrary(null);
        }
        return lib;
    }

    public static JLibrary findLibrary(Object id) {
        JLibrary lib = JLibraryManager.getUserLibraries().findLibrary(id);
        if (lib == null && (lib = JLibraryManager.getAddinLibraries().findLibrary(id)) == null) {
            try {
                URL url = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(id.toString() + LIBRARY_EXTENSION));
                lib = JLibraryManager.getUserLibraries().findLibrary(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return lib;
    }

    public static void removeLibrary(JLibrary lib, MutableLibraryList list) {
        if (lib != null && list != null && list.remove(lib)) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            msg.getRemoveObjects().add(lib);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
    }

    public static JDK createJDK(Object id, URL javaExe, MutableLibraryList list) {
        JDK jdk = null;
        if (javaExe != null && list != null && list.findJDK(id) == null && (jdk = list.addJDK(null, javaExe)) != null) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_ADDED, null);
            msg.getAddObjects().add(jdk);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
        return jdk;
    }

    public static JDK findJDK(Object id) {
        JDK jdk = JLibraryManager.getUserLibraries().findJDK(id);
        if (jdk == null && (jdk = JLibraryManager.getAddinLibraries().findJDK(id)) == null) {
            try {
                URL url = URLFactory.newURL((URL)JLibraryManager.getUserLibraries().getURL(), (String)(id.toString() + JDK_EXTENSION));
                jdk = JLibraryManager.getUserLibraries().findJDK(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jdk;
    }

    public static JDK findJDK(VersionNumber num, JDK[] jdks) {
        JDK previousVer = null;
        JDK nextVer = null;
        JDK result = null;
        if (num != null) {
            int i = 0;
            while (i < jdks.length) {
                VersionNumber jdkVer = jdks[i].getJavaVersion();
                if (jdkVer.equals((Object)num)) {
                    result = jdks[i];
                    break;
                }
                if (jdkVer.isBefore(num, false)) {
                    if (previousVer == null || previousVer.getJavaVersion().isBefore(jdkVer, false)) {
                        previousVer = jdks[i];
                    }
                } else if (nextVer == null || nextVer.getJavaVersion().isAfter(jdkVer, false)) {
                    nextVer = jdks[i];
                }
                ++i;
            }
            if (result == null) {
                result = nextVer != null ? nextVer : previousVer;
            }
        }
        return result;
    }

    public static JDK findJDKMatch(Object id, VersionNumber num) {
        JDK jdk = JLibraryManager.findJDK(id);
        if (jdk == null) {
            List list = JLibraryManager.getJDKs();
            JDK[] jdks = list.toArray(new JDK[list.size()]);
            jdk = JLibraryManager.findJDK(num, jdks);
        }
        return jdk;
    }

    public static void removeJDK(JDK jdk, MutableLibraryList list) {
        if (jdk != null && list != null && list.remove(jdk)) {
            UpdateMessage msg = new UpdateMessage(UpdateMessage.CHILD_REMOVED, null);
            msg.getRemoveObjects().add(jdk);
            JLibraryManager.getInstance().notifyObservers(JLibraryManager.getInstance(), msg);
        }
    }

    public static JLibraryList addLibraryList(URL url) {
        JLibraryList list = null;
        if (url != null && (list = (JLibraryList)LISTS.get(url)) == null) {
            if (url.equals(JLibraryManager.getUserLibraries().getURL())) {
                return JLibraryManager.getUserLibraries();
            }
            list = new JLibraryList(url);
            LISTS.put(url, list);
        }
        return list;
    }

    public static boolean removeLibraryList(LibraryList list) {
        if (list instanceof JLibraryList) {
            return LISTS.remove(((JLibraryList)list).getURL()) != null;
        }
        return false;
    }

    public static synchronized JLibraryList getUserLibraries() {
        ExtensionRegistry er;
        URL dir;
        if (_userLibs == null && (_userLibs = JLibraryManager._createLibraryList(dir = (er = ExtensionRegistry.getExtensionRegistry()).getSystemDirectory(Ide.getProductID()))) != null) {
            _userLibs.setListName(JLibraryList.USER_LIBRARIES);
        }
        return _userLibs;
    }

    public static synchronized AddinLibraryList getAddinLibraries() {
        if (_addinLibs == null) {
            _addinLibs = new AddinLibraryList();
        }
        return _addinLibs;
    }

    public Dependable create(Element source, Folder sourceOwner) throws IllegalAccessException, InstantiationException {
        if (source == null) {
            return null;
        }
        Class factory = JLibraryManager.getDerivedLibraryClass(source);
        if (factory != null) {
            try {
                DerivedLibrary library = (DerivedLibrary)factory.newInstance();
                if (sourceOwner != null) {
                    library.setSourceOwnerURL(((Node)sourceOwner).getURL());
                }
                library.setSourceURL(((Node)source).getURL());
                DerivedLibrary derivedLibrary = library;
                return derivedLibrary;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean recognize(Element source) {
        return JLibraryManager.getDerivedLibraryClass(source) != null;
    }

    public static void registerDerivedLibrary(Class key, Class cls) {
        _dependableRegistry.put(key, cls);
    }

    public static void unregisterDerivedLibrary(Class key) {
        _dependableRegistry.remove(key);
    }

    static void cacheDerivedLibrary(DerivedLibrary library) {
        ProjectDependencyFactory.cache(library);
    }

    static Class getDerivedLibraryClass(Element source) {
        Class<?> dataClass;
        Object data = source != null ? source.getData() : null;
        Class<?> clazz = dataClass = data != null ? data.getClass() : null;
        if (dataClass != null) {
            for (Class key : _dependableRegistry.keySet()) {
                if (!key.isAssignableFrom(dataClass)) continue;
                return (Class)_dependableRegistry.get(key);
            }
        }
        return null;
    }

    public void shutdown() {
        ClientSetting setting = ClientSetting.findOrCreate((String)ProductInformation.getProductID());
        if (setting != null) {
            Iterator i;
            URLPath path = new URLPath();
            Collection values = LISTS.values();
            Iterator iterator = i = values != null ? values.iterator() : null;
            if (i != null) {
                while (i.hasNext()) {
                    JLibraryList list = (JLibraryList)i.next();
                    path.add(list.getURL());
                }
                setting.putData(SETTINGS_KEY, (Copyable)path);
            }
        }
    }

    public boolean canShutdown() {
        return true;
    }

    public void initialize() {
        URL[] urls;
        _defaultJDK = JLibraryManager.findOrCreateDefaultJDK();
        ClientSetting settings = ClientSetting.findOrCreate((String)ProductInformation.getProductID());
        URLPath path = (URLPath)(settings != null ? settings.getData(SETTINGS_KEY) : null);
        if (path != null && (urls = path.getEntries()) != null) {
            int i = 0;
            while (i < urls.length) {
                LISTS.put(urls[i], new JLibraryList(urls[i]));
                ++i;
            }
        }
        ProjectDependencyFactory.registerFactory(this);
        ExitCommand.addShutdownHook((ShutdownHook)this);
        Ide.addIdeListener((IdeListener)new 1());
    }

    private static URL javaExecutableNoSuffix(JDK jdk) {
        return URLFactory.newFileURL((String)URLFileSystem.getPathNoExt((URL)jdk.getJavaExecutable()));
    }

    private static void checkJDK(Project project) {
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)project);
        JDK jdk = libs.getJDK();
        if (!URLFileSystem.isRegularFile((URL)jdk.getJavaExecutable()) && !URLFileSystem.isRegularFile((URL)JLibraryManager.javaExecutableNoSuffix(jdk))) {
            String title = LibraryArb.getString(17);
            String message = LibraryArb.format(3, project.getShortLabel());
            if (MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)title, null)) {
                Context context = Context.newIdeContext();
                context.setProject(project);
                String[] path = new String[]{JProjectArb.getString(163)};
                ProjectPropertiesDialog.showDialog((Context)context, (Frame)Ide.getMainWindow(), (Project)project, (String[])path);
            }
        }
    }

    private static JDK findOrCreateDefaultJDK() {
        String home = System.getProperty("java.home");
        String ver = System.getProperty("java.version");
        URL homeURL = URLFactory.newDirURL((String)home);
        URL binURL = URLFactory.newDirURL((URL)homeURL, (String)"bin");
        URL exeURL = URLFactory.newURL((URL)binURL, (String)"java.exe");
        if (!URLFileSystem.exists((URL)exeURL)) {
            exeURL = URLFactory.newURL((URL)binURL, (String)"java");
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL temp = URLFactory.newURL((URL)er.getSystemDirectory(Ide.getProductID()), (String)(ver + JDK_EXTENSION));
        JDK usrJDK = JLibraryManager.getUserLibraries().findJDK(temp);
        if (usrJDK != null) {
            if (!exeURL.equals(usrJDK.getJavaExecutable())) {
                HashStructure hash = HashStructure.newInstance();
                usrJDK = new JDKAdapter(hash);
                JDKUtil.initJDK(usrJDK, exeURL);
            }
        } else {
            usrJDK = JLibraryManager.getUserLibraries().addJDK(ver, exeURL);
        }
        if (usrJDK != null) {
            return JLibraryManager.getAddinLibraries().loadJDK(LibraryArb.format(10, new String[]{ver}), usrJDK.getClassPath(), usrJDK.getSourcePath(), usrJDK.getDocPath(), usrJDK.getJavaExecutable(), usrJDK.getJavaVersion(), usrJDK.getSDKBinDir());
        }
        return null;
    }

    private static JLibraryList _createLibraryList(URL url) {
        return new JLibraryList(url);
    }

    public void attach(Observer observer) {
        _delegate.attach(observer);
    }

    public void detach(Observer observer) {
        _delegate.detach(observer);
    }

    public void notifyObservers(Object subject, UpdateMessage change) {
        _delegate.notifyObservers(subject, change);
    }

    static void maS$checkJDK(Project project) {
        JLibraryManager.checkJDK(project);
    }

    final class oracle.jdeveloper.library.JLibraryManager$1
    extends IdeAdapter {
        public void mainWindowOpened(IdeEvent e) {
            1 pcl = new 1();
            Project.addProjectChangeListener((String)"###", (ProjectChangeListener)pcl);
            Iterator iterator = NodeFactory.getOpenNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof Project)) continue;
                JLibraryManager.maS$checkJDK((Project)node);
            }
        }

        final class oracle.jdeveloper.library.JLibraryManager$1$1
        extends ProjectChangeListener {
            public void projectOpened(Project project) {
                SwingUtilities.invokeLater(new 1(this, project));
            }

            final class 1
            implements Runnable {
                private final /* synthetic */ Project v$project;
                final /* synthetic */ oracle.jdeveloper.library.JLibraryManager$1$1 this$0;

                public void run() {
                    JLibraryManager.maS$checkJDK(this.v$project);
                }

                public 1(oracle.jdeveloper.library.JLibraryManager$1$1 var1_1, Project project) {
                    this.v$project = project;
                    this.this$0 = var1_1;
                }
            }
        }
    }
}

