/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.jdeveloper.library.AbstractLibrary;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.resource.LibraryArb;

public final class AddinJDK
extends AbstractLibrary
implements JDK {
    private final String _name;
    private final URLPath _clsPath;
    private final URLPath _srcPath;
    private final URLPath _docPath;
    private final URL _exeURL;
    private final VersionNumber _version;
    private final URL _sdkBinDir;
    private String[] _VMs;

    public AddinJDK(String name, URLPath clsPath, URLPath srcPath, URLPath docPath, URL exeURL, VersionNumber version, URL sdkBinDir) {
        this._name = name;
        this._clsPath = new URLPath(clsPath);
        this._srcPath = new URLPath(srcPath);
        this._docPath = new URLPath(docPath);
        this._exeURL = exeURL;
        this._version = version;
        this._sdkBinDir = sdkBinDir;
    }

    public String getName() {
        return this._name;
    }

    public URLPath getClassPath() {
        return this._clsPath;
    }

    public URLPath getSourcePath() {
        return this._srcPath;
    }

    public URLPath getDocPath() {
        return this._docPath;
    }

    public URL getJavaExecutable() {
        return this._exeURL;
    }

    public void setJavaExecutable(URL url) {
    }

    public synchronized String[] getInstalledVMs() {
        URL url;
        if (this._VMs == null && (url = this.getSDKBinDir()) != null) {
            this._VMs = JDKUtil.getVMChoices(url, false);
        }
        return this._VMs != null ? this._VMs : new String[]{};
    }

    public void setInstalledVMs(String[] installedVMs) {
    }

    public VersionNumber getJavaVersion() {
        return this._version;
    }

    public void setJavaVersion(VersionNumber ver) {
    }

    public URL getSDKBinDir() {
        return this._sdkBinDir;
    }

    public void setSDKBinDir(URL url) {
    }

    public String getSDKBinJavaExecutableNoConsole() {
        URL url = this.getSDKBinDir();
        if (url != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    public String getJavaExecutableNoConsole() {
        URL url = this.getJavaExecutable();
        if (url != null && (url = URLFileSystem.getParent((URL)url)) != null) {
            return JDKUtil.getJavaExecutableNoConsolePath(url);
        }
        return null;
    }

    public String getShortLabel() {
        return this._name;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return LibraryArb.getIcon(15);
    }
}

