/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Recognizer;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourcePreferences;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.java.provider.ProviderContext;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;

public class JdevProviderContext
extends ProviderContext {
    protected static final Class JAVACLASSNODE_CLASS = JavaClassNode.class;
    protected static final Class JAVASOURCENODE_CLASS = JavaSourceNode.class;
    private final boolean allowInMemory;
    private static WeakReference preferencesRef = null;
    protected Map<URL, NodeObserver> _urlToObserverMap;

    public JdevProviderContext(boolean allowInMemoryIn) {
        this.$init$();
        this.allowInMemory = allowInMemoryIn;
    }

    protected final int getFileType(URL url) {
        Class nodeClass = Recognizer.recognizeURL((URL)url);
        if (nodeClass != null) {
            if (JAVASOURCENODE_CLASS.isAssignableFrom(nodeClass)) {
                return 2;
            }
            if (JAVACLASSNODE_CLASS.isAssignableFrom(nodeClass)) {
                return 1;
            }
        }
        return super.getFileType(url);
    }

    protected final SourcePreferences getSourcePreferences() {
        SourcePreferences p = this.getSourcePreferencesImpl();
        if (p == null) {
            return null;
        }
        SourcePreferences copy = SourcePreferences.createCascadingPreferences((SourcePreferences)p);
        return copy;
    }

    private SourcePreferences getSourcePreferencesImpl() {
        SourcePreferences p;
        WeakReference ref = preferencesRef;
        if (ref != null && (p = (SourcePreferences)ref.get()) != null) {
            return p;
        }
        try {
            CodingStyleManager csm = CodingStyleManager.getCodingStyleManager();
            if (csm == null) {
                SourcePreferences sourcePreferences = null;
                return sourcePreferences;
            }
            CodingStyleOptions o = csm.getCodingStyleOptions();
            SourcePreferences p2 = o.getSourcePreferences();
            if (p2 == null) {
                SourcePreferences sourcePreferences = null;
                return sourcePreferences;
            }
            SourcePreferences sourcePreferences = p2;
            return sourcePreferences;
        }
        catch (NullPointerException e) {
            SourcePreferences sourcePreferences = null;
            return sourcePreferences;
        }
    }

    public SourceFile createSourceFile(URL sourceURL, int j2se) throws IOException, IllegalArgumentException {
        try {
            Node node = NodeFactory.findOrCreate((URL)sourceURL);
            if (node != null) {
                if (!node.isNew()) {
                    SourceFile sourceFile = null;
                    return sourceFile;
                }
                boolean isSource = node instanceof JavaSourceNode;
                boolean isText = node instanceof TextNode;
                if (!isSource && isText) {
                    String suffix = URLFileSystem.getSuffix((URL)sourceURL);
                    isSource = suffix.equals(".java");
                }
                if (isSource) {
                    OutputStream os = URLFileSystem.openOutputStream((URL)sourceURL);
                    os.close();
                    SourceFile sourceFile = this.getSourceFile(sourceURL, j2se);
                    return sourceFile;
                }
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unrecognized url: " + sourceURL);
    }

    public SourceFile getSourceFile(URL url, int j2se) {
        return this.getSourceFileImpl(url, j2se);
    }

    public boolean writeSourceFile(SourceFile file) {
        Node node;
        URL url;
        if (!Ide.isRunning() && (url = file.getURL()) != null && (node = NodeFactory.find((URL)url)) instanceof TextNode) {
            try {
                node.save();
            }
            catch (IOException e) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    protected TextBuffer getTextBuffer(URL url) {
        Class nodeClass = Recognizer.recognizeURL((URL)url);
        if (nodeClass != null) {
            boolean isText;
            boolean isSource = JavaSourceNode.class.isAssignableFrom(nodeClass);
            boolean isClass = !isSource && JavaClassNode.class.isAssignableFrom(nodeClass);
            boolean bl = isText = !isSource && !isClass && TextNode.class.isAssignableFrom(nodeClass);
            if (isText) {
                String suffix = URLFileSystem.getSuffix((URL)url);
                isSource = suffix.equals(".java");
            }
            if (isSource || isClass) {
                try {
                    boolean existsOnDisk = URLFileSystem.exists((URL)url);
                    Node node = NodeFactory.find((URL)url);
                    if (node != null && !existsOnDisk) {
                        if (!this.allowInMemory && !node.isDirty()) {
                            TextBuffer textBuffer = null;
                            return textBuffer;
                        }
                    } else if (node == null && existsOnDisk) {
                        node = NodeFactory.findOrCreate((URL)url);
                    }
                    if (node != null) {
                        if (node instanceof TextNode) {
                            TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
                            return textBuffer;
                        }
                        TextBuffer textBuffer = null;
                        return textBuffer;
                    }
                }
                catch (InstantiationException e) {
                    TextBuffer textBuffer = null;
                    return textBuffer;
                }
                catch (IllegalAccessException e) {
                    TextBuffer textBuffer = null;
                    return textBuffer;
                }
            }
        }
        return null;
    }

    private void $init$() {
        this._urlToObserverMap = new Maps.CacheMap(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startTracking(URL url) {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            Node node;
            if (!this._urlToObserverMap.containsKey(url) && (node = NodeFactory.find((URL)url)) != null) {
                NodeObserver observer = new NodeObserver(node, url);
                this._urlToObserverMap.put(url, observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopTracking(URL url) {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            this._urlToObserverMap.remove(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearTracking() {
        Map<URL, NodeObserver> map = this._urlToObserverMap;
        synchronized (map) {
            for (NodeObserver observer : this._urlToObserverMap.values()) {
                if (observer == null) continue;
                NodeObserver.mav$detachSelf(observer, null);
            }
            this._urlToObserverMap.clear();
        }
    }

    protected class NodeObserver
    extends NodeListener {
        private URL _sourceURL;

        protected NodeObserver(Node node, URL sourceURL) {
            this._sourceURL = sourceURL;
            node.addNodeListener((NodeListener)this);
        }

        private void detachSelf(Node node) {
            if (node == null) {
                node = NodeFactory.find((URL)this._sourceURL);
            }
            if (node != null) {
                node.removeNodeListener((NodeListener)this);
            }
        }

        private void initiateExpire() {
            if (JdevProviderContext.this.provider != null) {
                JdevProviderContext.this.provider.notifyOfChange(this._sourceURL);
            }
        }

        private void initiateDetach(Node node) {
            JdevProviderContext.this.stopTracking(this._sourceURL);
            this.detachSelf(node);
        }

        public void nodeClosed(NodeEvent event) {
            this.initiateDetach(event.getNode());
            this.initiateExpire();
        }

        public void nodeRenamed(NodeEvent event, URL oldURL, URL newURL) {
            this.initiateDetach(event.getNode());
            this.initiateExpire();
        }

        static void mav$detachSelf(NodeObserver nodeObserver, Node node) {
            nodeObserver.detachSelf(node);
        }
    }
}

