/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.ide.model.DependencyConfiguration;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Observer;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.performance.PerformanceLogger;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.jdeveloper.java.JavaModelFactory;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;
import oracle.jdeveloper.java.locator.ClassLocatorFactory;
import oracle.jdeveloper.java.locator.JdevClassLocatorFactory;
import oracle.jdeveloper.java.provider.ProjectFileProvider;
import oracle.jdeveloper.java.util.ClassFileCache;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.ProjectLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.buildtools.ModuleConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class ProjectClassLocator
extends BaseClassLocator {
    protected static final boolean EXPORTED_LIBRARIES = true;
    protected static final boolean ALL_LIBRARIES = false;
    private Project _project;
    private BaseClassLocator _jdkLocator;
    private BaseClassLocator _libraryLocator;
    private BaseClassLocator _dependentLibraryLocator;
    private BaseClassLocator _dependentPathLocator;
    private BaseClassLocator _outputLocator;
    private BaseClassLocator _addedClassLocator;
    private BaseClassLocator _moduleConfigLocator;
    private BaseClassLocator _sourceLocator;
    private Observer _dependencyObserver;

    protected ProjectClassLocator(Project project) {
        this.$init$();
        this._project = project;
        PerformanceLogger.get().startTiming("ProjectClassLocator");
        try {
            Library jdkLibrary = this.getJDKFor(project);
            this._jdkLocator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(jdkLibrary));
            Library[] libraries = this.getLibrariesFor(project, false);
            this._libraryLocator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(libraries));
            ClassLocatorFactory factory = JavaModelFactory.getInstance().getLocatorFactory();
            URL outputURL = this.getOutputURLFor(project);
            this._outputLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(outputURL));
            URLPath moduleConfigPath = this.getModuleConfigClassPathFor(project);
            this._moduleConfigLocator = moduleConfigPath != null ? ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(moduleConfigPath)) : BaseClassLocator.EMPTY_LOCATOR;
            URLPath additionalPath = this.getAddedClassPathFor(project);
            JLibraryManager mgr = JLibraryManager.getInstance();
            for (DynamicLibraryProvider provider : mgr.getDynamicLibraryProviders()) {
                provider.updateClassPath(project, additionalPath);
            }
            this._addedClassLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getClassLocator(additionalPath));
            URLPath sourcePath = ProjectClassLocator.getSourcePathFor(project);
            this._sourceLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getSourceLocator(sourcePath));
            ArrayList dependentLibraryList = new ArrayList(25);
            URLPath dependentSourcePath = new URLPath(50);
            URLPath dependentClassPath = new URLPath(50);
            this.processDependenciesRecurse(project, new ArrayList(), dependentLibraryList, dependentSourcePath, dependentClassPath, false);
            List<Library> libraryCollection = libraries == null ? BaseClassLocator.EMPTY_COLLECTION : Arrays.asList(libraries);
            dependentLibraryList.removeAll(libraryCollection);
            int dependentLibraryCount = dependentLibraryList.size();
            Library[] dependentLibraries = dependentLibraryList.toArray(new Library[dependentLibraryCount]);
            this._dependentLibraryLocator = ProjectClassLocator.ensureValid((BaseClassLocator)JdevClassLocatorFactory.getLibraryLocator(dependentLibraries));
            dependentSourcePath.remove(sourcePath);
            dependentClassPath.remove(additionalPath);
            dependentClassPath.remove(outputURL);
            this._dependentPathLocator = ProjectClassLocator.ensureValid((BaseClassLocator)factory.getPathLocator(dependentSourcePath, dependentClassPath));
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator", "ProjectClassLocator() for " + this._project.getShortLabel());
        }
    }

    protected void processDependenciesRecurse(Project project, List traversedList, List libraryList, URLPath sourcePath, URLPath classPath, boolean exportsOnly) {
        if (traversedList.contains(project)) {
            return;
        }
        traversedList.add(project);
        Library[] libraries = this.getLibrariesFor(project, exportsOnly);
        int libraryCount = libraries == null ? 0 : libraries.length;
        int i = 0;
        while (i < libraryCount) {
            Library library = libraries[i];
            if (!libraryList.contains(library)) {
                libraryList.add(library);
            }
            ++i;
        }
        URLPath currentSourcePath = ProjectClassLocator.getSourcePathFor(project);
        sourcePath.add(currentSourcePath);
        URL currentOutURL = this.getOutputURLFor(project);
        URLPath moduleConfigPath = this.getModuleConfigClassPathFor(project);
        URLPath currentAddedPath = this.getAddedClassPathFor(project);
        classPath.add(currentOutURL);
        if (moduleConfigPath != null) {
            classPath.add(moduleConfigPath);
        }
        classPath.add(currentAddedPath);
        Collection dependents = ProjectClassLocator.getDependentsFor(project);
        for (Object dependent : dependents) {
            if (dependent == null) continue;
            if (dependent instanceof ProjectLibrary) {
                Project dependentProject = (Project)((ProjectLibrary)dependent).getSource();
                dependentProject.attach(this._dependencyObserver);
                this.processDependenciesRecurse(dependentProject, traversedList, libraryList, sourcePath, classPath, true);
                continue;
            }
            if (!(dependent instanceof Library) || libraryList.contains(dependent)) continue;
            libraryList.add(dependent);
        }
    }

    public static Collection getDependentsFor(Project project) {
        DependencyConfiguration dependencyConfiguration = DependencyConfiguration.getInstance((Project)project);
        List dependList = dependencyConfiguration.getDependencyList();
        return dependList == null ? BaseClassLocator.EMPTY_COLLECTION : dependList;
    }

    protected URLPath getAddedClassPathFor(Project project) {
        JProjectPaths projectPaths = JProjectPaths.getInstance((PropertyStorage)project);
        return projectPaths.getAdditionalClassPath();
    }

    protected URLPath getModuleConfigClassPathFor(Project project) {
        ModuleConfiguration moduleConfig = ModuleConfiguration.getInstance(project);
        if (moduleConfig != null) {
            return moduleConfig.getClassPath();
        }
        return null;
    }

    protected URL getOutputURLFor(Project project) {
        JavaProject javaProject = JavaProject.getInstance(project);
        return javaProject.getOutputDirectory();
    }

    public static URLPath getSourcePathFor(Project project) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project);
        return pathsConfiguration.getProjectSourcePath();
    }

    protected Library getJDKFor(Project project) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        return projectLibraries.getJDK();
    }

    protected Library[] getLibrariesFor(Project project, boolean exportsOnly) {
        JProjectLibraries projectLibraries = JProjectLibraries.getInstance((PropertyStorage)project);
        if (exportsOnly) {
            return projectLibraries.getExports();
        }
        return projectLibraries.getLibraries();
    }

    public void buildIndex() {
        PerformanceLogger.get().startTiming("ProjectClassLocator.buildIndex");
        try {
            this._sourceLocator.buildIndex();
            this._outputLocator.buildIndex();
            this._moduleConfigLocator.buildIndex();
            this._addedClassLocator.buildIndex();
            this._libraryLocator.buildIndex();
            this._jdkLocator.buildIndex();
            this._dependentLibraryLocator.buildIndex();
            this._dependentPathLocator.buildIndex();
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.buildIndex", "ProjectClassLocator.buildIndex() for " + this._project.getShortLabel());
        }
    }

    protected void getPackages(String packagePrefix, Collection out) {
        this._sourceLocator.getPackages(packagePrefix, out);
        this._outputLocator.getPackages(packagePrefix, out);
        this._moduleConfigLocator.getPackages(packagePrefix, out);
        this._addedClassLocator.getPackages(packagePrefix, out);
        this._dependentPathLocator.getPackages(packagePrefix, out);
        this._dependentLibraryLocator.getPackages(packagePrefix, out);
        this._libraryLocator.getPackages(packagePrefix, out);
        this._jdkLocator.getPackages(packagePrefix, out);
    }

    protected void getClassesInPackage(String packagePrefix, Collection out) {
        this._sourceLocator.getClassesInPackage(packagePrefix, out);
        this._outputLocator.getClassesInPackage(packagePrefix, out);
        this._moduleConfigLocator.getClassesInPackage(packagePrefix, out);
        this._addedClassLocator.getClassesInPackage(packagePrefix, out);
        this._dependentPathLocator.getClassesInPackage(packagePrefix, out);
        this._dependentLibraryLocator.getClassesInPackage(packagePrefix, out);
        this._libraryLocator.getClassesInPackage(packagePrefix, out);
        this._jdkLocator.getClassesInPackage(packagePrefix, out);
    }

    protected void getAllClasses(Collection out, ClassNameFilter filter) {
        PerformanceLogger.get().startTiming("ProjectClassLocator.getAllClasses");
        try {
            this._sourceLocator.getAllClasses(out, filter);
            this._outputLocator.getAllClasses(out, filter);
            this._moduleConfigLocator.getAllClasses(out, filter);
            this._addedClassLocator.getAllClasses(out, filter);
            this._dependentPathLocator.getAllClasses(out, filter);
            this._dependentLibraryLocator.getAllClasses(out, filter);
            this._libraryLocator.getAllClasses(out, filter);
            this._jdkLocator.getAllClasses(out, filter);
        }
        finally {
            PerformanceLogger.get().stopTiming("ProjectClassLocator.getAllClasses", "ProjectClassLocator.getAllClasses() for " + this._project.getShortLabel() + ": " + out.size() + " classes found");
        }
    }

    protected void getAllPackages(Collection out, PackageNameFilter filter) {
        this._sourceLocator.getAllPackages(out, filter);
        this._outputLocator.getAllPackages(out, filter);
        this._moduleConfigLocator.getAllPackages(out, filter);
        this._addedClassLocator.getAllPackages(out, filter);
        this._dependentPathLocator.getAllPackages(out, filter);
        this._dependentLibraryLocator.getAllPackages(out, filter);
        this._libraryLocator.getAllPackages(out, filter);
        this._jdkLocator.getAllPackages(out, filter);
    }

    public URL getURL(String fqClassName) {
        URL classURL = this._outputLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (classURL != null || sourceURL != null) {
            long sourceTime;
            if (classURL == null) {
                return sourceURL;
            }
            if (sourceURL == null && (sourceURL = this.getSourceURLfromClassFile(classURL, fqClassName)) == null) {
                return classURL;
            }
            long classTime = URLFileSystem.lastModified((URL)classURL);
            Node node = NodeFactory.find((URL)sourceURL);
            long l = sourceTime = node != null && node.isOpen() ? node.getTimestamp() : URLFileSystem.lastModified((URL)sourceURL);
            if (classTime >= sourceTime) {
                return classURL;
            }
            return sourceURL;
        }
        classURL = this._jdkLocator.getURL(fqClassName);
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentPathLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentLibraryLocator.getURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getURL(fqClassName);
        }
        return classURL;
    }

    public URL getProjectSourceURL(String fqClassName, boolean includeDependencies) {
        URL sourceURL = this._sourceLocator.getSourceURL(fqClassName);
        if (sourceURL == null && includeDependencies) {
            sourceURL = this._dependentPathLocator.getSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getNonProjectSourceURL(String fqClassName) {
        URL sourceURL = this._jdkLocator.getSourceURL(fqClassName);
        if (sourceURL == null) {
            sourceURL = this._dependentLibraryLocator.getSourceURL(fqClassName);
        }
        if (sourceURL == null) {
            sourceURL = this._libraryLocator.getSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getSourceURL(String fqClassName) {
        URL sourceURL = this.getProjectSourceURL(fqClassName, true);
        if (sourceURL == null) {
            sourceURL = this.getNonProjectSourceURL(fqClassName);
        }
        return sourceURL;
    }

    public URL getClassURL(String fqClassName) {
        URL classURL = this._jdkLocator.getClassURL(fqClassName);
        if (classURL == null) {
            classURL = this._outputLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._moduleConfigLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._addedClassLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentPathLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._dependentLibraryLocator.getClassURL(fqClassName);
        }
        if (classURL == null) {
            classURL = this._libraryLocator.getClassURL(fqClassName);
        }
        return classURL;
    }

    public URL getResourceURL(String resourceName) {
        URL resourceURL = this._jdkLocator.getResourceURL(resourceName);
        if (resourceURL == null) {
            resourceURL = this._outputLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._moduleConfigLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._addedClassLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._dependentPathLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._dependentLibraryLocator.getResourceURL(resourceName);
        }
        if (resourceURL == null) {
            resourceURL = this._libraryLocator.getResourceURL(resourceName);
        }
        return resourceURL;
    }

    private URL getSourceURLfromClassFile(URL classURL, String fqClassName) {
        String sourceFileName;
        ClassFile classFile;
        int dot = fqClassName.lastIndexOf(46);
        if (dot > 0 && (classFile = ClassFileCache.getClassFile((URL)classURL)) != null && (sourceFileName = classFile.getSourceFilename()) != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(fqClassName.substring(0, dot + 1));
            dot = sourceFileName.lastIndexOf(46);
            if (dot > 0) {
                buf.append(sourceFileName.substring(0, dot));
            } else {
                buf.append(sourceFileName);
            }
            return this._sourceLocator.getSourceURL(buf.toString());
        }
        return null;
    }

    private void $init$() {
        this._dependencyObserver = new 1();
    }

    static Project ra$_project(ProjectClassLocator projectClassLocator) {
        return projectClassLocator._project;
    }

    final class 1
    implements Observer {
        public void update(Object observed, UpdateMessage change) {
            int id;
            if (observed instanceof Project && (id = change.getMessageID()) == UpdateMessage.PROPERTY_SET && (change.containsProperty("classPath") || change.containsProperty("sourcePath") || change.containsProperty("exportedReferences"))) {
                this.detachObserverFromDependents();
                ProjectFileProvider.getInstance(ProjectClassLocator.ra$_project(ProjectClassLocator.this)).handleProjectPathsChange();
            }
        }

        private void detachObserverFromDependents() {
            Collection dependents = ProjectClassLocator.getDependentsFor(ProjectClassLocator.ra$_project(ProjectClassLocator.this));
            for (Object dep : dependents) {
                if (!(dep instanceof ProjectLibrary)) continue;
                ((ProjectLibrary)dep).getProject().detach((Observer)this);
            }
        }
    }
}

